/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.aclas;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;
import purejavacomm.CommPortIdentifier;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;
import ro.atreides.ecr.EcrLogic;
import ro.atreides.ecr.aclas.AclasPersistentListDefaultImpl;
import ro.atreides.ecr.aclas.noarch.AclasImpl;
import ro.atreides.ecr.aclas.noarch.AclasPersistentList;
import ro.atreides.ecr.datecs.nativeImpl.PortSettingsPureJava;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.tricky.NonPrintedBonInterface;
import ro.deversoft.utils.noarch.Logger;
import ro.deversoft.utils.noarch.UtilsNoarch;

public class AclasDefaultImpl
extends AclasImpl {
    private Socket a;
    private SerialPort b;

    public AclasDefaultImpl(String string) {
        super(string);
    }

    @Override
    protected void logException(Exception exception) {
        Logger.logException(this, exception);
    }

    @Override
    protected void logError(AclasImpl aclasImpl, Object object) {
        Logger.logError((Object)this, object.toString());
    }

    @Override
    protected AclasPersistentList getPersistentList() {
        return new AclasPersistentListDefaultImpl(0);
    }

    @Override
    protected void ecrConnected(boolean bl) {
        EcrLogic.getInstance().ecrConnected(bl);
    }

    @Override
    protected boolean connectSerial() throws IOException {
        try {
            Object object;
            this.b = null;
            boolean bl = false;
            CommPortIdentifier commPortIdentifier = null;
            Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
            while (enumeration.hasMoreElements()) {
                commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
                object = this.portName.replace("/dev/", "");
                String string = commPortIdentifier.getName();
                if (!string.equalsIgnoreCase(this.portName) && !string.equalsIgnoreCase((String)object)) continue;
                Logger.logDebug(this, "Found port: " + this.portName);
                bl = true;
                break;
            }
            if (!bl) {
                DialogUtils.errorDialog(GuiUtils.currentFrame, "aclas: port incorect : \"" + this.portName + "\". Corectati si reporniti !!", LangRoAll.nuPotContinua);
                return false;
            }
            object = new PortSettingsPureJava();
            ((PortSettingsPureJava)object).setName(this.portName);
            ((PortSettingsPureJava)object).setSpeed(9600);
            ((PortSettingsPureJava)object).setDataBits(8);
            ((PortSettingsPureJava)object).setStopBits(1);
            ((PortSettingsPureJava)object).setPariry(0);
            this.b = (SerialPort)commPortIdentifier.open("aclas", 2000);
            this.inS = this.b.getInputStream();
            this.outS = this.b.getOutputStream();
            this.b.setSerialPortParams(((PortSettingsPureJava)object).getSpeed(), ((PortSettingsPureJava)object).getDataBits(), ((PortSettingsPureJava)object).getStopBits(), ((PortSettingsPureJava)object).getPariry());
            return true;
        }
        catch (PortInUseException portInUseException) {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "aclas: port ocupat : \"" + this.portName + "\" .<br> Verificati ce aplicatii folosesc portul, SAU incercati mai tarziu, SAU restart", LangRoAll.nuPotContinua);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            Logger.logException(this, (Exception)((Object)unsupportedCommOperationException));
        }
        return false;
    }

    @Override
    protected boolean connectTCP() {
        try {
            Vector vector = UtilsNoarch.splitString(this.portName, '=');
            if (vector.size() < 3 || !Validators.correctString((String)vector.get(1)) || !Validators.correctInteger((String)vector.get(2))) {
                Logger.logError((Object)this, "Configurare incorecta . Eroare fatala!!");
                UtilsNoarch.systemExit();
            }
            String string = (String)vector.get(1);
            int n = Integer.parseInt((String)vector.get(2));
            this.a = new Socket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            this.a.connect(inetSocketAddress);
            this.inS = this.a.getInputStream();
            this.outS = this.a.getOutputStream();
            return true;
        }
        catch (IOException iOException) {
            Logger.logException(this, (Exception)iOException);
            return false;
        }
    }

    @Override
    protected void closeSocket() {
        if (this.a != null) {
            try {
                this.a.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    protected void closeSerialPort() {
        if (this.b != null) {
            try {
                this.b.close();
                return;
            }
            catch (Exception exception) {}
        }
    }

    @Override
    protected void errorDialog(String string, String string2) {
        DialogUtils.errorDialog(GuiUtils.currentFrame, string, string2);
    }

    public void deleteNonPrintedBons(NonPrintedBonInterface nonPrintedBonInterface) {
        this.outQueue.clear();
    }
}

