/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrFeedbackInterface;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.ecr.datecs.CasaDeMarkatXmlHandler;
import ro.atreides.ecr.datecs.nativeImpl.MP55Impl;
import ro.atreides.ecr.datecs.nativeImpl.MP55Interface;
import ro.atreides.ecr.datecs.nativeImpl.PortSettingsPureJava;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.plati.TipPlata;
import ro.deversoft.utils.noarch.Logger;
import ro.deversoft.utils.noarch.UtilsNoarch;

public class Generic
extends AbstractCashRegister {
    private CasaDeMarkatXmlHandler a;
    protected MP55Interface casa;
    protected boolean forceTotal;
    protected boolean forceTotalAt2Decimals;
    protected boolean discountGlobal;
    protected boolean errorNotifications;
    protected boolean discountLaProdus;
    protected Vector ecrLicenseCode = new Vector();
    private String b;
    private String c;
    protected int ecrId = 0;
    private Object d = new Object();
    protected Vector<String> filters = new Vector();
    private boolean e;
    protected boolean rts = false;
    protected PortSettingsPureJava.SerialLibrary serialLibraryType = PortSettingsPureJava.SerialLibrary.PURE_JAVA;

    @Override
    public void buildConfiguration(Properties properties) {
        String string;
        super.buildConfiguration(properties);
        this.b = properties.getProperty("discountText", "Discount");
        this.c = properties.getProperty("adaosText", "Adaos");
        this.forceTotal = Boolean.parseBoolean(properties.getProperty("forceTotal", "false"));
        this.forceTotalAt2Decimals = Boolean.parseBoolean(properties.getProperty("forceTotalAt2Decimals", "false"));
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (!string.startsWith("datecs.ecr.code.")) continue;
            string = properties.getProperty(string);
            this.ecrLicenseCode.add(string);
        }
        string = properties.getProperty("ecrLicenceCode");
        if (Validators.correctString(string)) {
            this.ecrLicenseCode.add(string);
        }
        this.ecrLicenseCode.add("917b203efec1c523103f234b21b83e53bc3bed1");
        this.discountGlobal = Boolean.parseBoolean(properties.getProperty("discountGlobal", "false"));
        this.discountLaProdus = Boolean.parseBoolean(properties.getProperty("discountLaProdus", "false"));
        this.errorNotifications = Boolean.parseBoolean(properties.getProperty("errorNotifications", "true"));
        this.ecrId = Integer.parseInt(properties.getProperty("ecrId", "0"));
        string = properties.getProperty("ecrPortFilters", "/dev/ttyS.,/dev/ttyUSB.,COM.");
        this.filters = UtilsNoarch.splitString(string, ',');
        if (this.discountLaProdus) {
            this.discountGlobal = false;
        }
        this.e = Boolean.parseBoolean(properties.getProperty("useDefaultXmlHandler", "true"));
        this.rts = Boolean.parseBoolean(properties.getProperty("rts", "false"));
        this.serialLibraryType = PortSettingsPureJava.SerialLibrary.valueOf(properties.getProperty("serialLibraryType", "PURE_JAVA"));
        System.out.println("Filters: " + this.filters + " ecrId : " + this.ecrId);
    }

    @Override
    public void addLicenseCode(String string) {
        this.ecrLicenseCode.add(string);
    }

    @Override
    public boolean ecrConnectedAtStartup() {
        return false;
    }

    public Generic() {
        this.a = new CasaDeMarkatXmlHandler();
    }

    public void processBonFiscal(String string, String string2, int n) {
        System.out.println("Received bonId \"" + string2 + "\" items \"" + string + "\"");
        if (this.casa != null) {
            this.casa.process(string, n, string2);
        }
    }

    @Override
    public synchronized void stopECR() {
        Logger.logVerbose(this, "STOPING ECR DRIVER");
        this.casa.stop();
    }

    @Override
    public synchronized void startECR() {
        Logger.logVerbose(this, "STARTING ECR DRIVER");
        Vector<EcrFeedbackInterface> vector = new Vector();
        if (this.casa != null) {
            this.casa.stop();
            vector = this.casa.getListeners();
        }
        this.casa = new MP55Impl(this.ecrLicenseCode, this.ecrId, vector, this.rts, this.serialLibraryType);
        this.casa.setForceTotal(this.forceTotal);
        this.casa.setFilters(this.filters);
        this.casa.setErrorNotifications(this.errorNotifications);
        this.casa.start();
    }

    @Override
    public void processXml(String string) {
        if (this.e) {
            super.processXml(string);
            return;
        }
        try {
            this.a.resetBuffer();
            this.a.setMaxGrp(ecrMaxGrp);
            this.a.setMinGrp(ecrMinGrp);
            Utils.importXml((DefaultHandler)this.a, string);
            string = this.a.getBuffer().toUpperCase();
            String string2 = this.a.getIdBon();
            Logger.logDebug(this, "Received from xml bon:" + string2);
            Logger.logDebugVerbose(this, "Received from xml, content = " + string);
            int n = this.a.getIdOrder();
            this.processBonFiscal(string, string2, n);
            return;
        }
        catch (Throwable throwable) {
            Logger.logError((Object)this, throwable);
            return;
        }
    }

    public static String buildBonFiscalText(Vector object, double d2, Vector vector, TipPlata object2, Vector vector2, String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string2, String string3) {
        char c2;
        Object object3;
        Object object4;
        object2 = "";
        object = ((Vector)object).iterator();
        boolean bl5 = false;
        double d3 = 0.0;
        double d4 = 0.0;
        while (object.hasNext()) {
            double d5;
            String string4 = "S,1,______,_,__;";
            object4 = (EcrSale)object.next();
            object3 = ((EcrSale)object4).getProduct().toUpperCase();
            string4 = string4 + UtilsNoarch.getStringMaxSize(22, (String)object3, null, false) + ";";
            double d6 = ((EcrSale)object4).getQuantity();
            double d7 = bl || bl2 ? ((EcrSale)object4).getPpuOriginal() : ((EcrSale)object4).getPpuDupaDiscount();
            double d8 = bl2 ? ((EcrSale)object4).getDiscountUnitar() : 0.0;
            string4 = string4 + Utils.getString2DecimalsNoTrunc(d7) + ";";
            string4 = string4 + Utils.getString3DecimalsNoTrunc(d6) + ";";
            String string5 = Generic.getDepartament((EcrSale)object4);
            string4 = string4 + string5 + ";";
            string4 = string4 + Generic.getGrupa((EcrSale)object4) + ";";
            string5 = ((EcrSale)object4).getCodTva();
            if (Validators.correctString(string5)) {
                string4 = string4 + string5 + ";";
            }
            string4 = string4 + "0;0;";
            object2 = (String)object2 + string4 + "\n";
            double d9 = d7 * ((EcrSale)object4).getQuantity();
            double d10 = ((EcrSale)object4).getPpuOriginal() * ((EcrSale)object4).getQuantity();
            d3 += d10;
            double d11 = (((EcrSale)object4).getPpuOriginal() - ((EcrSale)object4).getPpuDupaDiscount()) * ((EcrSale)object4).getQuantity();
            d4 += d11;
            double d12 = FloatUtils.roundDoubleUp(d9, 1);
            if (d9 != d12) {
                Logger.logWarning(Generic.class.getName(), "2 Zecimale !! " + string4);
                bl5 = true;
            }
            if (d8 == 0.0) continue;
            char c3 = '1';
            String string6 = string2;
            if (d4 < 0.0) {
                c3 = '0';
                d4 = -d4;
                string6 = string3;
            }
            if ((d5 = d11 * 100.0 / d10) == 100.0) {
                d5 = 99.99;
            }
            object2 = (String)object2 + "C,1,______,_,__;" + c3 + ";" + Utils.getString2DecimalsNoTrunc(d5) + ";;;;\n";
            object2 = (String)object2 + "P,1,______,_,__;" + string6 + ";;;;;\n";
        }
        if (vector2.size() > 0) {
            object2 = (String)object2 + "P,1,______,_,__;";
        }
        for (c2 = '\u0000'; c2 < vector2.size(); ++c2) {
            object4 = (String)vector2.elementAt(c2);
            if (!Validators.correctString((String)object4)) {
                object4 = " ";
            }
            object4 = ((String)object4).toUpperCase();
            object3 = Utils.splitEqually((String)object4, 16);
            Iterator<String> iterator = object3.iterator();
            while (iterator.hasNext()) {
                String string7 = iterator.next();
                object2 = (String)object2 + string7 + ";";
            }
        }
        if (vector2.size() > 0) {
            object2 = (String)object2 + ";;;\n";
        }
        if (bl && d4 != 0.0) {
            double d13;
            object2 = (String)object2 + "T,1,______,_,__;4;;;;;\n";
            c2 = '1';
            object4 = string2;
            if (d4 < 0.0) {
                c2 = '0';
                d4 = -d4;
                object4 = string3;
            }
            if ((d13 = d4 * 100.0 / d3) == 100.0) {
                d13 = 99.99;
            }
            object2 = (String)object2 + "C,1,______,_,__;" + c2 + ";" + Utils.getString2DecimalsNoTrunc(d13) + ";;;;\n";
            object2 = (String)object2 + "P,1,______,_,__;" + (String)object4 + ";;;;;\n";
        }
        if (vector == null || vector.size() == 0) {
            object2 = (String)object2 + "T,1,______,_,__;\n";
        } else {
            double d14 = 0.0;
            for (EcrPlata ecrPlata : vector) {
                if (!ecrPlata.isDefault()) {
                    double d15 = ecrPlata.getSuma();
                    object2 = (String)object2 + "T,1,______,_,__;" + ecrPlata.getEcrMapping() + ";" + Utils.getString2DecimalsNoTrunc(d15) + ";;;;\n";
                    d14 += d15;
                    continue;
                }
                if (!(d14 < d2)) continue;
                object2 = (String)object2 + "T,1,______,_,__;" + ecrPlata.getEcrMapping() + ";;;;;\n";
                d14 = d2;
            }
            if (bl3 || d14 < d2 || bl5 && bl4) {
                object2 = (String)object2 + "T,1,______,_,__;\n";
            }
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printBonFiscal(Vector object, double d2, Vector vector, TipPlata tipPlata2, Vector vector2, String string, int n) {
        object = Generic.buildBonFiscalText((Vector)object, d2, vector, tipPlata2, vector2, string, n, this.discountGlobal, this.discountLaProdus, this.forceTotal, this.forceTotalAt2Decimals, this.b, this.c);
        Object object2 = this.d;
        synchronized (object2) {
            this.processBonFiscal((String)object, string, n);
        }
        Logger.logDebugVerbose(this, "Content bon fiscal : " + (String)object);
    }

    @Override
    public void printX() {
    }

    @Override
    public void printZ() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void introduNumerar(double d2) {
        String string;
        if (d2 > 0.0) {
            string = "0";
        } else if (d2 < 0.0) {
            string = "1";
        } else {
            return;
        }
        d2 = Math.abs(d2);
        String string2 = Utils.getString2DecimalsNoTrunc(d2);
        string2 = "I,1,______,_,__;" + string + ";" + string2 + ";;;;\n";
        Object object = this.d;
        synchronized (object) {
            string = Utils.getLocalComputerName() + "_L_numerar";
            this.processBonFiscal(string2, string, -1);
        }
        Logger.logDebugVerbose(this, "Content bon fiscal : " + string2);
    }

    @Override
    public boolean numerarInputReady() {
        return true;
    }

    @Override
    public void finishInitialize() {
        super.finishInitialize();
        this.a.setPaymentTypes(this.paymentTypes);
        this.startECR();
    }

    public void modifyECRparametres(String string, int n) {
        Logger.logVerbose(this, "modifyECRparametres() method does NOT modify ANYTHING, deprecated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceTotal() {
        String string = "T,1,______,_,__;\n";
        Object object = this.d;
        synchronized (object) {
            String string2 = Utils.getLocalComputerName() + "_L_total";
            this.processBonFiscal(string, string2, -1);
        }
        Logger.logDebugVerbose(this, "Content bon fiscal : " + string);
    }

    @Override
    public int getNoOfBonsToPrint() {
        if (this.casa != null) {
            return this.casa.getNoOfBonsToPrint();
        }
        return 0;
    }

    @Override
    public void deleteNonPrintedBons() {
        if (this.inter != null) {
            this.casa.deleteNonPrintedBons(this.inter);
            this.casa.setAnulareBon(true);
            this.stopECR();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                Logger.logException(this, (Exception)interruptedException);
            }
            this.startECR();
        }
    }

    @Override
    public void deleteBonByIdentifier(String string) {
        this.casa.deleteByIdentifier(string);
    }

    @Override
    public void clearFeedbackFile() {
        this.casa.clearFeedbackFile();
    }

    @Override
    public String getFeedbackByIdentifier(String string) {
        return this.casa.getFeedback(string);
    }

    @Override
    public void addListener(EcrFeedbackInterface ecrFeedbackInterface) {
        this.casa.addListener(ecrFeedbackInterface);
    }
}

