/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs;

import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.BonValidatorResponseInterface;
import ro.atreides.ecr.EcrFeedbackInterface;
import ro.atreides.ecr.EcrLogic;
import ro.atreides.ecr.EcrSerialNumberReadInterface;
import ro.atreides.ecr.EcrType;
import ro.atreides.ecr.SerialLibraryType;
import ro.atreides.ecr.datecs.Generic;
import ro.atreides.ecr.datecs.nativeImpl.BonValidator;
import ro.atreides.ecr.datecs.nativeImpl.EcrPortParams;
import ro.atreides.ecr.datecs.nativeImpl.MP55Impl;
import ro.atreides.ecr.datecs.nativeImpl.NewMP55SerialImpl;
import ro.atreides.ecr.datecs.nativeImpl.PortSettingsPureJava;
import ro.atreides.ecr.datecsgen3.UserNotifiyInterface;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.TipPlata;
import ro.deversoft.ecr.noarch.EcrLicenseVerifier;
import ro.deversoft.utils.noarch.Logger;

public class NewMP55
extends AbstractCashRegister {
    private String a = "";
    private int b = 9600;
    private boolean c;
    protected Vector ecrLicenseCode = new Vector();
    protected boolean discountLaProdus;
    private String d;
    private String e;
    protected boolean discountGlobal;
    private UserNotifiyInterface f;
    protected Vector<EcrFeedbackInterface> feedbackListeners = new Vector();
    private NewMP55SerialImpl g;
    private boolean h;
    private boolean i;
    private boolean j;
    private PortSettingsPureJava.SerialLibrary k;
    private boolean l;
    private Integer m;

    @Override
    public void buildConfiguration(Properties properties) {
        String string;
        super.buildConfiguration(properties);
        this.a = properties.getProperty("ecrPort");
        this.b = Integer.parseInt(properties.getProperty("ecrSpeed", "9600"));
        this.c = Boolean.parseBoolean(properties.getProperty("errorNotifications", "true"));
        this.discountGlobal = Boolean.parseBoolean(properties.getProperty("discountGlobal", "false"));
        this.discountLaProdus = Boolean.parseBoolean(properties.getProperty("discountLaProdus", "false"));
        this.d = properties.getProperty("discountText", "Discount");
        this.e = properties.getProperty("adaosText", "Adaos");
        Object object = properties.propertyNames();
        while (object.hasMoreElements()) {
            string = (String)object.nextElement();
            if (!string.startsWith("datecs.ecr.code.")) continue;
            string = properties.getProperty(string);
            this.ecrLicenseCode.add(string);
        }
        string = properties.getProperty("ecrLicenceCode");
        if (Validators.correctString(string)) {
            this.ecrLicenseCode.add(string);
        }
        this.ecrLicenseCode.add("917b203efec1c523103f234b21b83e53bc3bed1");
        this.h = Boolean.parseBoolean(properties.getProperty("rts", "false"));
        this.j = Boolean.parseBoolean(properties.getProperty("shortTake", "false"));
        string = properties.getProperty("flowControl");
        if (Validators.correctInteger(string)) {
            this.m = Integer.parseInt(string);
        }
        object = SerialLibraryType.valueOf(properties.getProperty(EcrLogic.ECR_GUI_CONFIGS.SERIAL_TYPE.toString(), SerialLibraryType.PureJava.toString()));
        this.i = ((SerialLibraryType)((Object)object)).isForceDtr();
        this.k = ((SerialLibraryType)((Object)object)).getLibrary();
        this.l = Boolean.parseBoolean(properties.getProperty("processCrcErrors", "false"));
    }

    @Override
    public boolean start() {
        return true;
    }

    @Override
    public synchronized void startECR() {
        Logger.logVerbose(this, "STARTING ECR DRIVER NewMP55");
        this.f = new UserNotifiyInterface(this){
            private /* synthetic */ NewMP55 a;
            {
                this.a = newMP55;
            }

            @Override
            public final void showTextToUserAndWait(String string) {
                if (this.a.c) {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, string, LangRoAll.atentie);
                }
            }

            @Override
            public final boolean askTextToUserAndWait(String string) {
                if (this.a.c) {
                    return DialogUtils.confirmDialog(GuiUtils.currentFrame, string, LangRoAll.confirmare);
                }
                return true;
            }

            @Override
            public final void bonFinished(int n, int n2, int n3, String string, int n4, boolean bl) {
                for (EcrFeedbackInterface ecrFeedbackInterface : this.a.feedbackListeners) {
                    ecrFeedbackInterface.bonFinished(n3, n, n2, n4, MP55Impl.CASA_EXPLAIN_MESSAGES.BON_SELLED_NORMALLY, string, bl);
                }
            }
        };
        EcrPortParams ecrPortParams = new EcrPortParams(this.a, this.b);
        ecrPortParams.setLibrary(this.k);
        ecrPortParams.setRts(this.h);
        ecrPortParams.setFlowControl(this.m);
        ecrPortParams.setForceDtr(this.i);
        ecrPortParams.setShortTake(this.j);
        this.g = new NewMP55SerialImpl(this.f, ecrPortParams, this.priceForcedDigits, this.paymentForcedDigits, this.incarcaForcedDigits, this.nrLogic, this.l);
        this.g.start();
    }

    @Override
    public void addListener(EcrFeedbackInterface ecrFeedbackInterface) {
        this.feedbackListeners.add(ecrFeedbackInterface);
    }

    @Override
    public void forceTotal() {
    }

    public void printBonFiscal(Vector object, double d2, Vector vector, TipPlata tipPlata2, Vector vector2, String string, int n) {
        object = Generic.buildBonFiscalText((Vector)object, d2, vector, tipPlata2, vector2, string, n, this.discountGlobal, this.discountLaProdus, false, false, this.d, this.e);
        this.processBonFiscal((String)object, string, n, null, null, null, null);
        Logger.logDebugVerbose(this, "Content bon fiscal : " + (String)object);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processBonFiscal(String string, String string2, int n, EcrType object, String iterator, BonValidatorResponseInterface iterator22, Map<Integer, Integer> map) {
        void var7_17;
        Date date = EcrLogic.getInstance().getEcrDate();
        if (date == null) {
            EcrLogic.getInstance().setDate(new Date());
        }
        if (!EcrLogic.getInstance().checkBonLimitForTodayAndIncreaseUsage()) {
            return;
        }
        boolean bl = EcrLogic.getInstance().isReducereNewStyle();
        System.out.println("Received bonId \"" + string2 + "\" items \"" + string + "\" ecrType : " + object + " serieFiscala : " + iterator);
        boolean bl2 = false;
        if (object != null && iterator != null && iterator22 != null) {
            Object object22 = new BonValidator();
            boolean bl3 = EcrLicenseVerifier.getInstance().isFunctionLicensed(EcrLicenseVerifier.FUNCTION.correctBonEnabled);
            Vector<Map<BonValidator.ERROR_FUNCTION, BonValidator.ERROR_TYPE>> vector = new Vector<Map<BonValidator.ERROR_FUNCTION, BonValidator.ERROR_TYPE>>();
            object = ((BonValidator)object22).checkForErrors(string, (EcrType)((Object)object), null, bl3, 2, 3, vector, this.priceForcedDigits, this.paymentForcedDigits, this.incarcaForcedDigits, this.nrLogic, (Map<Integer, Integer>)var7_17, bl);
            System.out.println(object);
            iterator22.processErrors((Map<Integer, Vector<Map<BonValidator.ERROR_FUNCTION, BonValidator.ERROR_TYPE>>>)object, string, (String)((Object)iterator), string2, vector);
            for (Integer n2 : object.keySet()) {
                if (bl2) break;
                Vector vector2 = (Vector)object.get(n2);
                for (Map map2 : vector2) {
                    for (Object object22 : map2.keySet()) {
                        switch (3.a[((Enum)object22).ordinal()]) {
                            case 1: {
                                bl2 = true;
                            }
                        }
                    }
                }
            }
            for (Map<BonValidator.ERROR_FUNCTION, BonValidator.ERROR_TYPE> map3 : vector) {
                for (BonValidator.ERROR_FUNCTION eRROR_FUNCTION : map3.keySet()) {
                    switch (eRROR_FUNCTION) {
                        case ERROR: {
                            bl2 = true;
                        }
                    }
                }
            }
        }
        if (bl2 && this.isPrevalidareBonuriEnabled()) {
            return;
        }
        if (this.g != null) {
            this.g.process(string, n, string2, (Map<Integer, Integer>)var7_17);
        }
    }

    @Override
    public void finishInitialize() {
        super.finishInitialize();
        this.startECR();
    }

    @Override
    public void addLicenseCode(String string) {
        this.ecrLicenseCode.add(string);
    }

    @Override
    public void setEcrSerialNumberReadInterface(EcrSerialNumberReadInterface ecrSerialNumberReadInterface) {
        System.out.println("SET ECR Serial Number Read Interface : " + ecrSerialNumberReadInterface);
        this.g.setSerialNumberInterface(ecrSerialNumberReadInterface);
    }

    @Override
    public void printX() {
        EcrType ecrType = EcrLogic.getInstance().getEcrType();
        if (ecrType != null && ecrType.isSupportsX()) {
            this.processBonFiscal("X,1,______,_,__;;;;;;;\n", "", -1, ecrType, "", null, null);
        }
    }

    @Override
    public void printZ() {
        EcrType ecrType = EcrLogic.getInstance().getEcrType();
        if (ecrType != null && ecrType.isSupportsZ()) {
            this.processBonFiscal("Z,1,______,_,__;;;;;;;\n", "", -1, ecrType, "", null, null);
        }
    }

    @Override
    public void introduNumerar(double d2) {
        String string;
        if (d2 > 0.0) {
            string = "0";
        } else if (d2 < 0.0) {
            string = "1";
        } else {
            return;
        }
        d2 = Math.abs(d2);
        String string2 = Utils.getString2DecimalsNoTrunc(d2);
        string2 = "I,1,______,_,__;" + string + ";" + string2 + ";;;;\n";
        String string3 = Utils.getLocalComputerName() + "_L_numerar";
        this.processBonFiscal(string2, string3, -1, EcrLogic.getInstance().getEcrType(), "", null, null);
        Logger.logDebugVerbose(this, "Content bon fiscal : " + string2);
    }

    @Override
    public boolean numerarInputReady() {
        return true;
    }

    @Override
    public void useEcrSerialNumberOldSchool() {
        this.g.setSerialNumberInterface(new EcrSerialNumberReadInterface(this){
            private /* synthetic */ NewMP55 a;
            {
                this.a = newMP55;
            }

            @Override
            public final void licenseBySerieFiscala(String string) {
                EcrLicenseVerifier.getInstance().setSerieFiscalaCasaAndLicenseOldSchool(string, this.a.ecrLicenseCode);
            }
        });
    }
}

