/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs.nativeImpl;

import java.util.LinkedList;
import java.util.Vector;
import ro.atreides.ecr.EcrFeedbackInterface;
import ro.atreides.ecr.EcrInterface;
import ro.atreides.ecr.EcrInterfaceImpl;
import ro.atreides.ecr.datecs.nativeImpl.ArrivedMessage;
import ro.atreides.ecr.datecs.nativeImpl.Bon;
import ro.atreides.ecr.datecs.nativeImpl.BonValidator;
import ro.atreides.ecr.datecs.nativeImpl.CasaClosedException;
import ro.atreides.ecr.datecs.nativeImpl.Ecr;
import ro.atreides.ecr.datecs.nativeImpl.EcrLicenseInstance;
import ro.atreides.ecr.datecs.nativeImpl.EcrLogger;
import ro.atreides.ecr.datecs.nativeImpl.EcrPortInstanse;
import ro.atreides.ecr.datecs.nativeImpl.EcrPortManager;
import ro.atreides.ecr.datecs.nativeImpl.MP55Impl;
import ro.atreides.ecr.datecs.nativeImpl.MessageTypes;
import ro.atreides.ecr.datecs.nativeImpl.PersistentList;
import ro.atreides.ecr.datecs.nativeImpl.PortSettingsPureJava;
import ro.atreides.ecr.datecs.nativeImpl.Product;
import ro.atreides.ecr.datecs.nativeImpl.Reader;
import ro.atreides.ecr.datecs.nativeImpl.Utils;
import ro.atreides.ecr.datecs.nativeImpl.Wrapper;
import ro.atreides.ecr.datecs.nativeImpl.Writer;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.tricky.NonPrintedBonInterface;
import ro.deversoft.utils.noarch.Logger;

public abstract class EcrImpl
extends LangRoAll
implements Ecr {
    protected EcrInterface ecrInterface;
    protected EcrLicenseInstance licenseInstance;
    private EcrPortInstanse a;
    private Writer b;
    private Reader c;
    protected EcrLogger logger;
    protected Wrapper wrapper;
    protected PersistentList productsList;
    protected PersistentList feedbackList;
    private boolean d = true;
    private boolean e = false;
    private Vector f;
    protected int id = 0;
    protected Vector<EcrFeedbackInterface> feedbackListeners;
    protected boolean rts;
    protected PortSettingsPureJava.SerialLibrary type;

    public EcrImpl(Vector vector, int n, Vector<EcrFeedbackInterface> vector2, boolean bl, PortSettingsPureJava.SerialLibrary serialLibrary) {
        this.id = n;
        this.feedbackListeners = vector2;
        this.rts = bl;
        this.type = serialLibrary;
        this.logger = new EcrLogger(n);
        this.wrapper = new Wrapper();
        this.ecrInterface = new EcrInterfaceImpl(n);
        this.productsList = new PersistentList(n);
        this.feedbackList = new PersistentList("_ecr_persistent_feedback_list_" + (n == 0 ? "" : Integer.valueOf(n)));
        this.licenseInstance = new EcrLicenseInstance(vector);
    }

    public void addListener(EcrFeedbackInterface ecrFeedbackInterface) {
        this.feedbackListeners.add(ecrFeedbackInterface);
    }

    public void notifyListeners(MP55Impl.CASA_EXPLAIN_MESSAGES cASA_EXPLAIN_MESSAGES, Bon bon, int n, int n2, boolean bl) {
        for (EcrFeedbackInterface ecrFeedbackInterface : this.feedbackListeners) {
            int n3 = bon.getIdOrder();
            ecrFeedbackInterface.bonFinished(n3, n, n2, this.id, cASA_EXPLAIN_MESSAGES, bon.getOrderIdentifier(), bl);
        }
    }

    public Vector<EcrFeedbackInterface> getListeners() {
        return this.feedbackListeners;
    }

    public void setErrorNotifications(boolean bl) {
        this.ecrInterface.setErrorNotifications(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() {
        if (this.e || !this.d) {
            return;
        }
        EcrImpl ecrImpl = this;
        synchronized (ecrImpl) {
            if (!this.isRunning()) {
                return;
            }
            this.e = true;
            this.d = true;
            Thread thread = new Thread(this){
                private /* synthetic */ EcrImpl a;
                {
                    this.a = ecrImpl;
                }

                @Override
                public final void run() {
                    this.a.detect(true);
                    if (this.a.isRunning()) {
                        this.a.startSelling();
                    }
                }
            };
            thread.setName("Ecr Printing Thread");
            thread.start();
            return;
        }
    }

    @Override
    public final synchronized void stop() {
        Logger.logVerbose(this, ">>>>>>>>>>>>>> STOPING ECR <<<<<<<<<<<<");
        this.d = false;
        if (this.a != null) {
            this.a.close();
        }
    }

    @Override
    public final boolean isRunning() {
        return this.d;
    }

    @Override
    public final void setEcrInterface(EcrInterface ecrInterface) {
        if (ecrInterface != null) {
            this.ecrInterface = ecrInterface;
        }
    }

    protected abstract void startSelling();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean detect(boolean bl) {
        if (this.a != null) {
            this.a.close();
        }
        if (!bl) {
            Logger.logInfo(this, "ECR INTERFACE: ecrRemoved()");
            int n = this.ecrInterface.ecrRemoved();
            if (n != 0) {
                Logger.logInfo(this, "ECR INTERFACE: user choose IGNORE");
                this.stop();
                return false;
            }
            Logger.logInfo(this, "ECR INTERFACE: user choose RETRY");
        }
        while (this.isRunning()) {
            EcrPortInstanse ecrPortInstanse;
            EcrImpl ecrImpl = this;
            synchronized (ecrImpl) {
                if (!this.isRunning()) {
                    return false;
                }
                ecrPortInstanse = EcrPortManager.detect(this.id, this.f, this.rts, this.type);
                if (ecrPortInstanse != null) {
                    EcrImpl ecrImpl2 = this;
                    this.a = ecrPortInstanse;
                    ecrImpl2.b = ecrImpl2.a.getWriter();
                    ecrImpl2.c = ecrImpl2.a.getReader();
                    ecrImpl2.a.setLogger(ecrImpl2.logger);
                    try {
                        this.ecrInterface.ecrConnected();
                    }
                    catch (Exception exception) {
                        Logger.logException(this, exception);
                    }
                    return true;
                }
            }
            Utils.sleep(500);
            if (!this.isRunning()) {
                return false;
            }
            if (ecrPortInstanse != null) continue;
            Logger.logInfo(this, "ECR INTERFACE: ecrRemoved()");
            int n = bl ? this.ecrInterface.ecrNotPresent() : this.ecrInterface.ecrRemoved();
            if (n != 0) {
                Logger.logInfo(this, "ECR INTERFACE: user choose IGNORE");
                this.stop();
                return false;
            }
            if (n != 0) continue;
            Logger.logInfo(this, "ECR INTERFACE: user choose RETRY");
        }
        return false;
    }

    @Override
    public final double process(String string, int n, String string2) {
        this.logger.logDebugVerbose(this, "requesting sell:\n" + string);
        Object object = Utils.getLines(string);
        if (BonValidator.correctBon(object)) {
            Object object2;
            LinkedList<Product> linkedList = new LinkedList<Product>();
            double d2 = 0.0;
            object = ((Vector)object).iterator();
            while (object.hasNext()) {
                object2 = (String)object.next();
                if ((object2 = Wrapper.getMessageFromString((String)object2, 0, 0, 0, null)) == null) continue;
                if (((Product)object2).getItemType().equals(MessageTypes.PRODUCT)) {
                    d2 += ((Product)object2).getItemPrice() * ((Product)object2).getItemQuantity();
                } else if (((Product)object2).getItemType().equals(MessageTypes.ADAOS)) {
                    d2 += ((Product)object2).getPercent() / 100.0 * d2;
                } else if (((Product)object2).getItemType().equals(MessageTypes.DISCOUNT)) {
                    d2 -= ((Product)object2).getPercent() / 100.0 * d2;
                } else {
                    ((Product)object2).getItemType().equals(MessageTypes.SERTAR);
                }
                linkedList.add((Product)object2);
            }
            if (linkedList.size() > 0) {
                object2 = new Bon(linkedList, n, string2);
                ((Bon)object2).setSource(string);
                this.productsList.addBon((Bon)object2);
            }
            return d2;
        }
        return 0.0;
    }

    public String getFeedback(String string) {
        Bon bon = this.feedbackList.getByIdentifier(string);
        if (bon != null) {
            return string + "|" + bon.getCasaZ() + "|" + bon.getCasaBon() + "|" + bon.getCasaExplain().toString();
        }
        return string + "|NOT_FOUND";
    }

    public void clearFeedbackFile() {
        this.feedbackList.clear();
    }

    @Override
    public boolean isCheckingLicense() {
        return this.licenseInstance.isCheckingLicense();
    }

    protected final void write(byte[] byArray) throws CasaClosedException {
        boolean bl;
        if (!this.b.writetoport(byArray) && !(bl = this.detect(false))) {
            throw new CasaClosedException();
        }
    }

    protected final ArrivedMessage read(int n) throws CasaClosedException {
        ArrivedMessage arrivedMessage;
        block2: {
            arrivedMessage = null;
            try {
                arrivedMessage = this.c.read(n);
            }
            catch (Exception exception) {
                boolean bl = this.detect(false);
                n = bl ? 1 : 0;
                if (bl) break block2;
                throw new CasaClosedException();
            }
        }
        return arrivedMessage;
    }

    protected final void clearReader() {
        if (this.c != null && this.c.queueSize() > 0) {
            this.c.clear();
        }
    }

    public int getNoOfBonsToPrint() {
        return this.productsList.size();
    }

    public void deleteByIdentifier(String string) {
        this.productsList.removeByIdentifier(string);
    }

    public void deleteNonPrintedBons(NonPrintedBonInterface nonPrintedBonInterface) {
        this.productsList.deleteNonPrintedBons(nonPrintedBonInterface);
    }

    public Vector getFilters() {
        return this.f;
    }

    public void setFilters(Vector vector) {
        this.f = vector;
    }
}

