/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs.nativeImpl;

import java.io.IOException;
import java.io.InputStream;
import ro.atreides.ecr.datecs.nativeImpl.ArrivedMessage;
import ro.atreides.ecr.datecs.nativeImpl.Crc;
import ro.atreides.ecr.datecs.nativeImpl.EcrLogger;
import ro.atreides.ecr.datecs.nativeImpl.EventType;
import ro.atreides.ecr.datecs.nativeImpl.Listener;
import ro.atreides.ecr.datecs.nativeImpl.SerialPortWrapper;
import ro.deversoft.utils.noarch.Logger;

public abstract class Reader {
    protected final Crc crcCalculator = new Crc();
    protected byte[] currentMessage = new byte[8192];
    protected byte[] buffer = new byte[4096];
    protected int currentPosition = 0;
    protected InputStream input;
    protected SerialPortWrapper port;
    protected EcrLogger ecrLogger;
    protected Listener listener;

    public Reader(InputStream inputStream, SerialPortWrapper serialPortWrapper) {
        this.input = inputStream;
        this.port = serialPortWrapper;
    }

    public final void setEcrLogger(EcrLogger ecrLogger) {
        this.ecrLogger = ecrLogger;
    }

    public final void logDebug(String string) {
        if (this.ecrLogger == null) {
            Logger.logDebug(this, string);
            return;
        }
        this.ecrLogger.logDebug(this, string);
    }

    public final void logException(Exception exception) {
        if (this.ecrLogger == null) {
            Logger.logWarning(this, exception.toString());
            return;
        }
        this.ecrLogger.logException(this, exception);
    }

    protected abstract void dataArrived(byte[] var1, int var2, int var3);

    protected void fireEvent(EventType eventType) {
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public abstract ArrivedMessage read(int var1) throws IOException, Exception;

    public abstract void clear();

    public abstract int queueSize();
}

