/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecs.nativeImpl;

import gnu.io.SerialPort;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import ro.atreides.ecr.datecs.nativeImpl.ArrivedMessage;
import ro.atreides.ecr.datecs.nativeImpl.Constants;
import ro.atreides.ecr.datecs.nativeImpl.EcrPortInstanse;
import ro.atreides.ecr.datecs.nativeImpl.EcrPortParams;
import ro.atreides.ecr.datecs.nativeImpl.PortSettingsPureJava;
import ro.atreides.ecr.datecs.nativeImpl.PortSettingsRxtx;
import ro.atreides.ecr.datecs.nativeImpl.Reader;
import ro.atreides.ecr.datecs.nativeImpl.SerialPortPureJavaImpl;
import ro.atreides.ecr.datecs.nativeImpl.SerialPortRxtxImpl;
import ro.atreides.ecr.datecs.nativeImpl.SerialPortWrapper;
import ro.atreides.ecr.datecs.nativeImpl.Writer;
import ro.atreides.utils.ZipUtils;
import ro.deversoft.utils.noarch.FileUtils;
import ro.deversoft.utils.noarch.Formatters;
import ro.deversoft.utils.noarch.Logger;

public class Utils {
    public static final Integer[] speeds = new Integer[]{4800, 9600, 19200, 38400};
    public static final String CONFIG_FILE = "config.txt";
    public static final String LAST_DETECTED_ECR_FILE = "_ecr_last_detected_";
    private static final Pattern a = Pattern.compile("[0-9]{4}-[0-1][0-9]-[0-3][0-9]_[0-2][0-9]-[0-6][0-9]__[-]?[0-9]{1,5}_[0-9]{1,3}[.]log", 2);
    private static final Object b = new Object();
    private static Thread c;

    public static void sleep(int n) {
        try {
            Thread.sleep(n);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            return;
        }
    }

    public static Vector<String> getPorts(PortSettingsPureJava.SerialLibrary object) {
        TreeSet<String> treeSet = new TreeSet<String>();
        switch (3.a[((Enum)object).ordinal()]) {
            case 1: {
                object = CommPortIdentifier.getPortIdentifiers();
                while (object.hasMoreElements()) {
                    CommPortIdentifier commPortIdentifier = (CommPortIdentifier)object.nextElement();
                    if (commPortIdentifier.getPortType() != 1) continue;
                    treeSet.add(commPortIdentifier.getName());
                }
                return new Vector<String>(treeSet);
            }
            case 2: {
                object = gnu.io.CommPortIdentifier.getPortIdentifiers();
                while (object.hasMoreElements()) {
                    gnu.io.CommPortIdentifier commPortIdentifier = (gnu.io.CommPortIdentifier)object.nextElement();
                    if (commPortIdentifier.getPortType() != 1) continue;
                    treeSet.add(commPortIdentifier.getName());
                }
                return new Vector<String>(treeSet);
            }
        }
        return new Vector<String>();
    }

    public static Integer[] getSpeeds() {
        return speeds;
    }

    public static Vector<EcrPortParams> getEcrPortParams(int n, Vector<String> vector, boolean bl, PortSettingsPureJava.SerialLibrary serialLibrary) {
        Vector<EcrPortParams> vector2 = new Vector<EcrPortParams>();
        Serializable serializable = Utils.getLastDetected(n);
        System.out.println("last detected " + serializable);
        if (serializable != null) {
            vector2.add((EcrPortParams)serializable);
        }
        serializable = Utils.a(vector, serializable, bl, serialLibrary);
        vector2.addAll((Collection<EcrPortParams>)((Object)serializable));
        return vector2;
    }

    private static Vector<EcrPortParams> a(Vector<String> vector, EcrPortParams ecrPortParams, boolean bl, PortSettingsPureJava.SerialLibrary serialLibrary) {
        Vector<EcrPortParams> vector2 = new Vector<EcrPortParams>();
        Vector<String> vector3 = Utils.getPorts(serialLibrary);
        for (int i = 0; i < vector3.size(); ++i) {
            String string = vector3.get(i);
            int n = 0;
            for (int j = 0; j < vector.size() && n == 0; ++j) {
                String string2 = vector.elementAt(j);
                if (serialLibrary.equals((Object)PortSettingsPureJava.SerialLibrary.PURE_JAVA) && string2.startsWith("/dev/")) {
                    string2 = string2.substring(5, string2.length());
                }
                if (!string.matches(string2)) continue;
                n = 1;
            }
            if (n == 0) continue;
            Integer[] integerArray = Utils.getSpeeds();
            for (int j = 0; j < integerArray.length; ++j) {
                n = integerArray[j];
                EcrPortParams ecrPortParams2 = new EcrPortParams(string, n);
                ecrPortParams2.setLibrary(serialLibrary);
                ecrPortParams2.setRts(bl);
                if (ecrPortParams != null && ecrPortParams2.equals(ecrPortParams)) continue;
                vector2.add(ecrPortParams2);
            }
        }
        return vector2;
    }

    public static EcrPortParams getLastDetected(int n) {
        EcrPortParams ecrPortParams = null;
        Object object = Utils.readObjectFrom(LAST_DETECTED_ECR_FILE + (n == 0 ? "" : Integer.valueOf(n)));
        if (object instanceof EcrPortParams) {
            ecrPortParams = (EcrPortParams)object;
        }
        return ecrPortParams;
    }

    public static void setLastDetected(EcrPortParams ecrPortParams, int n) {
        if (ecrPortParams != null) {
            Utils.writeObjectTo(ecrPortParams, LAST_DETECTED_ECR_FILE + (n == 0 ? "" : Integer.valueOf(n)));
        }
    }

    public static EcrPortInstanse detect(EcrPortParams ecrPortParams, int n) {
        EcrPortInstanse ecrPortInstanse = null;
        try {
            PortSettingsPureJava portSettingsPureJava = null;
            switch (ecrPortParams.getLibrary()) {
                case PURE_JAVA: {
                    portSettingsPureJava = new PortSettingsPureJava();
                    portSettingsPureJava.setSpeed(ecrPortParams.getSpeed());
                    portSettingsPureJava.setSerialLibraryType(PortSettingsPureJava.SerialLibrary.PURE_JAVA);
                    portSettingsPureJava.setName(ecrPortParams.getName());
                    portSettingsPureJava.setRTS(ecrPortParams.isRts());
                    ecrPortInstanse = Utils.initPortPureJava(portSettingsPureJava);
                    break;
                }
                case RXTX: {
                    portSettingsPureJava = new PortSettingsRxtx();
                    portSettingsPureJava.setSpeed(ecrPortParams.getSpeed());
                    portSettingsPureJava.setSerialLibraryType(PortSettingsPureJava.SerialLibrary.RXTX);
                    portSettingsPureJava.setName(ecrPortParams.getName());
                    portSettingsPureJava.setRTS(ecrPortParams.isRts());
                    ecrPortInstanse = Utils.initPortRxtx(portSettingsPureJava);
                }
            }
            if (ecrPortInstanse != null) {
                Logger.logVerbose(Utils.getClassName(), ">>>>>>>>>>>>>>>>>>>>> DETECTARE CASA cu id " + n + " : port=" + portSettingsPureJava.getName() + " speed=" + portSettingsPureJava.getSpeed() + " <<<<<<<<<<<<<<<<<<<");
                boolean bl = Utils.a(ecrPortInstanse.getWriter(), ecrPortInstanse.getReader());
                if (bl) {
                    Logger.logVerbose(Utils.getClassName(), ">>>>> casa cu id " + n + " a fost detectata pe port " + portSettingsPureJava.getName() + " viteza " + portSettingsPureJava.getSpeed());
                    Utils.setLastDetected(ecrPortParams, n);
                    return ecrPortInstanse;
                }
                Logger.logVerbose(Utils.getClassName(), ">>>>> casa cu id " + n + " NU a fost detectata!");
                ecrPortInstanse.close();
            }
        }
        catch (Exception exception) {
            if (ecrPortInstanse != null) {
                ecrPortInstanse.close();
            }
            Logger.logWarning(Utils.class.getName(), exception.toString());
        }
        return null;
    }

    public static EcrPortInstanse initPortPureJava(PortSettingsPureJava portSettingsPureJava) {
        if (portSettingsPureJava == null) {
            return null;
        }
        Logger.logVerbose(Utils.getClassName(), ">>>>>>>>>>>>>>>>>>> INITIALIZARE: port=" + portSettingsPureJava.getName() + " speed=" + portSettingsPureJava.getSpeed() + " <<<<<<<<<<<<<<<<<<");
        SerialPortPureJavaImpl serialPortPureJavaImpl = null;
        try {
            Object object = portSettingsPureJava.getName();
            if (object == null) {
                Logger.logWarning(Utils.getClassName(), ">>>>> nume port = null");
                throw new NullPointerException();
            }
            Object object2 = CommPortIdentifier.getPortIdentifiers();
            while (object2.hasMoreElements()) {
                CommPortIdentifier commPortIdentifier = (CommPortIdentifier)object2.nextElement();
                if (commPortIdentifier.getPortType() != portSettingsPureJava.getPortType() || !commPortIdentifier.getName().equals(object)) continue;
                Logger.logInfo(Utils.class.getName(), ">>>>> Opening port: " + (String)object);
                object = (purejavacomm.SerialPort)commPortIdentifier.open("datecs2GenPureJava", 2000);
                serialPortPureJavaImpl = new SerialPortPureJavaImpl();
                serialPortPureJavaImpl.setRealSerialPort(object);
                serialPortPureJavaImpl.setRTS(portSettingsPureJava.isRTS());
                serialPortPureJavaImpl.setSerialPortParams(portSettingsPureJava.getSpeed(), portSettingsPureJava.getDataBits(), portSettingsPureJava.getStopBits(), portSettingsPureJava.getPariry());
                object = serialPortPureJavaImpl.getInputStream();
                object2 = serialPortPureJavaImpl.getOutputStream();
                Logger.logInfo(Utils.class.getName(), ">>>>> Initializare port corecta");
                return new EcrPortInstanse((InputStream)object, (OutputStream)object2, serialPortPureJavaImpl, portSettingsPureJava);
            }
            Logger.logWarning(Utils.class.getName(), "port indisponibil");
            throw new NoSuchPortException();
        }
        catch (Exception exception) {
            Utils.closeAll(null, null, serialPortPureJavaImpl);
            Logger.logWarning(Utils.class.getName(), ">>>>> Eroare de initializare port, portul se va inchide");
            Logger.logWarning(Utils.class.getName(), exception.toString());
            return null;
        }
    }

    public static EcrPortInstanse initPortRxtx(PortSettingsPureJava portSettingsPureJava) {
        if (portSettingsPureJava == null) {
            return null;
        }
        Logger.logVerbose(Utils.getClassName(), ">>>>>>>>>>>>>>>>>>> INITIALIZARE: port=" + portSettingsPureJava.getName() + " speed=" + portSettingsPureJava.getSpeed() + " <<<<<<<<<<<<<<<<<<");
        SerialPortRxtxImpl serialPortRxtxImpl = null;
        try {
            Object object = portSettingsPureJava.getName();
            if (object == null) {
                Logger.logWarning(Utils.getClassName(), ">>>>> nume port = null");
                throw new NullPointerException();
            }
            Object object2 = gnu.io.CommPortIdentifier.getPortIdentifiers();
            while (object2.hasMoreElements()) {
                gnu.io.CommPortIdentifier commPortIdentifier = (gnu.io.CommPortIdentifier)object2.nextElement();
                if (commPortIdentifier.getPortType() != portSettingsPureJava.getPortType() || !commPortIdentifier.getName().equals(object)) continue;
                Logger.logInfo(Utils.class.getName(), ">>>>> Opening port: " + (String)object);
                object = (SerialPort)commPortIdentifier.open("datecs2ndGenRxtx", 2000);
                serialPortRxtxImpl = new SerialPortRxtxImpl();
                serialPortRxtxImpl.setRealSerialPort(object);
                serialPortRxtxImpl.setRTS(portSettingsPureJava.isRTS());
                serialPortRxtxImpl.setSerialPortParams(portSettingsPureJava.getSpeed(), portSettingsPureJava.getDataBits(), portSettingsPureJava.getStopBits(), portSettingsPureJava.getPariry());
                object = serialPortRxtxImpl.getInputStream();
                object2 = serialPortRxtxImpl.getOutputStream();
                Logger.logInfo(Utils.class.getName(), ">>>>> Initializare port corecta");
                return new EcrPortInstanse((InputStream)object, (OutputStream)object2, serialPortRxtxImpl, portSettingsPureJava);
            }
            Logger.logWarning(Utils.class.getName(), "port indisponibil");
            throw new NoSuchPortException();
        }
        catch (Exception exception) {
            Utils.closeAll(null, null, serialPortRxtxImpl);
            Logger.logWarning(Utils.class.getName(), ">>>>> Eroare de initializare port, portul se va inchide");
            Logger.logWarning(Utils.class.getName(), exception.toString());
            return null;
        }
    }

    @Deprecated
    private static boolean a(Writer writer, Reader reader) {
        try {
            long l = System.currentTimeMillis();
            while (System.currentTimeMillis() - l < 2000L) {
                writer.writetoport(Constants.TAKE_MESSAGE_BK);
                ArrivedMessage arrivedMessage = reader.read(100);
                if (!arrivedMessage.isValid()) continue;
                return true;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            Logger.logWarning(Utils.getClassName(), exception2.toString());
        }
        return false;
    }

    public static void closeAll(InputStream inputStream, OutputStream outputStream, SerialPortWrapper serialPortWrapper) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Throwable throwable) {
            Logger.logWarning(Utils.getClassName(), throwable.toString());
        }
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (Throwable throwable) {
            Logger.logWarning(Utils.getClassName(), throwable.toString());
        }
        try {
            if (serialPortWrapper != null) {
                serialPortWrapper.close();
            }
            return;
        }
        catch (Throwable throwable) {
            Logger.logWarning(Utils.getClassName(), throwable.toString());
            return;
        }
    }

    public static String load(String string, String object) {
        String string2 = "";
        try {
            object = Utils.loadConfiguration((String)object);
            string2 = ((Properties)object).getProperty(string, "");
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
        }
        return string2;
    }

    public static String load(String string) {
        return Utils.load(string, CONFIG_FILE);
    }

    public static int loadAsInt(String string) {
        int n = 0;
        string = Utils.load(string);
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    public static void save(String object, String object2, String string) {
        block5: {
            try {
                Properties properties = Utils.loadConfiguration(string);
                if (object != null && object2 != null) {
                    properties.setProperty((String)object, (String)object2);
                    object2 = properties;
                    object = string;
                    try {
                        ((Properties)object2).store(new FileOutputStream((String)object), "ECR ONLINE PROPERTIES");
                        break block5;
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throwable.printStackTrace();
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throwable.printStackTrace();
            }
        }
    }

    public static void save(String string, String string2) {
        Utils.save(string, string2, CONFIG_FILE);
    }

    public static Properties loadConfiguration(String string) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(string));
        }
        catch (Throwable throwable) {}
        return properties;
    }

    public static synchronized List getProductsFor(String object) {
        Vector vector = new Vector();
        if ((object = Utils.readObjectFrom((String)object)) instanceof Vector) {
            vector = (Vector)object;
        }
        return vector;
    }

    public static synchronized void setProductsFor(Collection vector, String string) {
        if (vector == null) {
            vector = new Vector();
        }
        Utils.writeObjectTo(vector, string);
    }

    /*
     * Loose catch block
     */
    public static Object readObjectFrom(String object) {
        Object object2;
        block16: {
            object2 = null;
            ObjectInput objectInput = null;
            objectInput = new ObjectInputStream(new FileInputStream((String)object));
            object2 = objectInput.readObject();
            try {
                objectInput.close();
            }
            catch (Exception exception) {}
            break block16;
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    if (objectInput != null) {
                        objectInput.close();
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                try {
                    object = exception;
                    exception.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        if (objectInput != null) {
                            objectInput.close();
                        }
                    }
                    catch (Exception exception2) {}
                    throw throwable;
                }
                try {
                    if (objectInput != null) {
                        objectInput.close();
                    }
                }
                catch (Exception exception3) {}
            }
        }
        return object2;
    }

    public static void writeObjectTo(Object object, String object2) {
        try {
            object2 = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream((String)object2)));
            try {
                object2.writeObject(object);
            }
            finally {
                object2.close();
            }
        }
        catch (Exception exception) {}
    }

    public static String getClassName() {
        return Utils.class.getName();
    }

    public static Vector<String> getLines(String stringArray) {
        Vector<String> vector = new Vector<String>();
        if (stringArray != null) {
            stringArray = stringArray.replace('\r', '\n');
            stringArray = stringArray.split("\n");
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i].trim();
                if (string == null || string.length() <= 0) continue;
                vector.add(string);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveLog(String string, int n, int n2, Date object, int n3) {
        String string2 = Formatters.currentDateAndTimeForFileSystem.format((Date)object) + "__" + n + "_" + n2 + ".log";
        try {
            String string3 = "bonuri" + (n3 == 0 ? "" : Integer.valueOf(n3)) + File.separator;
            new File(string3).mkdirs();
            object = b;
            synchronized (object) {
                FileUtils.writeTextToFile(string3 + string2, string);
            }
        }
        catch (Exception exception) {
            Logger.logWarning(Utils.getClassName(), exception.toString());
        }
    }

    public static ArrayList<a> getCurrentLogsFiles(int n) {
        ArrayList<a> arrayList = new ArrayList<a>();
        Object[] objectArray = new File("bonuri" + (n == 0 ? "" : Integer.valueOf(n)));
        if (objectArray.exists() && objectArray.isDirectory()) {
            objectArray = objectArray.listFiles(new FileFilter(){

                @Override
                public final boolean accept(File file) {
                    return Utils.a(file);
                }
            });
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                a a2 = new a(0);
                String string = ((File)object).getName();
                a2.a((File)object);
                object = string;
                a2.b(((String)object).substring(0, ((String)object).indexOf("__")));
                object = string;
                String string2 = null;
                int n2 = ((String)object).indexOf("__") + 2;
                int n3 = ((String)object).indexOf("_", n2);
                if (n2 != -1) {
                    string2 = ((String)object).substring(n2, n3);
                }
                a2.d(string2);
                object = string;
                string2 = null;
                n2 = ((String)object).indexOf("_", ((String)object).indexOf("__") + 2) + 1;
                n3 = ((String)object).indexOf(".", n2);
                if (n2 != -1) {
                    string2 = ((String)object).substring(n2, n3);
                }
                a2.c(string2);
                object = string;
                a2.a(((String)object).substring(0, ((String)object).indexOf("_")));
                object = a2;
                arrayList.add((a)object);
            }
        }
        return arrayList;
    }

    public static synchronized void startEcrLoggsArchivatorThread(int n) {
        if (c != null) {
            return;
        }
        c = new Thread(n){
            private /* synthetic */ int a;
            {
                this.a = n;
            }

            @Override
            public final void run() {
                Utils.sleep(300000);
                ArrayList<a> arrayList = new ArrayList<a>();
                while (true) {
                    ArrayList<a> arrayList2;
                    if ((arrayList2 = Utils.getCurrentLogsFiles(this.a)).size() > 0) {
                        arrayList.clear();
                        arrayList.add(arrayList2.get(0));
                        for (int i = 1; i < arrayList2.size(); ++i) {
                            a a2 = arrayList2.get(i);
                            String string = a2.a();
                            if (string.equals(((a)arrayList.get(0)).a())) {
                                arrayList.add(a2);
                                continue;
                            }
                            Utils.a(arrayList, this.a);
                            arrayList.clear();
                            arrayList.add(a2);
                        }
                    }
                    Utils.sleep(0x6DDD00);
                }
            }
        };
        c.start();
    }

    public static final void main(String[] object) {
        try {
            object = new File("_ecr_persistent_products_list_");
            object = new ObjectInputStream(new FileInputStream((File)object));
            ((ObjectInputStream)object).readObject();
            ((ObjectInputStream)object).close();
            return;
        }
        catch (IOException iOException) {
            Logger.logException("Main", (Exception)iOException);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.logException("Main", (Exception)classNotFoundException);
            return;
        }
    }

    static /* synthetic */ boolean a(File object) {
        return object != null && ((File)object).exists() && ((File)object).isFile() && ((Matcher)(object = a.matcher(((File)object).getName()))).matches();
    }

    static /* synthetic */ void a(ArrayList arrayList, int n) {
        if (arrayList.size() > 0) {
            Object object;
            String string = ((a)arrayList.get(0)).b();
            File[] fileArray = ((a)arrayList.get(arrayList.size() - 1)).b();
            if (string.equals("-1")) {
                string = "0";
            }
            if (fileArray.equals("-1")) {
                fileArray = "0";
            }
            string = string.equals(fileArray) ? string : string + "-" + (String)fileArray;
            fileArray = new File[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                File file;
                object = (a)arrayList.get(i);
                fileArray[i] = file = ((a)object).c();
            }
            String string2 = "bonuri" + (n == 0 ? "" : Integer.valueOf(n)) + File.separator + ((a)arrayList.get(0)).a() + "__" + string;
            FileUtils.moveFilesToDir(fileArray, new File(string2), true);
            object = string2 + ".zip";
            try {
                ZipUtils.zipCreateRecursive(string2, (String)object);
            }
            catch (Exception exception) {
                Logger.logException(Utils.getClassName(), exception);
                FileUtils.removeFileRecurse(new File((String)object));
            }
            FileUtils.removeFileRecurse(new File(string2));
        }
    }

    static final class a {
        private File a;
        private String b;
        private String c;
        private String d;
        private String e;

        private a() {
        }

        public final String a() {
            return this.e;
        }

        public final void a(String string) {
            this.e = string;
        }

        public final void b(String string) {
            this.b = string;
        }

        public final void c(String string) {
            this.c = string;
        }

        public final String b() {
            return this.d;
        }

        public final void d(String string) {
            this.d = string;
        }

        public final File c() {
            return this.a;
        }

        public final void a(File file) {
            this.a = file;
        }

        public final String toString() {
            return "LogFile{source='" + this.a + '\'' + ", dataAll='" + this.b + '\'' + ", data='" + this.e + '\'' + ", nrZ='" + this.d + '\'' + ", nrBon='" + this.c + '\'' + '}';
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

