/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.datecsgen3;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.BonValidatorResponseInterface;
import ro.atreides.ecr.EcrFeedbackInterface;
import ro.atreides.ecr.EcrLogic;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrSale;
import ro.atreides.ecr.EcrSerialNumberReadInterface;
import ro.atreides.ecr.EcrType;
import ro.atreides.ecr.datecs.nativeImpl.BonValidator;
import ro.atreides.ecr.datecs.nativeImpl.MP55Impl;
import ro.atreides.ecr.datecsgen3.Dp25SerialImpl;
import ro.atreides.ecr.datecsgen3.Dp25TcpImpl;
import ro.atreides.ecr.datecsgen3.UserNotifiyInterface;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.plati.TipPlata;
import ro.deversoft.drivers.datecs.gen3.noarch.Bon;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.Command;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales.PrintFreeFiscalText;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales.Sale;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales.Subtotal;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales.Total;
import ro.deversoft.ecr.noarch.EcrLicenseVerifier;
import ro.deversoft.utils.noarch.Logger;
import ro.deversoft.utils.noarch.UtilsNoarch;

public class Generic
extends AbstractCashRegister {
    private Dp25SerialImpl a;
    protected boolean discountGlobal;
    protected boolean errorNotifications;
    protected boolean discountLaProdus;
    private Vector<String> b = new Vector();
    private int c = 0;
    private Vector<String> d = new Vector();
    private String e = "";
    private int f = 38400;
    private UserNotifiyInterface g;
    protected Vector<EcrFeedbackInterface> feedbackListeners = new Vector();

    @Override
    public void buildConfiguration(Properties properties) {
        String string;
        super.buildConfiguration(properties);
        this.e = properties.getProperty("ecrPort");
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (!string.startsWith("datecs.ecr.code.")) continue;
            string = properties.getProperty(string);
            this.b.add(string);
        }
        string = properties.getProperty("ecrLicenceCode");
        if (Validators.correctString(string)) {
            this.b.add(string);
        }
        this.b.add("917b203efec1c523103f234b21b83e53bc3bed1");
        this.discountGlobal = Boolean.parseBoolean(properties.getProperty("discountGlobal", "false"));
        this.discountLaProdus = Boolean.parseBoolean(properties.getProperty("discountLaProdus", "false"));
        this.errorNotifications = Boolean.parseBoolean(properties.getProperty("errorNotifications", "true"));
        this.c = Integer.parseInt(properties.getProperty("ecrId", "0"));
        this.f = Integer.parseInt(properties.getProperty("ecrSpeed", "38400"));
        string = properties.getProperty("ecrPortFilters", "/dev/ttyS.,/dev/ttyUSB.,COM.");
        string = string.replace("/dev/", "");
        this.d = UtilsNoarch.splitString(string, ',');
        if (this.discountLaProdus) {
            this.discountGlobal = false;
        }
        System.out.println("Filters: " + this.d + " ecrId : " + this.c);
        this.ecrType = EcrType.Datecs_DP25;
        this.setUserNotifiyInterface(new UserNotifiyInterface(this){
            private /* synthetic */ Generic a;
            {
                this.a = generic;
            }

            @Override
            public final void showTextToUserAndWait(String string) {
                if (this.a.errorNotifications) {
                    DialogUtils.errorDialogForceShow(GuiUtils.currentFrame, string, LangRoAll.atentie);
                }
            }

            @Override
            public final boolean askTextToUserAndWait(String string) {
                if (this.a.errorNotifications) {
                    return DialogUtils.confirmDialogForceShow(GuiUtils.currentFrame, string, LangRoAll.confirmare);
                }
                return true;
            }

            @Override
            public final void bonFinished(int n, int n2, int n3, String string, int n4, boolean bl) {
                for (EcrFeedbackInterface ecrFeedbackInterface : this.a.feedbackListeners) {
                    ecrFeedbackInterface.bonFinished(n3, n, n2, n4, MP55Impl.CASA_EXPLAIN_MESSAGES.BON_SELLED_NORMALLY, string, bl);
                }
            }
        });
    }

    public void setUserNotifiyInterface(UserNotifiyInterface userNotifiyInterface) {
        this.g = userNotifiyInterface;
        if (this.a != null) {
            this.a.setUserNotifiyInterface(userNotifiyInterface);
        }
    }

    @Override
    public void setEcrSerialNumberReadInterface(EcrSerialNumberReadInterface ecrSerialNumberReadInterface) {
        Logger.logVerbose(this, "Set EcrSerialNumberReadInterface to " + ecrSerialNumberReadInterface);
        this.a.setSerialNumberInterface(ecrSerialNumberReadInterface);
    }

    @Override
    public boolean ecrConnectedAtStartup() {
        return false;
    }

    @Override
    public synchronized void stopECR() {
        Logger.logVerbose(this, "STOPING ECR DRIVER");
        this.a.stopRunning();
    }

    @Override
    public synchronized void startECR() {
        Logger.logVerbose(this, "STARTING ECR DRIVER");
        if (this.a != null) {
            this.a.stopRunning();
        }
        if (this.e.startsWith("tcp")) {
            this.a = new Dp25TcpImpl(this.e, this.g, this.c);
            return;
        }
        this.a = new Dp25SerialImpl(this.e, this.f, this.g, this.c);
    }

    @Override
    public void useEcrSerialNumberOldSchool() {
        this.a.setSerialNumberInterface(new EcrSerialNumberReadInterface(this){
            private /* synthetic */ Generic a;
            {
                this.a = generic;
            }

            @Override
            public final void licenseBySerieFiscala(String string) {
                EcrLicenseVerifier.getInstance().setSerieFiscalaCasaAndLicenseOldSchool(string, this.a.b);
            }
        });
    }

    public void printBonFiscal(Vector object, double d2, Vector vector, TipPlata serializable, Vector vector2, String string, int n) {
        String string2;
        Vector<Object> vector3 = new Vector<Object>();
        Vector<Total> vector4 = new Vector<Total>();
        serializable = new Vector();
        object = ((Vector)object).iterator();
        double d3 = 0.0;
        while (object.hasNext()) {
            EcrSale ecrSale = (EcrSale)object.next();
            string2 = ecrSale.getProduct().toUpperCase();
            Object object2 = UtilsNoarch.getStringMaxSize(30, string2, null, false);
            double d4 = ecrSale.getQuantity();
            double d5 = this.discountGlobal || this.discountLaProdus ? ecrSale.getPpuOriginal() : ecrSale.getPpuDupaDiscount();
            double d6 = this.discountLaProdus ? ecrSale.getDiscountUnitar() : 0.0;
            Character c2 = Character.valueOf(ecrSale.getCodTva().toUpperCase().charAt(0));
            double d7 = FloatUtils.roundDoubleUp(-d6 * d4, 2);
            if (d4 >= 0.0) {
                object2 = new Sale((String)object2, null, c2.charValue(), d5, d4, d7);
                vector3.add(object2);
            } else {
                object2 = new Sale((String)object2, null, c2.charValue(), -d5, -d4, 0.0);
                vector3.add(object2);
            }
            ecrSale.getPpuOriginal();
            ecrSale.getQuantity();
            ecrSale.getPpuOriginal();
            ecrSale.getPpuDupaDiscount();
            ecrSale.getQuantity();
            d3 += FloatUtils.roundDoubleUp(d5 * d4, 2);
            d3 += d7;
        }
        if (vector2.size() > 0) {
            ((Vector)serializable).add(new PrintFreeFiscalText(" "));
        }
        for (int i = 0; i < vector2.size(); ++i) {
            string2 = (String)vector2.elementAt(i);
            if (!Validators.correctString(string2)) {
                string2 = " ";
            }
            string2 = string2.toUpperCase();
            List<String> list = Utils.splitEqually(string2, 22);
            for (String string3 : list) {
                ((Vector)serializable).add(new PrintFreeFiscalText(string3));
            }
        }
        if (vector2.size() > 0) {
            ((Vector)serializable).add(new PrintFreeFiscalText(" "));
        }
        double d8 = 0.0;
        if (vector != null && vector.size() != 0) {
            for (EcrPlata ecrPlata : vector) {
                if (ecrPlata.isDefault()) continue;
                double d9 = ecrPlata.getSuma();
                vector4.add(new Total(ecrPlata.getTipPlata(), null, ecrPlata.getEcrMapping().toUpperCase().charAt(0), d9));
                d8 += d9;
            }
        }
        Vector<Command> vector5 = new Vector<Command>();
        vector5.addAll(vector3);
        vector5.addAll(vector4);
        vector5.addAll((Collection<Command>)((Object)serializable));
        if (Utils.isValueGreaterThanZero(d3 - d8)) {
            Logger.logWarning(this, "FORCING TOTAL : TotalValoare = " + d3 + " totalPlatit = " + d8);
            Total total = new Total(null, null, 'P', null);
            vector5.add(total);
        }
        this.a.addBon(vector5, string);
    }

    @Override
    public void printX() {
        this.a.printAuxiliaryBon(this.a.prepareRaportX());
    }

    @Override
    public void printZ() {
        this.a.printAuxiliaryBon(this.a.prepareRaportZ());
    }

    @Override
    public void introduNumerar(double d2) {
        this.a.printAuxiliaryBon(this.a.prepareDebitingCrediting(d2));
    }

    @Override
    public boolean numerarInputReady() {
        return true;
    }

    @Override
    public void finishInitialize() {
        super.finishInitialize();
        this.startECR();
    }

    @Override
    public void forceTotal() {
    }

    @Override
    public int getNoOfBonsToPrint() {
        return this.a.getUnprintedBons();
    }

    @Override
    public void deleteNonPrintedBons() {
        if (this.inter != null) {
            this.stopECR();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                Logger.logException(this, (Exception)interruptedException);
            }
            this.startECR();
        }
    }

    @Override
    public void deleteBonByIdentifier(String string) {
    }

    @Override
    public void clearFeedbackFile() {
        this.a.clearFeedbackFile();
    }

    @Override
    public String getFeedbackByIdentifier(String string) {
        return this.a.getFeedback(string);
    }

    private void a(String iterator, Vector<Command> vector, Vector<Bon> vector2, Map<Integer, Integer> map, boolean bl) {
        ((String)((Object)iterator)).replaceAll("\\r\\n|\\r|\\n", "&&&");
        iterator = ((String)((Object)iterator)).replaceAll("&&&", "\n");
        Sale sale = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        iterator = UtilsNoarch.splitString((String)((Object)iterator), '\n');
        iterator = ((Vector)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            double d5;
            Object object;
            Object object2 = (String)iterator.next();
            object2 = BonValidator.cleanLine((String)object2);
            int n = ((String)object2).indexOf(";") + 1;
            if (((String)object2).startsWith("P")) {
                String string = ((String)object2).substring(n);
                object2 = UtilsNoarch.splitString(string, ';');
                Iterator iterator2 = ((Vector)object2).iterator();
                while (iterator2.hasNext()) {
                    string = (String)iterator2.next();
                    if (string == null || string.length() <= 0) continue;
                    boolean bl5 = false;
                    if (EcrLicenseVerifier.getInstance().isFunctionLicensed(EcrLicenseVerifier.FUNCTION.printCodFiscalEnabled)) {
                        bl5 = true;
                    } else if (bl3) {
                        Vector vector3 = UtilsNoarch.splitString(string, ' ');
                        object = vector3.iterator();
                        while (object.hasNext()) {
                            String string2 = (String)object.next();
                            String string3 = string2.replaceAll("[^\\d.]", "");
                            if (string3.length() <= 5) continue;
                            bl5 = false;
                            break;
                        }
                    } else {
                        bl5 = false;
                    }
                    if (!bl5) continue;
                    vector.add(new PrintFreeFiscalText(string));
                }
                bl3 = false;
                continue;
            }
            if (((String)object2).startsWith("S")) {
                bl3 = true;
                Object object3 = ((String)object2).substring(n);
                object2 = UtilsNoarch.splitString((String)object3, ';');
                String string = (String)((Vector)object2).get(1);
                if (this.priceForcedDigits > 0) {
                    string = UtilsNoarch.getDoubleWithDecimalPoint(string, this.priceForcedDigits);
                }
                object3 = Utils.parseDouble(string);
                object3 = FloatUtils.roundDouble((Double)object3, 2);
                Double d6 = Utils.parseDouble((String)((Vector)object2).get(2));
                d6 = FloatUtils.roundDouble(d6, 3);
                Integer n2 = Integer.parseInt((String)((Vector)object2).get(5));
                object = (String)((Vector)object2).get(0);
                String string4 = null;
                String string5 = null;
                Vector vector4 = UtilsNoarch.splitString((String)object, '|');
                if (vector4.size() > 0) {
                    string4 = (String)vector4.get(0);
                    if (vector4.size() > 1) {
                        string5 = (String)vector4.get(1);
                    }
                }
                sale = new Sale(string4, string5, (char)(65 + n2 - 1), (Double)object3, d6, null, null);
                vector.add(sale);
                d5 = (Double)object3 * d6;
                d4 = d5 = FloatUtils.roundDoubleUp(d5, 2);
                d3 += d5;
                d3 = FloatUtils.roundDoubleUp(d3, 2);
                continue;
            }
            if (((String)object2).startsWith("C")) {
                bl3 = false;
                object2 = ((String)object2).substring(n);
                Vector vector5 = UtilsNoarch.splitString((String)object2, ';');
                Double d7 = FloatUtils.roundDouble(Utils.parseDouble((String)vector5.get(1)), 2);
                String string = (String)vector5.get(0);
                if (string.equals("1")) {
                    d7 = -d7.doubleValue();
                }
                if (!bl2) {
                    if (sale != null) {
                        sale.setReducerePercent(d7);
                    }
                } else {
                    Subtotal subtotal = new Subtotal(true, true, d7, 0);
                    vector.add(subtotal);
                }
                double d8 = d4;
                if (bl2) {
                    d8 = d3;
                }
                d7 = -d7.doubleValue();
                int n3 = Integer.parseInt(string);
                double d9 = d8;
                switch (n3) {
                    case 1: {
                        if (bl) {
                            d5 = d8 * -d7.doubleValue() / 100.0;
                            d5 = FloatUtils.roundDoubleUp(d5, 2);
                            double d10 = d8 + d5;
                            d9 = FloatUtils.roundDoubleUp(d10, 2);
                            break;
                        }
                        d5 = d8 * (100.0 - d7) / 100.0;
                        d9 = FloatUtils.roundDoubleUp(d5, 2);
                        break;
                    }
                    case 2: {
                        d5 = d8 * (100.0 + d7) / 100.0;
                        d9 = FloatUtils.roundDoubleUp(d5, 2);
                    }
                }
                d3 = d9 > d8 ? (d3 += d9 - d8) : (d3 -= d8 - d9);
                d3 = FloatUtils.roundDoubleUp(d3, 2);
                continue;
            }
            if (((String)object2).startsWith("T")) {
                Object object4;
                String string;
                bl3 = false;
                if (!bl4 && Validators.correctString(string = EcrLogic.getInstance().getNextBonCUI())) {
                    vector.add(new PrintFreeFiscalText(string));
                    EcrLogic.getInstance().setNextBonCUI(null);
                }
                if (((Vector)(object2 = UtilsNoarch.splitStringKeepStructure((String)(object4 = ((String)object2).substring(n)), ';', '_'))).size() > 0) {
                    Integer n4 = 0;
                    try {
                        n4 = Integer.parseInt((String)((Vector)object2).get(0));
                    }
                    catch (NumberFormatException numberFormatException) {
                        object4 = numberFormatException;
                        numberFormatException.printStackTrace();
                    }
                    if (map != null && map.get(n4) != null) {
                        n4 = map.get(n4);
                    }
                    boolean bl6 = false;
                    char c2 = 'P';
                    switch (n4) {
                        case 1: {
                            c2 = 'N';
                            break;
                        }
                        case 2: {
                            c2 = 'C';
                            break;
                        }
                        case 3: {
                            c2 = 'D';
                            break;
                        }
                        case 4: {
                            bl6 = true;
                            bl2 = true;
                            break;
                        }
                        case 5: {
                            c2 = 'I';
                            break;
                        }
                        case 6: {
                            c2 = 'J';
                            break;
                        }
                        case 8: {
                            Bon bon = this.a.prepareDuplicat();
                            vector2.add(bon);
                            return;
                        }
                    }
                    if (!bl6) {
                        Double d11 = null;
                        if (((Vector)object2).size() > 1 && !((String)(object = (String)((Vector)object2).get(1))).contains("_") && Validators.correctDouble((String)object)) {
                            if (this.paymentForcedDigits > 0) {
                                object = UtilsNoarch.getDoubleWithDecimalPoint((String)object, this.paymentForcedDigits);
                            }
                            double d12 = Utils.parseDouble((String)object);
                            d11 = FloatUtils.roundDoubleUp(d12, 2);
                        }
                        if (d11 == null) {
                            d11 = d3 - d2;
                        }
                        object = new Total(null, null, c2, d11);
                        vector.add((Command)object);
                        if (d11 != null) {
                            d2 += d11.doubleValue();
                        }
                    }
                } else if (d3 > d2 || !bl4) {
                    Total total = new Total(null, null, 'P', null);
                    vector.add(total);
                    d2 = d3;
                }
                bl4 = true;
                continue;
            }
            if (((String)object2).startsWith("I")) {
                bl3 = false;
                String string = ((String)object2).substring(n);
                if (((Vector)(object2 = UtilsNoarch.splitStringKeepStructure(string, ';', '_'))).size() < 2) continue;
                String string6 = (String)((Vector)object2).get(0);
                string = (String)((Vector)object2).get(1);
                if (!Validators.correctInteger(string6) || !Validators.correctDouble(string)) continue;
                if (this.incarcaForcedDigits > 0) {
                    string = UtilsNoarch.getDoubleWithDecimalPoint(string, this.incarcaForcedDigits);
                }
                Double d13 = Utils.parseDouble(string);
                Integer n5 = Integer.parseInt(string6);
                if (n5 == 1) {
                    d13 = -d13.doubleValue();
                }
                object = this.a.prepareDebitingCrediting(d13);
                vector2.add((Bon)object);
                continue;
            }
            if (((String)object2).startsWith("X")) {
                bl3 = false;
                Bon bon = this.a.prepareRaportX();
                vector2.add(bon);
                continue;
            }
            if (((String)object2).startsWith("Z")) {
                if (((String)object2).contains("0")) {
                    bl3 = false;
                    Bon bon = this.a.prepareRaportX();
                    vector2.add(bon);
                    continue;
                }
                bl3 = false;
                Bon bon = this.a.prepareRaportZ();
                vector2.add(bon);
                continue;
            }
            if (((String)object2).startsWith("A")) {
                if (((String)object2).contains("Z")) {
                    bl3 = false;
                    Bon bon = this.a.prepareRaportZ();
                    vector2.add(bon);
                    continue;
                }
                if (!((String)object2).contains("X")) continue;
                bl3 = false;
                Bon bon = this.a.prepareRaportX();
                vector2.add(bon);
                continue;
            }
            if (!((String)object2).startsWith("D")) continue;
            bl3 = false;
            Bon bon = this.a.prepareDuplicat();
            vector2.add(bon);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processBonFiscal(String string, String string2, int n, EcrType object3, String iterator, BonValidatorResponseInterface iterator22, Map<Integer, Integer> map) {
        void var7_11;
        Object object4;
        Object object22;
        Iterator<Integer> iterator2;
        if (!EcrLogic.getInstance().checkBonLimitForTodayAndIncreaseUsage()) {
            return;
        }
        System.out.println("Received bonId \"" + string2 + "\" items \"" + string + "\" ecrType : " + object3 + " serieFiscala : " + (String)((Object)iterator2));
        n = EcrLogic.getInstance().isReducereNewStyle() ? 1 : 0;
        boolean bl = false;
        if (object3 != null && iterator2 != null && object22 != null) {
            object4 = new BonValidator();
            boolean bl2 = EcrLicenseVerifier.getInstance().isFunctionLicensed(EcrLicenseVerifier.FUNCTION.correctBonEnabled);
            Vector<Map<BonValidator.ERROR_FUNCTION, BonValidator.ERROR_TYPE>> vector = new Vector<Map<BonValidator.ERROR_FUNCTION, BonValidator.ERROR_TYPE>>();
            Map<Integer, Vector<Map<BonValidator.ERROR_FUNCTION, BonValidator.ERROR_TYPE>>> map2 = ((BonValidator)object4).checkForErrors(string, (EcrType)((Object)object3), null, bl2, 2, 3, vector, this.priceForcedDigits, this.paymentForcedDigits, this.incarcaForcedDigits, this.nrLogic, (Map<Integer, Integer>)var7_11, n != 0);
            System.out.println(map2);
            object22.processErrors(map2, string, (String)((Object)iterator2), string2, vector);
            for (Object object22 : map2.keySet()) {
                if (bl) break;
                object22 = map2.get(object22);
                object4 = ((Vector)object22).iterator();
                while (object4.hasNext()) {
                    object22 = object4.next();
                    for (BonValidator.ERROR_FUNCTION eRROR_FUNCTION : object22.keySet()) {
                        switch (eRROR_FUNCTION) {
                            case ERROR: {
                                bl = true;
                            }
                        }
                    }
                }
            }
            iterator2 = vector.iterator();
            while (iterator2.hasNext()) {
                object22 = (Map)((Object)iterator2.next());
                for (Object object4 : object22.keySet()) {
                    switch (3.a[((Enum)object4).ordinal()]) {
                        case 1: {
                            bl = true;
                        }
                    }
                }
            }
        }
        if (bl && this.isPrevalidareBonuriEnabled()) {
            return;
        }
        if (this.a != null) {
            object4 = new Vector();
            Vector<Bon> vector = new Vector<Bon>();
            this.a(string, (Vector<Command>)object4, vector, (Map<Integer, Integer>)var7_11, n != 0);
            if (((Vector)object4).size() > 0) {
                this.a.addBon((Vector<Command>)object4, string2);
            }
            for (Bon bon : vector) {
                this.a.printAuxiliaryBon(bon);
            }
        }
    }

    @Override
    public void addLicenseCode(String string) {
        this.b.add(string);
    }

    @Override
    public void addListener(EcrFeedbackInterface ecrFeedbackInterface) {
        this.feedbackListeners.add(ecrFeedbackInterface);
    }

    @Override
    public boolean start() {
        return true;
    }

    @Override
    public void copieBon() {
        this.a.printAuxiliaryBon(this.a.prepareDuplicat());
    }
}

