/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.mercury;

import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrReceipt;
import ro.atreides.ecr.EcrSale;
import ro.atreides.ecr.mercury.MercuryXmlHandler;
import ro.atreides.ecr.mercury.nativeImpl.Mercury130FImpl;
import ro.atreides.ecr.mercury.nativeImpl.bons.MercuryFiscalReceiptImpl;
import ro.atreides.ecr.mercury.nativeImpl.bons.MercuryReport;
import ro.atreides.ecr.mercury.nativeImpl.bons.ReportType;
import ro.atreides.ecr.mercury.nativeImpl.requests.FiscalSale;
import ro.atreides.ecr.mercury.nativeImpl.requests.Payment;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.plati.TipPlata;
import ro.deversoft.utils.noarch.Logger;
import ro.deversoft.utils.noarch.UtilsNoarch;

public class Generic
extends AbstractCashRegister {
    private boolean a;
    private boolean b;
    private boolean c;
    private String d;
    private Mercury130FImpl e;
    private Vector f = new Vector();

    @Override
    public void buildConfiguration(Properties object) {
        super.buildConfiguration((Properties)object);
        Boolean.parseBoolean(((Properties)object).getProperty("forceTotal", "false"));
        Boolean.parseBoolean(((Properties)object).getProperty("forceTotalAt2Decimals", "false"));
        this.d = ((Properties)object).getProperty("ecrLicenceCode", "772274515e9e02e8f1aaf17f7b3aac5c56cd85");
        this.a = Boolean.parseBoolean(((Properties)object).getProperty("discountGlobal", "false"));
        this.b = Boolean.parseBoolean(((Properties)object).getProperty("errorNotifications", "true"));
        this.c = Boolean.parseBoolean(((Properties)object).getProperty("verifyEachItem", "true"));
        object = ((Properties)object).getProperty("ecrPortFilters", "/dev/ttyS.,/dev/ttyUSB.,COM.");
        object = ((String)object).replace("/dev/", "");
        this.f = UtilsNoarch.splitString((String)object, ',');
    }

    @Override
    public synchronized void stopECR() {
        Logger.logVerbose(this, "STOPING ECR DRIVER: " + this.e);
        if (this.e != null) {
            this.e.stop();
        }
    }

    @Override
    public synchronized void startECR() {
        Logger.logVerbose(this, "STARTING ECR DRIVER: " + this.e);
        this.stopECR();
        this.e = new Mercury130FImpl(this.f);
        this.e.setLicense(this.d);
        this.e.setLicenseRequired(false);
        this.e.setVerifyEachItem(this.c);
        this.e.setNotifications(this.b);
        this.e.start();
    }

    @Override
    public void processXml(String string) {
        try {
            MercuryXmlHandler mercuryXmlHandler = new MercuryXmlHandler();
            Utils.importXml((DefaultHandler)mercuryXmlHandler, string);
            this.a(mercuryXmlHandler.getReceipt());
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return;
        }
        catch (SAXException sAXException) {
            SAXException sAXException2 = sAXException;
            sAXException.printStackTrace();
            return;
        }
    }

    private void a(EcrReceipt ecrReceipt) {
        if (this.e != null) {
            this.e.addEcrReceipt(ecrReceipt);
        }
    }

    public void printBonFiscal(Vector object, double d2, Vector vector, TipPlata object2, Vector vector2, String taxGroupArray, int n) {
        double d3;
        Object object32;
        MercuryFiscalReceiptImpl mercuryFiscalReceiptImpl = new MercuryFiscalReceiptImpl(n);
        object = ((Vector)object).iterator();
        double d4 = 0.0;
        double d5 = 0.0;
        while (object.hasNext()) {
            EcrSale ecrSale = (EcrSale)object.next();
            object32 = ecrSale.getProduct();
            d3 = ecrSale.getQuantity();
            double d6 = this.a ? ecrSale.getPpuOriginal() : ecrSale.getPpuDupaDiscount();
            String string = ecrSale.getCodTva();
            object2 = null;
            for (FiscalSale.TaxGroup taxGroup : FiscalSale.TaxGroup.values()) {
                String string2 = "" + (char)taxGroup.getId();
                if (!string2.equals(string)) continue;
                object2 = taxGroup;
                break;
            }
            if (object2 == null) {
                DialogUtils.errorDialog(GuiUtils.currentFrame, "GRUPA TVA DEFINITA INCORECT.", "Bon ignorat");
                return;
            }
            d4 += ecrSale.getPpuOriginal() * ecrSale.getQuantity();
            d5 += (ecrSale.getPpuOriginal() - ecrSale.getPpuDupaDiscount()) * ecrSale.getQuantity();
            mercuryFiscalReceiptImpl.addSale(new FiscalSale((String)object32, d6, d3, (FiscalSale.TaxGroup)((Object)object2)));
        }
        for (int i = 0; i < vector2.size(); ++i) {
            object32 = (String)vector2.elementAt(i);
            mercuryFiscalReceiptImpl.addComment((String)object32);
        }
        if (this.a && d5 != 0.0) {
            double d7 = d5 * 100.0 / d4;
            System.out.println("subtotal procent = " + d7);
            mercuryFiscalReceiptImpl.addSubtotal(d7);
        }
        for (Object object32 : vector) {
            d3 = ((EcrPlata)object32).getSuma();
            String string = ((EcrPlata)object32).getEcrMapping();
            Payment.PAYMENT_TYPE pAYMENT_TYPE = Payment.PAYMENT_TYPE.valueOf(string);
            mercuryFiscalReceiptImpl.addPayment(new Payment(d3, pAYMENT_TYPE));
        }
        this.a(mercuryFiscalReceiptImpl);
    }

    @Override
    public void printX() {
    }

    @Override
    public void printZ() {
        this.a(new MercuryReport(ReportType.DAILY_Z));
    }

    @Override
    public void forceTotal() {
    }

    @Override
    public void finishInitialize() {
        super.finishInitialize();
        this.startECR();
    }

    @Override
    public void deleteNonPrintedBons() {
        if (this.inter != null) {
            this.e.deleteNonPrintedBons(this.inter);
            UtilsNoarch.systemExit();
        }
    }
}

