/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.mercury.nativeImpl;

import java.io.IOException;
import java.io.InputStream;
import purejavacomm.SerialPort;
import ro.atreides.ecr.BinaryUtils;
import ro.atreides.ecr.SerialReaderImplSingleThread;
import ro.atreides.ecr.mercury.nativeImpl.MercuryUtils;
import ro.atreides.ecr.mercury.nativeImpl.Response;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;

public class MercuryReaderImpl
extends SerialReaderImplSingleThread {
    public static final int IDLE = 0;
    public static final int SEARCHING_FOR_TERMINATOR = 1;
    private int a = 0;
    protected int currentPosition = 0;
    protected byte[] currentMessage = new byte[8192];

    public MercuryReaderImpl(InputStream inputStream, SerialPort serialPort) {
        super(inputStream, serialPort);
    }

    @Override
    protected void dataArrived(byte[] byArray, int n, int n2) {
        while (n < n2) {
            switch (this.a) {
                case 0: {
                    byte by;
                    this.currentPosition = 0;
                    while (n < n2) {
                        by = byArray[n];
                        if (by == 22) {
                            this.log(">>>>>>>> adding to queue: \t\tSYN");
                            this.addMessage(Response.buildSyn());
                            break;
                        }
                        if (by == 21) {
                            this.log(">>>>>>>> adding to queue: \t\tNACK");
                            this.addMessage(Response.buildNak());
                            break;
                        }
                        if (by == 1) {
                            this.a = 1;
                            break;
                        }
                        ++n;
                    }
                    ++n;
                    break;
                }
                case 1: {
                    byte by;
                    while (n < n2) {
                        by = byArray[n];
                        if (by == 3) {
                            this.a = 0;
                            boolean bl = MercuryUtils.correctChecksum(this.currentMessage, 0, this.currentPosition);
                            by = (byte)(bl ? 1 : 0);
                            if (bl) {
                                byte[] byArray2 = new byte[this.currentPosition - 6];
                                System.arraycopy(this.currentMessage, 1, byArray2, 0, byArray2.length);
                                Response response = Response.buildPacked(byArray2);
                                this.log(">>>>>>>> adding to queue: \t" + (Object)((Object)response.getCMD()) + " response : " + BinaryUtils.toHexString(byArray2));
                                this.addMessage(response);
                                break;
                            }
                            this.log("CRC IN MESSAGE IS INCORRECT!!!");
                            DialogUtils.errorDialog(GuiUtils.currentFrame, "CRC IN MESSAGE IS INCORRECT!!!", "Error");
                            break;
                        }
                        this.currentMessage[this.currentPosition] = by;
                        ++this.currentPosition;
                        ++n;
                    }
                    ++n;
                }
            }
        }
    }

    @Override
    public Response read(int n) throws IOException {
        Response response = (Response)super.read(n);
        if (response != null) {
            this.log(">>>>>>>> reading from queue: \t" + response);
            if (response.isSyn()) {
                while ((response = (Response)super.read(1000)) != null) {
                    this.log(">>>>>>>> reading from queue: \t" + response);
                    if (response.isSyn()) continue;
                }
            }
        }
        if (response == null) {
            this.log(">>>>>>> AM CITIT NULL <<<<<<<<");
        }
        return response;
    }

    @Override
    public void clearReader() {
        super.clearReader();
        this.a = 0;
    }
}

