/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.mercury.nativeImpl;

import java.io.File;
import java.util.Date;
import java.util.EnumSet;
import ro.atreides.ecr.BinaryUtils;
import ro.atreides.ecr.mercury.nativeImpl.a;
import ro.deversoft.utils.noarch.FileUtils;
import ro.deversoft.utils.noarch.Formatters;
import ro.deversoft.utils.noarch.Logger;

public class MercuryUtils {
    public static final byte BIT7_MASK = -128;
    public static final byte BIT6_MASK = 64;
    public static final byte BIT5_MASK = 32;
    public static final byte BIT4_MASK = 16;
    public static final byte BIT3_MASK = 8;
    public static final byte BIT2_MASK = 4;
    public static final byte BIT1_MASK = 2;
    public static final byte BIT0_MASK = 1;

    public static void sleep(int n) {
        try {
            Thread.sleep(n);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            return;
        }
    }

    public static boolean correctChecksum(byte[] object, int n, int n2) {
        int n3 = 0;
        n2 -= 4;
        while (n < n2) {
            byte by = object[n];
            n3 += BinaryUtils.unsignedByteToInt(by);
            ++n;
        }
        String string = BinaryUtils.secondHexDigitAsString(object[n2]);
        String string2 = BinaryUtils.secondHexDigitAsString(object[n2 + 1]);
        String string3 = BinaryUtils.secondHexDigitAsString(object[n2 + 2]);
        object = BinaryUtils.secondHexDigitAsString(object[n2 + 3]);
        int n4 = Integer.parseInt(string + string2 + string3 + (String)object, 16);
        return n4 == (n3 &= 0xFFFF);
    }

    public static void setChecksum(byte[] byArray, int n, int n2) {
        byte by;
        int n3 = 0;
        while (n < n2) {
            by = byArray[n];
            n3 += BinaryUtils.unsignedByteToInt(by);
            ++n;
        }
        byte[] byArray2 = BinaryUtils.toBytes((short)(n3 &= 0xFFFF));
        by = (byte)(BinaryUtils.firstHexDigitAsByte(byArray2[0]) + 48);
        n3 = (byte)(BinaryUtils.secondHexDigitAsByte(byArray2[0]) + 48);
        byte by2 = (byte)(BinaryUtils.firstHexDigitAsByte(byArray2[1]) + 48);
        byte by3 = (byte)(BinaryUtils.secondHexDigitAsByte(byArray2[1]) + 48);
        byArray[n2] = by;
        byArray[n2 + 1] = n3;
        byArray[n2 + 2] = by2;
        byArray[n2 + 3] = by3;
    }

    public static EnumSet<a> parseStatus(byte[] byArray) {
        EnumSet<a> enumSet;
        if (byArray == null) {
            return null;
        }
        try {
            enumSet = EnumSet.of(a.NONE);
            byte by = byArray[byArray.length - 6];
            byte by2 = byArray[byArray.length - 5];
            byte by3 = byArray[byArray.length - 4];
            byte by4 = byArray[byArray.length - 3];
            byte by5 = byArray[byArray.length - 2];
            byte by6 = byArray[byArray.length - 1];
            byte[] byArray2 = new byte[]{by, by2, by3, by4, by5, by6};
            MercuryUtils.a(by, enumSet, null, null, a.GENERAL_ERROR, a.PRINTING_MECHANISM_FAILURE, null, a.TIME_DATE_IS_NOT_SET, a.INVALID_COMMAND_CODE, a.SYNTAX_ERROR);
            MercuryUtils.a(by2, enumSet, null, null, a.THREE_CONSECUTIVE_WRONG_PASSWORDS, null, null, a.RAM_RESET, a.COMMAND_EXECUTION_IS_NOT_PERMITTED, a.OVERFLOW);
            MercuryUtils.a(by3, enumSet, null, null, a.OPEN_NON_FISCAL_RECEIPT, a.ELECTRONIC_JOURNAL_OVERFLOW, a.OPEN_FISCAL_RECEIPT, null, null, a.PAPER_END);
            MercuryUtils.a(by4, enumSet, null, null, null, null, null, null, null, null);
            MercuryUtils.a(by5, enumSet, null, null, a.GENERAL_FISCAL_FM_MEMORY_ERROR, a.FULL_FISCAL_MEMORY, a.LESS_THAN_60_FREE_RECORDS_IN_FM, a.ERROR_RECORD_IN_FM, null, a.ERROR_WHEN_RECORDING_IN_FM);
            MercuryUtils.a(by6, enumSet, null, null, a.ECR_IDENTIFICATION_NUMBER_IS_RECORDED_IN_FM, a.VAT_RATES_ASSIGNED_AT_LEAST_ONCE, a.ECR_IS_FISCALIZED, null, null, a.THE_FM_SET_IN_READONLY_MODE);
            if (enumSet.size() > 1) {
                enumSet.remove((Object)a.NONE);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            return null;
        }
        return enumSet;
    }

    private static void a(byte by, EnumSet<a> enumSet, a a2, a a3, a a4, a a5, a a6, a a7, a a8, a a9) {
        MercuryUtils.a(by, (byte)1, a9, enumSet);
        MercuryUtils.a(by, (byte)2, a8, enumSet);
        MercuryUtils.a(by, (byte)4, a7, enumSet);
        MercuryUtils.a(by, (byte)8, a6, enumSet);
        MercuryUtils.a(by, (byte)16, a5, enumSet);
        MercuryUtils.a(by, (byte)32, a4, enumSet);
        MercuryUtils.a(by, (byte)64, null, enumSet);
        MercuryUtils.a(by, (byte)-128, null, enumSet);
    }

    private static void a(byte by, byte by2, a a2, EnumSet<a> enumSet) {
        if (a2 != null && (by & by2) == by2) {
            enumSet.add(a2);
        }
    }

    public static void saveLog(String string, String string2, Date date, String string3) {
        string2 = Formatters.currentDateAndTimeForFileSystem.format(date) + "__" + string2 + ".log";
        try {
            new File(string).mkdirs();
            FileUtils.writeTextToFile(string + File.separator + string2, string3);
            return;
        }
        catch (Exception exception) {
            Logger.logWarning(MercuryUtils.getClassName(), exception.toString());
            return;
        }
    }

    public static String getClassName() {
        return MercuryUtils.class.getName();
    }
}

