/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.mercury.nativeImpl;

import java.util.EnumSet;
import ro.atreides.ecr.mercury.nativeImpl.CMD_ENUM;
import ro.atreides.ecr.mercury.nativeImpl.MercuryUtils;
import ro.atreides.ecr.mercury.nativeImpl.Message;
import ro.atreides.ecr.mercury.nativeImpl.Request;
import ro.atreides.ecr.mercury.nativeImpl.a;
import ro.atreides.ecr.mercury.nativeImpl.responses.ResponseCloseFiscalReceipt;
import ro.atreides.ecr.mercury.nativeImpl.responses.ResponseDateAndTimeOfTheEcr;
import ro.atreides.ecr.mercury.nativeImpl.responses.ResponseFiscalReceiptStatus;
import ro.atreides.ecr.mercury.nativeImpl.responses.ResponseOpenFiscalReceipt;
import ro.atreides.ecr.mercury.nativeImpl.responses.ResponseOpenNonFiscalReceipt;
import ro.atreides.ecr.mercury.nativeImpl.responses.ResponsePayment;
import ro.atreides.ecr.mercury.nativeImpl.responses.ResponseSaleRegistration;

public class Response
extends Message {
    private static final Response SYN_MESSAGE = new Response(CMD_ENUM.NOT_USED, TYPE.SYN, null){

        @Override
        public final String toString() {
            return "SYN";
        }
    };
    private static final Response NAK_MESSAGE = new Response(CMD_ENUM.NOT_USED, TYPE.NAK, null){

        @Override
        public final String toString() {
            return "NAK";
        }
    };
    private TYPE type;
    private EnumSet<a> status;
    private byte[] messageData;

    public Response(CMD_ENUM cMD_ENUM, TYPE tYPE, byte[] byArray) {
        super(cMD_ENUM);
        this.messageData = byArray;
        if (tYPE == null) {
            throw new NullPointerException("type is null");
        }
        this.type = tYPE;
        this.status = MercuryUtils.parseStatus(byArray);
        if (tYPE == TYPE.PACKED) {
            this.setSeq(byArray[0]);
        }
    }

    public Response(CMD_ENUM cMD_ENUM, byte[] byArray) {
        this(cMD_ENUM, TYPE.PACKED, byArray);
    }

    public byte[] getDataBlock() {
        int n = this.messageData.length - 7;
        byte[] byArray = new byte[n - 2];
        System.arraycopy(this.messageData, 2, byArray, 0, byArray.length);
        return byArray;
    }

    @Override
    protected final byte[] buildDataBytes() {
        return null;
    }

    @Override
    public final byte[] buildRawMessage() {
        return null;
    }

    public TYPE getType() {
        return this.type;
    }

    public static Response buildSyn() {
        return SYN_MESSAGE;
    }

    public static Response buildNak() {
        return NAK_MESSAGE;
    }

    public static Response buildPacked(byte[] byArray) {
        if (byArray == null) {
            return new Response(CMD_ENUM.NOT_USED, TYPE.PACKED, byArray);
        }
        byte by = byArray[1];
        switch (by) {
            case 76: {
                return new ResponseFiscalReceiptStatus(byArray);
            }
            case 48: {
                return new ResponseOpenFiscalReceipt(byArray);
            }
            case 38: {
                return new ResponseOpenNonFiscalReceipt(byArray);
            }
            case 62: {
                return new ResponseDateAndTimeOfTheEcr(byArray);
            }
            case 56: {
                return new ResponseCloseFiscalReceipt(byArray);
            }
            case 53: {
                return new ResponsePayment(byArray);
            }
            case 49: {
                return new ResponseSaleRegistration(byArray);
            }
        }
        return new Response(CMD_ENUM.cmdForId(by), TYPE.PACKED, byArray);
    }

    public boolean isSyn() {
        return this.type == TYPE.SYN;
    }

    public boolean isNak() {
        return this.type == TYPE.NAK;
    }

    public boolean isPacked() {
        return this.type == TYPE.PACKED;
    }

    public boolean isResponseToRequest(Request request) {
        boolean bl = false;
        if (request != null && this.isPacked()) {
            bl = request.getCMD() == this.getCMD() && request.getSEQ() == request.getSEQ();
        }
        return bl;
    }

    public EnumSet<a> getStatus() {
        return this.status;
    }

    public String toString() {
        return "\n\tResponse {\n\t\ttype=" + (Object)((Object)this.type) + "\n\t\tstatus=" + this.status + "\n\t}";
    }

    public static enum TYPE {
        NAK,
        SYN,
        PACKED;

    }
}

