/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.mercury.nativeImpl.requests;

import ro.atreides.ecr.BinaryUtils;
import ro.atreides.ecr.mercury.nativeImpl.CMD_ENUM;
import ro.atreides.ecr.mercury.nativeImpl.Request;
import ro.atreides.utils.Utils;

public final class FiscalSale
extends Request {
    private String name;
    private TaxGroup taxGroup;
    private double price;
    private double quantity;
    private double percent;

    public FiscalSale(String string, double d2, double d3) {
        this(string, d2, d3, null);
    }

    public FiscalSale(String string, double d2, double d3, double d4) {
        this(string, d2, d3, null, d4);
    }

    public FiscalSale(String string, double d2, double d3, TaxGroup taxGroup) {
        this(string, d2, d3, taxGroup, 0.0);
    }

    public FiscalSale(String string, double d2, double d3, TaxGroup taxGroup, double d4) {
        super(CMD_ENUM.SALE_REGISTRATION);
        this.name = string == null ? null : (string.length() > 24 ? string.substring(0, 24) : string);
        this.taxGroup = taxGroup == null ? TaxGroup.A : taxGroup;
        this.price = d2;
        this.quantity = d3;
        this.setPercent(d4);
    }

    public final void setPercent(double d2) {
        this.percent = d2 == 0.0 ? 0.0 : (d2 > 0.0 ? Math.min(d2, (double)99.99f) : Math.max(d2, (double)-99.99f));
    }

    @Override
    protected final byte[] buildDataBytes() {
        String string = this.name == null ? "" : this.name;
        String string2 = Utils.getString2DecimalsNoTrunc(this.price);
        String string3 = Utils.getString3DecimalsNoTrunc(this.quantity);
        String string4 = Utils.getString2DecimalsNoTrunc(this.percent);
        int n = (string.length() > 0 ? 1 + string.length() : 0) + 1 + 1 + string2.length() + 1 + string3.length() + (this.percent == 0.0 ? 0 : 1 + string4.length());
        byte[] byArray = new byte[n];
        int n2 = -1;
        if (string.length() > 0) {
            byArray[0] = 10;
            BinaryUtils.copyAsciiBytes(string, 0, byArray, 1, string.length());
            n2 = 1 + (string.length() - 1);
        }
        byArray[++n2] = 9;
        byArray[++n2] = this.taxGroup.getId();
        BinaryUtils.copyAsciiBytes(string2, 0, byArray, ++n2, string2.length());
        n2 += string2.length() - 1;
        byArray[++n2] = 42;
        BinaryUtils.copyAsciiBytes(string3, 0, byArray, ++n2, string3.length());
        n2 += string3.length() - 1;
        if (this.percent != 0.0) {
            byArray[++n2] = 44;
            BinaryUtils.copyAsciiBytes(string4, 0, byArray, ++n2, string4.length());
            string4.length();
        }
        return byArray;
    }

    public final String toString() {
        return "\n\t\tFiscalSale { name='" + this.name + '\'' + ", taxGroup=" + (Object)((Object)this.taxGroup) + ", price=" + this.price + ", quantity=" + this.quantity + ", percent=" + this.percent + " }";
    }

    public static enum TaxGroup {
        NON_TAXABLE(' '),
        A('A'),
        B('B'),
        C('C'),
        D('D'),
        E('E'),
        G('G');

        private byte id;

        private TaxGroup(char c2) {
            this.id = (byte)c2;
        }

        public final byte getId() {
            return this.id;
        }
    }
}

