/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.mercury.nativeImpl.requests;

import ro.atreides.ecr.BinaryUtils;
import ro.atreides.ecr.mercury.nativeImpl.CMD_ENUM;
import ro.atreides.ecr.mercury.nativeImpl.Request;
import ro.atreides.utils.Utils;

public final class Payment
extends Request {
    private String comment;
    private PAYMENT_TYPE paymentType;
    private String amount;
    private double amountFloat;

    public Payment() {
        this(Double.MAX_VALUE);
    }

    public Payment(double d2) {
        this(d2, null);
    }

    public Payment(double d2, PAYMENT_TYPE pAYMENT_TYPE) {
        this(d2, pAYMENT_TYPE, null);
    }

    public Payment(double d2, PAYMENT_TYPE pAYMENT_TYPE, String string) {
        super(CMD_ENUM.PAYMENT);
        this.comment = string == null ? "" : (string.length() > 28 ? string.substring(0, string.length()) : string);
        this.paymentType = pAYMENT_TYPE == null ? PAYMENT_TYPE.CASH : pAYMENT_TYPE;
        this.setAmount(d2);
    }

    public final void setAmount(double d2) {
        this.amountFloat = d2 = d2 < 0.0 ? 0.0 : d2;
        this.amount = Utils.getString2DecimalsNoTrunc(d2);
    }

    @Override
    protected final byte[] buildDataBytes() {
        int n = (this.comment.length() == 0 ? 0 : this.comment.length() + 1) + 1 + (this.amountFloat == Double.MAX_VALUE ? 0 : 1 + this.amount.length());
        byte[] byArray = new byte[n];
        int n2 = -1;
        if (this.comment.length() > 0) {
            byArray[0] = 10;
            BinaryUtils.copyAsciiBytes(this.comment, 0, byArray, 1, this.comment.length());
            n2 = 1 + (this.comment.length() - 1);
        }
        byArray[++n2] = 9;
        if (this.amountFloat != Double.MAX_VALUE) {
            byArray[++n2] = this.paymentType.getId();
            BinaryUtils.copyAsciiBytes(this.amount, 0, byArray, ++n2, this.amount.length());
        }
        return byArray;
    }

    public final double getAmount() {
        return this.amountFloat;
    }

    public final String toString() {
        return "\n\t\tPayment { paymentType=" + (Object)((Object)this.paymentType) + ", amount='" + (this.amountFloat == Double.MAX_VALUE ? "ALL" : this.amount) + '\'' + ", comment='" + this.comment + '\'' + " }";
    }

    public static enum PAYMENT_TYPE {
        CASH('P'),
        CC('N'),
        CHECK('C'),
        CARD('D'),
        COUPON('B');

        private byte id;

        private PAYMENT_TYPE(char c2) {
            this.id = (byte)c2;
        }

        public final byte getId() {
            return this.id;
        }
    }
}

