/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.optimus;

import java.util.Properties;
import java.util.Vector;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.ecr.AbstractCashRegister;
import ro.atreides.ecr.EcrPlata;
import ro.atreides.ecr.EcrReceipt;
import ro.atreides.ecr.EcrSale;
import ro.atreides.ecr.optimus.XmlHandler;
import ro.atreides.ecr.optimus.nativeImpl.Bon;
import ro.atreides.ecr.optimus.nativeImpl.MG1200Impl;
import ro.atreides.ecr.optimus.nativeImpl.Payment;
import ro.atreides.ecr.optimus.nativeImpl.Produs;
import ro.atreides.utils.FloatUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.plati.TipPlata;
import ro.deversoft.utils.noarch.Logger;
import ro.deversoft.utils.noarch.UtilsNoarch;

public class Generic
extends AbstractCashRegister {
    private boolean a;
    private boolean b;
    private MG1200Impl c;
    private Vector d = new Vector();

    @Override
    public void buildConfiguration(Properties properties) throws RuntimeException {
        super.buildConfiguration(properties);
        Boolean.parseBoolean(properties.getProperty("forceTotal", "false"));
        this.b = Boolean.parseBoolean(properties.getProperty("errorNotifications", "true"));
        this.a = Boolean.parseBoolean(properties.getProperty("discountGlobal", "false"));
        String string = properties.getProperty("ecrPortFilters", "/dev/ttyS.,/dev/ttyUSB.,COM.");
        string = string.replace("/dev/", "");
        this.d = UtilsNoarch.splitString(string, ',');
        properties.getProperty("ecrLicenceCode", "772274515e9e02e8f1aaf17f7b3aac5c56cd85");
    }

    @Override
    public void stopECR() {
        Logger.logVerbose(this, "STOPING ECR DRIVER: " + this.c);
        if (this.c != null) {
            this.c.stop();
        }
    }

    @Override
    public void startECR() {
        Logger.logVerbose(this, "STARTING ECR DRIVER: " + this.c);
        if (this.c != null) {
            this.c.stop();
        }
        this.c = new MG1200Impl("0", this.d);
        this.c.setNotifications(this.b);
        this.c.start();
    }

    @Override
    public void processXml(String string) {
        try {
            XmlHandler xmlHandler = new XmlHandler();
            Utils.importXml((DefaultHandler)xmlHandler, string);
            this.processBon(xmlHandler.getReceipt());
            return;
        }
        catch (Exception exception) {
            Logger.logError((Object)this, exception);
            exception.printStackTrace();
            return;
        }
    }

    public void processBon(EcrReceipt ecrReceipt) {
        if (this.c != null) {
            this.c.addEcrReceipt(ecrReceipt);
        }
    }

    public void printBonFiscal(Vector object, double d2, Vector vector, TipPlata serializable, Vector vector2, String string, int n) {
        serializable = new Bon(n);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        object = ((Vector)object).iterator();
        while (object.hasNext()) {
            EcrSale ecrSale = (EcrSale)object.next();
            String string2 = ecrSale.getProduct();
            double d6 = ecrSale.getQuantity();
            double d7 = ecrSale.getPpuDupaDiscount();
            d3 += ecrSale.getPpuOriginal() * ecrSale.getQuantity();
            d4 += (ecrSale.getPpuOriginal() - ecrSale.getPpuDupaDiscount()) * ecrSale.getQuantity();
            d5 += FloatUtils.roundDoubleUp(d6 * d7, 2);
            String string3 = ecrSale.getCodTva();
            char c2 = 'A';
            if (string3.length() > 0) {
                c2 = string3.charAt(0);
            }
            Produs produs = new Produs(string2, d7, d6, c2);
            ((Bon)serializable).add(produs);
            Logger.logDebug(this, "Produs: " + produs.toString());
        }
        if (this.a && d4 != 0.0) {
            double d8 = d4 * 100.0 / d3;
            System.out.println("subtotal procent = " + d8);
            ((Bon)serializable).setAdaosTotal(d8);
            Logger.logDebug(this, "subtotal procent = " + d8);
        }
        for (String string2 : vector2) {
            String string4 = string2;
            ((Bon)serializable).add(string4);
        }
        Object object2 = null;
        double d9 = 0.0;
        for (EcrPlata ecrPlata : vector) {
            double d10 = ecrPlata.getSuma();
            string = ecrPlata.getEcrMapping();
            Payment.TYPE tYPE = Payment.TYPE.valueOf(string);
            object = new Payment(d10, tYPE);
            if (tYPE == Payment.TYPE.CASH) {
                object2 = object;
            }
            ((Bon)serializable).addPayment((Payment)object);
            Logger.logDebug(this, "Payment: " + string + " : " + d10);
            d9 += FloatUtils.roundDoubleUp(d10, 2);
        }
        if (d2 > d9) {
            double d11 = FloatUtils.roundDoubleUp(d5 - d9, 2);
            Logger.logWarning(this, "Diferenta de plata: " + d11 + " . Adaugam diferenta pe cash !!");
            if (object2 != null) {
                ((Payment)object2).setValue(((Payment)object2).getValue() + d11);
            } else {
                Payment payment = new Payment(d11, Payment.TYPE.CASH);
                ((Bon)serializable).addPayment(payment);
            }
        }
        this.processBon((EcrReceipt)serializable);
    }

    @Override
    public void forceTotal() {
    }

    @Override
    public void finishInitialize() {
        super.finishInitialize();
        this.startECR();
    }

    @Override
    public void deleteNonPrintedBons() {
        if (this.inter != null) {
            this.c.deleteNonPrintedBons(this.inter);
        }
    }

    @Override
    public int getNoOfBonsToPrint() {
        if (this.c != null) {
            return this.c.getNoOfBonsToPrint();
        }
        return 0;
    }
}

