/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.optimus.nativeImpl;

import java.util.Arrays;
import java.util.Vector;
import ro.atreides.ecr.BinaryUtils;
import ro.atreides.ecr.optimus.nativeImpl.Checksum16;
import ro.atreides.ecr.optimus.nativeImpl.Message;
import ro.atreides.ecr.optimus.nativeImpl.Payment;
import ro.atreides.ecr.optimus.nativeImpl.Types;
import ro.atreides.utils.Utils;

public class MessageFactory {
    public static final byte STX = 2;
    public static final byte ETX = 3;
    public static final byte EOT = 4;
    public static final byte ENQ = 5;
    public static final byte NAK = 21;
    public static final byte ACK = 6;
    public static final byte ERROR = 64;
    public static byte[] START = new byte[]{2, 83, 113, 49, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 3, 48, 48, 54, 68};
    private Checksum16 a = new Checksum16();

    public byte[] buildSale(String string, double d2, double d3, char c2, double d4) {
        byte[] byArray = new byte[69];
        Arrays.fill(byArray, (byte)32);
        byArray[0] = 2;
        byArray[1] = 68;
        byArray[2] = 113;
        byArray[3] = 49;
        if (string.length() > 18) {
            string = string.substring(0, 18);
        }
        System.arraycopy(string.getBytes(), 0, byArray, 4, string.length());
        byArray[22] = (byte)c2;
        string = Utils.getString2DecimalsNoTrunc(d2).replace(".", "");
        System.arraycopy(string.getBytes(), 0, byArray, 33 - string.length(), string.length());
        string = Utils.getString3DecimalsNoTrunc(d3).replace(".", "");
        System.arraycopy(string.getBytes(), 0, byArray, 43 - string.length(), string.length());
        string = Utils.getString2DecimalsNoTrunc(d4).replace(".", "");
        System.arraycopy(string.getBytes(), 0, byArray, 53 - string.length(), string.length());
        byArray[64] = 3;
        this.setCrc(byArray);
        return byArray;
    }

    public byte[] buildTotal(double d2, Vector vector) {
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                Payment payment = (Payment)vector.get(i);
                Payment.TYPE tYPE = payment.getType();
                double d8 = payment.getValue();
                if (tYPE == Payment.TYPE.CASH) {
                    d3 += d8;
                    continue;
                }
                if (tYPE == Payment.TYPE.CHECK) {
                    d4 += d8;
                    continue;
                }
                if (tYPE == Payment.TYPE.CC) {
                    d5 += d8;
                    continue;
                }
                if (tYPE == Payment.TYPE.COUPON) {
                    d6 += d8;
                    continue;
                }
                if (tYPE != Payment.TYPE.CARD) continue;
                d7 += d8;
            }
        }
        return this.buildTotal(d2, d3, d4, d5, d6, d7);
    }

    public byte[] buildTotal(double d2, double d3, double d4, double d5, double d6, double d7) {
        if (d2 > d3 + d4 + d5 + d6 + d7) {
            d3 += d2 - d3 - d4 - d5 - d6 - d7;
        }
        byte[] byArray = new byte[69];
        Arrays.fill(byArray, (byte)32);
        byArray[0] = 2;
        byArray[1] = 68;
        byArray[2] = 113;
        byArray[3] = 52;
        String string = Utils.getString2DecimalsNoTrunc(d2).replace(".", "");
        System.arraycopy(string.getBytes(), 0, byArray, 14 - string.length(), string.length());
        string = Utils.getString2DecimalsNoTrunc(d3).replace(".", "");
        System.arraycopy(string.getBytes(), 0, byArray, 24 - string.length(), string.length());
        if (d4 > 0.0) {
            string = Utils.getString2DecimalsNoTrunc(d4).replace(".", "");
            System.arraycopy(string.getBytes(), 0, byArray, 34 - string.length(), string.length());
        }
        if (d5 > 0.0) {
            string = Utils.getString2DecimalsNoTrunc(d5).replace(".", "");
            System.arraycopy(string.getBytes(), 0, byArray, 44 - string.length(), string.length());
        }
        if (d6 > 0.0) {
            string = Utils.getString2DecimalsNoTrunc(d6).replace(".", "");
            System.arraycopy(string.getBytes(), 0, byArray, 54 - string.length(), string.length());
        }
        if (d7 > 0.0) {
            string = Utils.getString2DecimalsNoTrunc(d7).replace(".", "");
            System.arraycopy(string.getBytes(), 0, byArray, 64 - string.length(), string.length());
        }
        byArray[64] = 3;
        this.setCrc(byArray);
        return byArray;
    }

    public byte[] buildAnulare() {
        byte[] byArray = new byte[69];
        Arrays.fill(byArray, (byte)32);
        byArray[0] = 2;
        byArray[1] = 68;
        byArray[2] = 113;
        byArray[3] = 51;
        byArray[64] = 3;
        this.setCrc(byArray);
        return byArray;
    }

    public byte[] buildAdaos(double d2) {
        byte[] byArray = new byte[69];
        Arrays.fill(byArray, (byte)32);
        byArray[0] = 2;
        byArray[1] = 68;
        byArray[2] = 113;
        byArray[3] = 57;
        String string = Utils.getString2DecimalsNoTrunc(d2).replace(".", "");
        System.arraycopy(string.getBytes(), 0, byArray, 14 - string.length(), string.length());
        byArray[64] = 3;
        this.setCrc(byArray);
        return byArray;
    }

    public byte[] buildAdaosTotal(double d2) {
        byte[] byArray = new byte[69];
        Arrays.fill(byArray, (byte)32);
        byArray[0] = 2;
        byArray[1] = 68;
        byArray[2] = 113;
        byArray[3] = 65;
        String string = Utils.getString2DecimalsNoTrunc(d2).replace(".", "");
        System.arraycopy(string.getBytes(), 0, byArray, 14 - string.length(), string.length());
        byArray[64] = 3;
        this.setCrc(byArray);
        return byArray;
    }

    public byte[] buildDiscount(double d2) {
        byte[] byArray = new byte[69];
        Arrays.fill(byArray, (byte)32);
        byArray[0] = 2;
        byArray[1] = 68;
        byArray[2] = 113;
        byArray[3] = 53;
        String string = Utils.getString2DecimalsNoTrunc(d2).replace(".", "");
        System.arraycopy(string.getBytes(), 0, byArray, 14 - string.length(), string.length());
        byArray[64] = 3;
        this.setCrc(byArray);
        return byArray;
    }

    public byte[] buildDiscountTotal(double d2) {
        byte[] byArray = new byte[69];
        Arrays.fill(byArray, (byte)32);
        byArray[0] = 2;
        byArray[1] = 68;
        byArray[2] = 113;
        byArray[3] = 54;
        String string = Utils.getString2DecimalsNoTrunc(d2).replace(".", "");
        System.arraycopy(string.getBytes(), 0, byArray, 14 - string.length(), string.length());
        byArray[64] = 3;
        this.setCrc(byArray);
        return byArray;
    }

    public byte[] buildComment(String string) {
        byte[] byArray = new byte[69];
        Arrays.fill(byArray, (byte)32);
        byArray[0] = 2;
        byArray[1] = 68;
        byArray[2] = 113;
        byArray[3] = 69;
        if (string.length() > 18) {
            string = string.substring(0, 18);
        }
        System.arraycopy(string.getBytes(), 0, byArray, 4, string.length());
        byArray[64] = 3;
        this.setCrc(byArray);
        return byArray;
    }

    public void setCrc(byte[] byArray) {
        this.a.reset();
        this.a.update(byArray, 1, byArray.length - 3);
        byte[] byArray2 = this.a.getBytes();
        byArray[byArray.length - 4] = (byte)BinaryUtils.firstHexDigitAsString(byArray2[0]).charAt(0);
        byArray[byArray.length - 3] = (byte)BinaryUtils.secondHexDigitAsString(byArray2[0]).charAt(0);
        byArray[byArray.length - 2] = (byte)BinaryUtils.firstHexDigitAsString(byArray2[1]).charAt(0);
        byArray[byArray.length - 1] = (byte)BinaryUtils.secondHexDigitAsString(byArray2[1]).charAt(0);
    }

    public static Message buildAck() {
        Message message = new Message();
        message.setType(Types.ACK);
        return message;
    }

    public static Message buildNack() {
        Message message = new Message();
        message.setType(Types.NACK);
        return message;
    }

    public static Message buildTransmisionEnd() {
        Message message = new Message();
        message.setType(Types.END);
        return message;
    }

    public static Message buildError() {
        Message message = new Message();
        message.setType(Types.ERROR);
        return message;
    }

    public static Message buildEnquire() {
        Message message = new Message();
        message.setType(Types.ENQUIRE);
        return message;
    }

    public static Message buildPacked(byte[] byArray) {
        Message message = new Message();
        message.setType(Types.PACKED);
        message.setData(byArray);
        return message;
    }
}

