/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.ecr.optimus.nativeImpl;

import java.io.IOException;
import java.util.Vector;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;
import ro.atreides.ecr.BinaryUtils;
import ro.atreides.ecr.optimus.nativeImpl.Bon;
import ro.atreides.ecr.optimus.nativeImpl.MessageFactory;
import ro.atreides.ecr.optimus.nativeImpl.Produs;
import ro.atreides.utils.FloatUtils;

public class TestSimple {
    private MessageFactory a = new MessageFactory();
    private SerialPort b;

    public boolean init(String object, int n) {
        try {
            object = CommPortIdentifier.getPortIdentifier((String)object);
            this.b = (SerialPort)object.open("driver", 0);
            this.b.setSerialPortParams(n, 8, 1, 0);
            this.b.setRTS(true);
            return true;
        }
        catch (NoSuchPortException noSuchPortException) {
            object = noSuchPortException;
            noSuchPortException.printStackTrace();
        }
        catch (PortInUseException portInUseException) {
            object = portInUseException;
            portInUseException.printStackTrace();
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            object = unsupportedCommOperationException;
            unsupportedCommOperationException.printStackTrace();
        }
        return false;
    }

    public void write(byte[] byArray) throws IOException {
        this.b.getOutputStream().write(byArray);
        this.b.getOutputStream().flush();
        System.out.println(">> " + BinaryUtils.toHexString(byArray));
    }

    public void write(byte by) throws IOException {
        this.write(new byte[]{by});
    }

    public byte[] read() throws IOException {
        byte[] byArray = new byte[100];
        int n = this.b.getInputStream().read(byArray);
        System.out.println("<< " + BinaryUtils.toHexString(byArray, 0, n) + " " + new String(byArray, 0, n));
        return byArray;
    }

    public synchronized void sell(Bon serializable) throws IOException {
        serializable = ((Bon)serializable).get();
        this.write((byte)4);
        this.read();
        this.write((byte)5);
        this.read();
        this.write(MessageFactory.START);
        this.read();
        double d2 = 0.0;
        for (int i = 0; i < ((Vector)serializable).size(); ++i) {
            Produs produs = (Produs)((Vector)serializable).get(i);
            double d3 = FloatUtils.roundDoubleUp(produs.getPrice() * produs.getQuantity(), 2);
            this.write(this.a.buildSale(produs.getName(), produs.getPrice(), produs.getQuantity(), 'A', d3));
            this.read();
            d2 += d3;
        }
        this.write(this.a.buildTotal(d2, d2, 0.0, 0.0, 0.0, 0.0));
        this.read();
        this.write((byte)4);
        this.read();
    }

    public static void main(String[] object) throws IOException, InterruptedException {
        object = new TestSimple();
        ((TestSimple)object).init("/dev/ttyS0", 9600);
        Bon bon = new Bon(0);
        bon.add(new Produs("COLA", 1.0, 1.0, 'A'));
        bon.add(new Produs("COLA", 1.0, 1.0, 'A'));
        ((TestSimple)object).sell(bon);
    }
}

