/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils;

import java.awt.Component;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import mseries.ui.MDateEntryField;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.deversoft.utils.noarch.Formatters;
import ro.deversoft.utils.noarch.Logger;

public class DateUtils
extends LangRoAll {
    public static long yearMillis = 31536000000L;
    public static long monthMillis = 2592000000L;
    public static long dayMillis = 86400000L;
    public static long hoursMillis = 3600000L;
    public static long minutesMillis = 60000L;
    public static long secondsMillis = 1000L;
    public static int SECONDS_IN_A_DAY = 86400;

    public static int getYearFromDate(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getMonthFromDate(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static int getDayFromDate(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static Date getDayInCurrentYear(int n, int n2) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(2, n - 1);
        calendar.set(5, n2);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Vector<Date> getDaysInPerioada(Date date, Date date2) {
        Vector<Date> vector = new Vector<Date>();
        while (date.before(date2)) {
            Date date3 = new Date(date.getTime());
            vector.add(date3);
            date = DateUtils.advanceOneDay(date);
        }
        return vector;
    }

    public static String getTimeFromDate(Date date) {
        return Formatters.TIME_FORMAT.format(date);
    }

    public static Date setTimeToDate2(Date date, JTextField object) {
        int n;
        int n2;
        object = ((JTextComponent)object).getText();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, ":");
            n2 = Integer.parseInt(stringTokenizer.nextToken());
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Timp incorect : " + (String)object, LangRoAll.nuPotContinua);
            return null;
        }
        catch (NoSuchElementException noSuchElementException) {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Timp incorect : " + (String)object, LangRoAll.nuPotContinua);
            return null;
        }
        date = DateUtils.setTimeToDate(date, n2, n, 0, 0);
        return date;
    }

    public static Date setTimeToDate2(Date date, String string) {
        int n;
        int n2;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            n2 = Integer.parseInt(stringTokenizer.nextToken());
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Timp incorect : " + string, LangRoAll.nuPotContinua);
            return null;
        }
        catch (NoSuchElementException noSuchElementException) {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Timp incorect : " + string, LangRoAll.nuPotContinua);
            return null;
        }
        date = DateUtils.setTimeToDate(date, n2, n, 0, 0);
        return date;
    }

    public static Date setTimeToDate(Component component, MDateEntryField object, JTextField jTextField) {
        try {
            object = object.getValue();
            return DateUtils.setTimeToDate2((Date)object, jTextField);
        }
        catch (ParseException parseException) {
            DialogUtils.errorDialog(component, "Va rugam completati corect data", LangRoAll.nuPotContinua);
            return null;
        }
    }

    public static Date setTimeToDate(Component component, MDateEntryField object, String string) {
        try {
            object = object.getValue();
            return DateUtils.setTimeToDate2((Date)object, string);
        }
        catch (ParseException parseException) {
            DialogUtils.errorDialog(component, "Va rugam completati corect data", LangRoAll.nuPotContinua);
            return null;
        }
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    public static Timestamp getCurrentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Timestamp getEndOfDays() {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.add(1, 2000);
        return new Timestamp(calendar.getTime().getTime());
    }

    public static Timestamp getStartOfDays() {
        GregorianCalendar.getInstance();
        return new Timestamp(0L);
    }

    public static int getDaysPerMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(date.getYear() + 1900, date.getMonth(), date.getDate());
        return calendar.getActualMaximum(5);
    }

    public static Date addMinutesToDate(Date date, int n) {
        long l = date.getTime();
        date = new Date(l += (long)(n * 60 * 1000));
        return date;
    }

    public static Date addMinutesToDateConsiderDST(Date date, int n) {
        Cloneable cloneable = GregorianCalendar.getInstance();
        ((Calendar)cloneable).setTime(date);
        cloneable = ((Calendar)cloneable).getTimeZone();
        int n2 = ((TimeZone)cloneable).getDSTSavings();
        boolean bl = ((TimeZone)cloneable).inDaylightTime(date);
        long l = date.getTime();
        date = new Date(l += (long)(n * 60 * 1000));
        Cloneable cloneable2 = GregorianCalendar.getInstance();
        ((Calendar)cloneable2).setTime(date);
        cloneable2 = ((Calendar)cloneable2).getTimeZone();
        int n3 = ((TimeZone)cloneable2).getDSTSavings();
        boolean bl2 = ((TimeZone)cloneable2).inDaylightTime(date);
        if (bl && bl2 || !bl && !bl2) {
            return date;
        }
        long l2 = (bl ? n2 : 0) - (bl2 ? n3 : 0);
        if (bl2) {
            l2 = -l2;
        }
        long l3 = date.getTime() + l2;
        date = new Date(l3);
        return date;
    }

    public static Date getDayInWeek(int n, int n2, int n3) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(7, n);
        calendar.set(11, n2);
        calendar.set(12, n3);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    @Deprecated
    public static Date addDaysToDate(Date date, int n) {
        long l = date.getTime();
        long l2 = (long)n * 3600L * 24L * 1000L;
        return new Date(l += l2);
    }

    public static Date get12Hour(long l) {
        long l2 = l % 1000L;
        l2 = l - l2;
        Date date = new Date(l2);
        date.setHours(12);
        date.setMinutes(0);
        date.setSeconds(0);
        return date;
    }

    public static Date getFirstDayOfCurrentYear() {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(5, 1);
        calendar.set(2, 0);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getFirstDayOfCurrentMonth() {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getFirstDay(int n, int n2) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(1, n2);
        calendar.set(2, n);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getLastDay(int n, int n2) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(1, n2);
        calendar.set(2, n);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(2, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static Date getStartOfDay(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getStartOfWeek(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 2);
        return calendar.getTime();
    }

    public static Date getStartOfWeek(Date date, int n) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, n);
        return calendar.getTime();
    }

    public static Date getStartOfMonth(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getEndOfDay(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date advanceOneDay(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        return calendar.getTime();
    }

    public static Date advanceOneWeek(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.add(3, 1);
        return calendar.getTime();
    }

    public static Date addMonthsToDate(Date date, int n) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, n);
        return calendar.getTime();
    }

    public static Date advanceOneMonth(Date date) {
        return DateUtils.addMonthsToDate(date, 1);
    }

    public static Date addYearsToDate(Date date, int n) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, n);
        return calendar.getTime();
    }

    public static Date getDate(String string, SimpleDateFormat simpleDateFormat) {
        Date date = null;
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            Logger.logException("DateUtils", (Exception)parseException);
        }
        return date;
    }

    public static Date setTimeToDate(Date date, int n, int n2, int n3, int n4) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        calendar.set(14, n4);
        return calendar.getTime();
    }

    public static int getNrOfWeekOfYear(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        return calendar.get(3);
    }

    public static int getNrOfMonthOfYear(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2);
    }

    public static int getNrOfDayInWeek(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        return calendar.get(7);
    }

    public static int getNrOfDayInMonth(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getYear(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getWeekInYear(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 2);
        return calendar.get(3);
    }

    public static Timestamp setMillis(Timestamp timestamp, int n) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTimeInMillis(timestamp.getTime());
        calendar.set(14, n);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static boolean sameMinute(Timestamp timestamp, Timestamp timestamp2) {
        long l;
        long l2 = timestamp.getTime() / minutesMillis;
        return l2 == (l = timestamp2.getTime() / minutesMillis);
    }

    public static boolean sameDay(Date date, Date date2) {
        long l;
        long l2 = date.getTime() / dayMillis;
        return l2 == (l = date2.getTime() / dayMillis);
    }

    public static String getDiferentaIntreOre(long l, long l2) {
        long l3 = l2 - l;
        return DateUtils.getStringForDiff(l3);
    }

    public static String getStringForDiff(long l) {
        int n = (int)(l / yearMillis);
        int n2 = (int)((l -= (long)n * yearMillis) / monthMillis);
        int n3 = (int)((l -= (long)n2 * monthMillis) / dayMillis);
        int n4 = (int)((l -= (long)n3 * dayMillis) / hoursMillis);
        int n5 = (int)((l -= (long)n4 * hoursMillis) / minutesMillis);
        int n6 = (int)((l -= (long)n5 * minutesMillis) / secondsMillis);
        String string = (n != 0 ? n3 + " ani," : "") + (n2 != 0 ? n2 + " luni," : "") + (n3 != 0 ? n3 + " zile," : "") + (n4 != 0 ? n4 + " ore," : "") + (n5 != 0 ? n5 + " minute," : "") + (n6 != 0 ? n6 + " secunde" : "");
        return string;
    }

    public static int getNrZileForDiff(long l) {
        int n = Math.round(l / dayMillis);
        return n;
    }

    public static String getHoursForDiff(long l) {
        int n = (int)(l / 3600000L);
        int n2 = (int)((l -= (long)n * 3600000L) / 60000L);
        int n3 = (int)((l -= (long)n2 * 60000L) / 1000L);
        String string = (n != 0 ? n + " ore," : "") + (n2 != 0 ? n2 + " minute," : "") + (n3 != 0 ? n3 + " secunde" : "");
        return string;
    }

    public static Date getStartOfCentury() {
        Date date = DateUtils.getFirstDay(1, 1900);
        return date;
    }

    public static Date addMillisToDate(Date date, long l) {
        long l2 = date.getTime() + l;
        return new Date(l2);
    }

    public static Date minusMillis(Date date, long l) {
        long l2 = date.getTime() - l;
        return new Date(l2);
    }

    public static Timestamp[][] getMonthsInYear(String string) {
        Timestamp[][] timestampArray = new Timestamp[12][2];
        int n = Integer.parseInt(string);
        for (int i = 0; i < 12; ++i) {
            Date date = DateUtils.getFirstDay(i, n);
            Date date2 = i < 11 ? DateUtils.getFirstDay(i + 1, n) : DateUtils.getFirstDay(0, n + 1);
            timestampArray[i][0] = new Timestamp(date.getTime());
            timestampArray[i][1] = new Timestamp(date2.getTime());
        }
        return timestampArray;
    }

    public static String getHumanDate(int n, int n2) {
        Date date = DateUtils.getFirstDay(n, n2);
        return Formatters.MONTH_YEAR_HUMAN_FORMAT.format(date);
    }

    public static boolean checkDayOfWeek(String string, long l) {
        if (string.contains("*")) {
            return true;
        }
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTimeInMillis(l);
        int n = calendar.get(7);
        if (calendar.getFirstDayOfWeek() == 1) {
            --n;
        }
        if (n == 0) {
            n = 7;
        }
        return string.contains("" + n);
    }

    public static Date getStartOf2000() {
        Date date = DateUtils.getFirstDay(1, 2000);
        return date;
    }

    public static String getStringTimeUntilDate(Date comparable) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)comparable);
        comparable = Calendar.getInstance();
        long l = calendar.getTimeInMillis() - ((Calendar)comparable).getTimeInMillis();
        long l2 = l / 1000L;
        long l3 = l2 % (long)SECONDS_IN_A_DAY;
        long l4 = l3 % 60L;
        long l5 = l3 / 60L % 60L;
        long l6 = l3 / 3600L;
        if (l4 < 0L) {
            l4 = 0L;
        }
        return (l6 < 10L ? "0" + l6 : Long.valueOf(l6)) + ":" + (l5 < 10L ? "0" + l5 : Long.valueOf(l5)) + ":" + (l4 < 10L ? "0" + l4 : Long.valueOf(l4));
    }

    public static Date getDateFromStringMultipleFormats(String string, String object) {
        Date date = new Date();
        object = new SimpleDateFormat((String)object);
        try {
            if (Validators.correctDate(string, (SimpleDateFormat)object)) {
                date = ((DateFormat)object).parse(string);
            }
        }
        catch (ParseException parseException) {
            Logger.logException("DateUtils : ", (Exception)parseException);
        }
        return date;
    }
}

