/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.management.ManagementFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.deversoft.utils.noarch.FileUtils;
import ro.deversoft.utils.noarch.Logger;
import ro.deversoft.utils.noarch.UtilsNoarch;

public class PidFileUtil {
    public static int getProcessPid() {
        try {
            String string = ManagementFactory.getRuntimeMXBean().getName();
            if (string.contains("@")) {
                int n = Integer.parseInt(string.split("@")[0]);
                Logger.logInfo(PidFileUtil.class, "Java Process PID is " + n);
                return n;
            }
            throw new Exception("Cannot find pid from string: " + string);
        }
        catch (Exception exception) {
            Logger.logWarning(PidFileUtil.class, "Retrieving Java Process PID failed with first method, trying second ...");
            try {
                Object object = ManagementFactory.getRuntimeMXBean();
                AccessibleObject accessibleObject = object.getClass().getDeclaredField("jvm");
                ((Field)accessibleObject).setAccessible(true);
                object = ((Field)accessibleObject).get(object);
                accessibleObject = object.getClass().getDeclaredMethod("getProcessId", new Class[0]);
                ((Method)accessibleObject).setAccessible(true);
                int n = (Integer)((Method)accessibleObject).invoke(object, new Object[0]);
                Logger.logInfo(PidFileUtil.class, "Java Process iD is " + n);
                return n;
            }
            catch (Exception exception2) {
                return -1;
            }
        }
    }

    public static void createNewPidFile(File file) throws IOException {
        file.delete();
        try {
            FileWriter fileWriter = new FileWriter(file);
            Throwable throwable = null;
            try {
                String string = "" + PidFileUtil.getProcessPid();
                System.out.println("This process's id: " + string);
                Logger.logInfo(PidFileUtil.class, "Writing PID file (for PID " + string + ") to " + file + " ...");
                fileWriter.write(string);
                fileWriter.close();
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (throwable != null) {
                        try {
                            fileWriter.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        fileWriter.close();
                    }
                    throw throwable4;
                }
            }
            fileWriter.close();
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
        }
    }

    public static int getPidFromFile(File file) {
        if (file.exists()) {
            int n;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            Throwable throwable = null;
            try {
                n = Integer.parseInt(bufferedReader.readLine());
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        Throwable throwable3 = throwable2;
                        throwable = throwable2;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            bufferedReader.close();
                        }
                        throw throwable4;
                    }
                }
                catch (Exception exception) {
                    Logger.logWarning(PidFileUtil.class, "Cannot read pidfile from " + file + ". Assuming that the process not running.");
                    return -1;
                }
            }
            bufferedReader.close();
            return n;
        }
        return -1;
    }

    public static boolean killProcess(int n) {
        UtilsNoarch.OS_TYPE oS_TYPE = UtilsNoarch.detectOS();
        Logger.logDebug(PidFileUtil.class, "Detected OS " + (Object)((Object)oS_TYPE));
        switch (oS_TYPE) {
            case LINUX: 
            case MAC: {
                return PidFileUtil.a(n);
            }
            case WINDOWS: {
                return PidFileUtil.b(n);
            }
        }
        return false;
    }

    private static boolean a(int n) {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec("kill -9 " + n);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
        }
        if (process == null) {
            Logger.logWarning(PidFileUtil.class, "Could not kill the process with the id=" + n);
            System.err.println("Could not kill the process with the id=" + n);
            return false;
        }
        return true;
    }

    private static boolean b(int n) {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec("taskkill /F /PID " + n);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
        }
        if (process == null) {
            Logger.logWarning(PidFileUtil.class, "Could not kill the process with the id=" + n);
            System.err.println("Could not kill the process with the id=" + n);
            return false;
        }
        return true;
    }

    public static boolean isProcessRunning(int n, String ... stringArray) {
        UtilsNoarch.OS_TYPE oS_TYPE = UtilsNoarch.detectOS();
        switch (oS_TYPE) {
            case LINUX: {
                Logger.logInfo("PidFileUtil", "Detected UNIX OS");
                return PidFileUtil.c(n);
            }
            case WINDOWS: {
                Logger.logInfo("PidFileUtil", "Detected WINDOWS OS");
                return PidFileUtil.a(n, stringArray);
            }
            case MAC: {
                Logger.logInfo("PidFileUtil", "Detected MAC OS");
                return PidFileUtil.c(n);
            }
        }
        return false;
    }

    private static boolean c(int n) {
        try {
            Object object = Runtime.getRuntime();
            object = ((Runtime)object).exec(new String[]{"kill", "-0", "" + n});
            int n2 = ((Process)object).waitFor();
            boolean bl = n2 == 0;
            Logger.logInfo(PidFileUtil.class, "isProcessRunningOnUnix(" + n + ") returned " + n2 + ", process running = " + bl);
            return bl;
        }
        catch (Exception exception) {
            Logger.logWarning(PidFileUtil.class, "Cannot retrieve status of PID " + n + ". Assuming that the process not running.");
            return false;
        }
    }

    private static boolean a(int n, String ... stringArray) {
        try {
            String string;
            Closeable closeable = UtilsNoarch.executeGrabOutput(null, "tasklist");
            closeable = new LineNumberReader(new InputStreamReader((InputStream)closeable));
            boolean bl = false;
            while ((string = ((LineNumberReader)closeable).readLine()) != null) {
                System.out.println("Line from tasklist : " + string);
                if (!string.contains("" + n)) continue;
                if (stringArray != null && stringArray.length > 0) {
                    for (int i = 0; i < stringArray.length && !bl; ++i) {
                        if (!string.trim().toLowerCase().contains(stringArray[i].toLowerCase())) continue;
                        bl = true;
                    }
                } else {
                    bl = true;
                }
                if (!bl) continue;
            }
            String string2 = "isProcessRunningOnWindows(" + n + ") returned " + string + ", process running = " + bl;
            Logger.logInfo(PidFileUtil.class, string2);
            return bl;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            Logger.logWarning(PidFileUtil.class, "Cannot retrieve status of PID " + n + "; assuming process not running.");
            return false;
        }
    }

    public static File checkForRunningInstances(String object, boolean bl, boolean bl2) {
        if (!bl) {
            Object object2 = FileUtils.getTempDir();
            String string = (String)object + ".pid";
            object2 = new File((String)object2, string);
            ((File)object2).setReadable(true);
            int n = PidFileUtil.getPidFromFile((File)object2);
            Logger.logDebug(PidFileUtil.class, "Existing PID from file " + string + " for appname " + (String)object + " is " + n);
            if (n > 0) {
                boolean bl3 = PidFileUtil.isProcessRunning(n, "fiscalwire", "fprint");
                Logger.logDebug(PidFileUtil.class, "Is Process " + n + " running : " + bl3);
                if (bl3) {
                    if (bl2) {
                        bl3 = PidFileUtil.killProcess(n);
                        if (!bl3) {
                            DialogUtils.errorDialog(null, "Masina mai ruleaza o instanta a aplicatiei! Inchideti manual procesul " + n + " !!", LangRoAll.nuPotContinua);
                            UtilsNoarch.systemExit();
                        }
                    } else {
                        Logger.logDebug(PidFileUtil.class, "Closing current app instance, as requested by closeOldInstance = false");
                        UtilsNoarch.systemExit();
                    }
                }
            }
            try {
                ((File)object2).createNewFile();
                PidFileUtil.createNewPidFile((File)object2);
                return object2;
            }
            catch (IOException iOException) {
                object = iOException;
                iOException.printStackTrace();
                System.exit(1);
            }
        }
        return null;
    }
}

