/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Timestamp;
import org.xml.sax.Attributes;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.deversoft.utils.noarch.Logger;

public class TextUtils {
    public static String getHexString(short[] sArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < sArray.length; ++i) {
            short s = sArray[i];
            stringBuffer.append(Integer.toHexString(s));
            if (!bl) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString().toUpperCase();
    }

    public static String getHexString(byte[] byArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            short s = byArray[i];
            if (s < 0) {
                s = (short)(s + 256);
            }
            stringBuffer.append(Integer.toHexString(s));
            if (!bl) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString().toUpperCase();
    }

    public static String trimChar(String object, char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        object = ((String)object).toCharArray();
        boolean bl = false;
        for (int i = 0; i < ((Object)object).length; ++i) {
            if (object[i] == c2 && !bl) continue;
            stringBuffer.append((char)object[i]);
            bl = true;
        }
        String string = stringBuffer.toString();
        return string;
    }

    public static String escapeForXMLStripQuote(String string) {
        string = string.replaceAll("'", "");
        string = TextUtils.escapeForXML(string);
        return string;
    }

    public static String escapeForXML(String string) {
        if (string == null) {
            string = "";
        }
        String string2 = "\u001dVB\u0000";
        String string3 = "\u001b!\u0001";
        String string4 = "\u001b!\u0010";
        String string5 = "\u001b! ";
        String string6 = "\u001b!0";
        String string7 = "\u001b";
        string = new String(string);
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        string = string.replaceAll("\\\\", "&#92;");
        string = string.replaceAll("\"", "&quot;");
        string = string.replaceAll("'", "&apos;");
        string = string.replaceAll("\\$", "&#36;");
        string = string.replaceAll(string2, "");
        string = string.replaceAll(string3, "");
        string = string.replaceAll(string4, "");
        string = string.replaceAll(string5, "");
        string = string.replaceAll(string6, "");
        string = string.replaceAll(string7, "");
        string = string.replaceAll("\u0000", "");
        return string;
    }

    public static String wrapText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = Math.min(80, string.length());
        String string2 = string.substring(0, n);
        while (string2.length() > 0) {
            stringBuffer.append(string2);
            stringBuffer.append("\n");
            int n2 = n;
            n = Math.min(n2 + 80, string.length());
            string2 = string.substring(n2, n);
        }
        return stringBuffer.toString();
    }

    /*
     * Loose catch block
     */
    public static boolean isTextContainedInFile(String string, String string2) {
        boolean bl;
        block12: {
            BufferedReader bufferedReader = null;
            bl = false;
            bufferedReader = new LineNumberReader(new FileReader(string));
            string = ((LineNumberReader)bufferedReader).readLine();
            while (string != null) {
                if (string.contains(string2)) {
                    bl = true;
                }
                string = ((LineNumberReader)bufferedReader).readLine();
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            break block12;
            catch (IOException iOException) {
                try {
                    Logger.logException("TextUtils", (Exception)iOException);
                }
                catch (Throwable throwable) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException3) {}
            }
        }
        return bl;
    }

    public static String getLinesBetween(String object, String string, String string2, boolean bl, boolean bl2) {
        boolean bl3 = TextUtils.isTextContainedInFile((String)object, string);
        if (!bl3 && !bl2) {
            return "";
        }
        bl2 = false;
        if (!bl3) {
            bl2 = true;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            object = new LineNumberReader(new FileReader((String)object));
            String string3 = ((LineNumberReader)object).readLine();
            while (string3 != null) {
                if (bl2) {
                    if (string3.contains(string2)) {
                        if (!bl) break;
                        stringBuffer.append(string3);
                        stringBuffer.append('\n');
                        break;
                    }
                    stringBuffer.append(string3);
                    stringBuffer.append('\n');
                } else if (string3.contains(string)) {
                    bl2 = true;
                }
                string3 = ((LineNumberReader)object).readLine();
            }
            ((BufferedReader)object).close();
        }
        catch (IOException iOException) {
            Logger.logException("TextUtils", (Exception)iOException);
        }
        return stringBuffer.toString();
    }

    public static void dumpToXml(Object object, StringBuffer stringBuffer, String string, String string2) throws IllegalAccessException {
        Class<?> clazz = object.getClass();
        stringBuffer.append("<" + string);
        stringBuffer.append(" " + string2);
        stringBuffer.append(" classname=\"" + clazz.getName() + "\"");
        TextUtils.a(object, clazz, stringBuffer);
        stringBuffer.append("/>\n");
    }

    private static void a(Object object, Class fieldArray, StringBuffer stringBuffer) throws IllegalAccessException {
        Class clazz = fieldArray.getSuperclass();
        if (clazz != Object.class) {
            TextUtils.a(object, clazz, stringBuffer);
        }
        fieldArray = fieldArray.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Object object2;
            fieldArray[i].setAccessible(true);
            stringBuffer.append(" " + fieldArray[i].getName());
            stringBuffer.append("=\"");
            try {
                object2 = fieldArray[i].get(object);
                if (object2 != null) {
                    Class<?> clazz2 = object2.getClass();
                    if (clazz2.isPrimitive() || clazz2 == Long.class || clazz2 == Integer.class || clazz2 == Boolean.class || clazz2 == Short.class || clazz2 == Byte.class || clazz2 == Double.class || clazz2 == Double.class) {
                        stringBuffer.append(object2);
                    }
                    if (object2.getClass() == String.class) {
                        clazz2 = (String)object2;
                        stringBuffer.append(TextUtils.escapeForXML((String)((Object)clazz2)));
                    }
                    if (object2.getClass() == Timestamp.class) {
                        clazz2 = (Timestamp)object2;
                        clazz2 = "" + ((Timestamp)((Object)clazz2)).getTime();
                        stringBuffer.append((String)((Object)clazz2));
                    }
                    if (object2.getClass() == Date.class) {
                        clazz2 = (java.util.Date)object2;
                        clazz2 = "" + ((java.util.Date)((Object)clazz2)).getTime();
                        stringBuffer.append((String)((Object)clazz2));
                    }
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                object2 = illegalAccessException;
                throw illegalAccessException;
            }
            stringBuffer.append("\"");
        }
    }

    public static void loadAttributesBySetters(Object object, Attributes attributes) throws IllegalAccessException, InvocationTargetException {
        if (object == null) {
            return;
        }
        Method[] methodArray = object.getClass();
        methodArray = methodArray.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!TextUtils.isSetter(method)) continue;
            Object object2 = method.getName();
            Object object3 = ((String)object2).substring(4, ((String)object2).length());
            object2 = Character.valueOf(((String)object2).charAt(3));
            object2 = "" + object2;
            object2 = ((String)object2).toLowerCase();
            object2 = (String)object2 + (String)object3;
            object2 = attributes.getValue((String)object2);
            object3 = method.getParameterTypes();
            if ((object3 = object3[0]) == Double.TYPE) {
                object3 = 0.0;
                if (Validators.correctDouble((String)object2)) {
                    object3 = Utils.parseDouble((String)object2);
                }
                method.invoke(object, object3);
                continue;
            }
            if (object3 == Integer.TYPE) {
                object3 = new Integer(0);
                if (Validators.correctInteger((String)object2)) {
                    object3 = Integer.parseInt((String)object2);
                }
                method.invoke(object, object3);
                continue;
            }
            if (object3 == Boolean.TYPE) {
                object3 = Boolean.FALSE;
                if (Validators.correctBoolean((String)object2)) {
                    object3 = Boolean.parseBoolean((String)object2);
                }
                method.invoke(object, object3);
                continue;
            }
            if (object3 == Timestamp.class) {
                if (!Validators.correctBigInteger((String)object2)) continue;
                object3 = Long.parseLong((String)object2);
                object2 = new Timestamp((Long)object3);
                method.invoke(object, object2);
                continue;
            }
            if (object3 == java.util.Date.class) {
                if (!Validators.correctBigInteger((String)object2)) continue;
                object3 = Long.parseLong((String)object2);
                object2 = new java.util.Date((Long)object3);
                method.invoke(object, object2);
                continue;
            }
            method.invoke(object, object2);
        }
    }

    public static void printGettersSetters(Class methodArray) {
        methodArray = methodArray.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (TextUtils.isGetter(method)) {
                System.out.println("getter: " + method);
            }
            if (!TextUtils.isSetter(method)) continue;
            System.out.println("setter: " + method);
        }
    }

    public static boolean isGetter(Method method) {
        if (!method.getName().startsWith("get")) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return !Void.TYPE.equals(method.getReturnType());
    }

    public static boolean isSetter(Method method) {
        if (!method.getName().startsWith("set")) {
            return false;
        }
        return method.getParameterTypes().length == 1;
    }

    public static String dump(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            stringBuffer.append("Array: ");
            stringBuffer.append("[");
            for (int i = 0; i < Array.getLength(object); ++i) {
                Object object2 = Array.get(object, i);
                if (object2.getClass().isPrimitive() || object2.getClass() == Long.class || object2.getClass() == Integer.class || object2.getClass() == Boolean.class || object2.getClass() == String.class || object2.getClass() == Short.class || object2.getClass() == Byte.class) {
                    stringBuffer.append(object2);
                    if (i == Array.getLength(object) - 1) continue;
                    stringBuffer.append(",");
                    continue;
                }
                stringBuffer.append(TextUtils.dump(object2));
            }
            stringBuffer.append("]\n");
        } else {
            stringBuffer.append("Class: " + clazz.getName());
            stringBuffer.append("{\n");
            while (clazz != null) {
                Field[] fieldArray = clazz.getDeclaredFields();
                for (int i = 0; i < fieldArray.length; ++i) {
                    fieldArray[i].setAccessible(true);
                    stringBuffer.append(fieldArray[i].getName());
                    stringBuffer.append("=");
                    try {
                        Object object3 = fieldArray[i].get(object);
                        if (object3 != null) {
                            if (object3.getClass().isPrimitive() || object3.getClass() == Long.class || object3.getClass() == String.class || object3.getClass() == Integer.class || object3.getClass() == Boolean.class || object3.getClass() == Short.class || object3.getClass() == Byte.class) {
                                stringBuffer.append(object3);
                            } else {
                                stringBuffer.append(TextUtils.dump(object3));
                            }
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        stringBuffer.append(illegalAccessException.getMessage());
                    }
                    stringBuffer.append("\n");
                }
                clazz = clazz.getSuperclass();
            }
            stringBuffer.append("}\n");
        }
        return stringBuffer.toString();
    }
}

