/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.dbf;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import ro.atreides.utils.dbf.DbfUtils;

public class DBFField {
    public static final byte FIELD_TYPE_C = 67;
    public static final byte FIELD_TYPE_L = 76;
    public static final byte FIELD_TYPE_N = 78;
    public static final byte FIELD_TYPE_F = 70;
    public static final byte FIELD_TYPE_D = 68;
    public static final byte FIELD_TYPE_M = 77;
    private byte[] a = new byte[11];
    private byte b;
    private int c;
    private byte d;
    private byte[] e = new byte[7];
    private int f = 0;

    protected static DBFField createField(DataInput dataInput) throws IOException {
        DBFField dBFField = new DBFField();
        int n = dataInput.readByte();
        if (n == 13) {
            return null;
        }
        dataInput.readFully(dBFField.a, 1, 10);
        dBFField.a[0] = n;
        for (n = 0; n < dBFField.a.length; ++n) {
            if (dBFField.a[n] != 0) continue;
            dBFField.f = n;
            break;
        }
        dBFField.b = dataInput.readByte();
        DbfUtils.readLittleEndianInt(dataInput);
        dBFField.c = dataInput.readUnsignedByte();
        dBFField.d = dataInput.readByte();
        DbfUtils.readLittleEndianShort(dataInput);
        dataInput.readByte();
        DbfUtils.readLittleEndianShort(dataInput);
        dataInput.readByte();
        dataInput.readFully(dBFField.e);
        dataInput.readByte();
        return dBFField;
    }

    protected void write(DataOutput dataOutput) throws IOException {
        dataOutput.write(this.a);
        dataOutput.write(new byte[11 - this.a.length]);
        dataOutput.writeByte(this.b);
        dataOutput.writeInt(0);
        dataOutput.writeByte(this.c);
        dataOutput.writeByte(this.d);
        dataOutput.writeShort(0);
        dataOutput.writeByte(0);
        dataOutput.writeShort(0);
        dataOutput.writeByte(0);
        dataOutput.write(new byte[7]);
        dataOutput.writeByte(0);
    }

    public String getName() {
        return new String(this.a, 0, this.f);
    }

    public byte getDataType() {
        return this.b;
    }

    public int getFieldLength() {
        return this.c;
    }

    public int getDecimalCount() {
        return this.d;
    }

    public void setFieldName(String string) {
        this.setName(string);
    }

    public void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (string.length() == 0 || string.length() > 10) {
            throw new IllegalArgumentException("Field name should be of length 0-10");
        }
        this.a = string.getBytes();
        this.f = this.a.length;
    }

    public void setDataType(byte by) {
        switch (by) {
            case 68: {
                this.c = 8;
            }
            case 67: 
            case 70: 
            case 76: 
            case 77: 
            case 78: {
                this.b = by;
                return;
            }
        }
        throw new IllegalArgumentException("Unknown data type");
    }

    public void setFieldLength(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Field length should be a positive number");
        }
        if (this.b == 68) {
            throw new UnsupportedOperationException("Cannot do this on a Date field");
        }
        this.c = n;
    }

    public void setDecimalCount(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Decimal length should be a positive number");
        }
        if (n > this.c) {
            throw new IllegalArgumentException("Decimal length should be less than field length");
        }
        this.d = (byte)n;
    }
}

