/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.dbf;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import ro.atreides.utils.dbf.DBFBase;
import ro.atreides.utils.dbf.DBFException;
import ro.atreides.utils.dbf.DBFField;
import ro.atreides.utils.dbf.DbfUtils;
import ro.atreides.utils.dbf.a;

public class DBFWriter
extends DBFBase {
    private a a;
    private Vector b = new Vector();
    private int c = 0;
    private RandomAccessFile d = null;

    public DBFWriter() {
        this.a = new a();
    }

    public DBFWriter(File file) throws DBFException {
        try {
            this.d = new RandomAccessFile(file, "rw");
            if (!file.exists() || file.length() == 0L) {
                this.a = new a();
                return;
            }
            this.a = new a();
            this.a.a(this.d);
            this.d.seek(this.d.length() - 1L);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DBFException("Specified file is not found. " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new DBFException(iOException.getMessage() + " while reading header");
        }
        this.c = this.a.d;
    }

    public void setFields(DBFField[] dBFFieldArray) throws DBFException {
        if (this.a.g != null) {
            throw new DBFException("Fields has already been set");
        }
        if (dBFFieldArray == null || dBFFieldArray.length == 0) {
            throw new DBFException("Should have at least one field");
        }
        for (int i = 0; i < dBFFieldArray.length; ++i) {
            if (dBFFieldArray[i] != null) continue;
            throw new DBFException("Field " + (i + 1) + " is null");
        }
        this.a.g = dBFFieldArray;
        try {
            if (this.d != null && this.d.length() == 0L) {
                this.a.a(this.d);
            }
            return;
        }
        catch (IOException iOException) {
            throw new DBFException("Error accesing file");
        }
    }

    public void addRecord(Object[] objectArray) throws DBFException {
        if (this.a.g == null) {
            throw new DBFException("Fields should be set before adding records");
        }
        if (objectArray == null) {
            throw new DBFException("Null cannot be added as row");
        }
        if (objectArray.length != this.a.g.length) {
            throw new DBFException("Invalid record. Invalid number of fields in row");
        }
        block9: for (int i = 0; i < this.a.g.length; ++i) {
            if (objectArray[i] == null) continue;
            switch (this.a.g[i].getDataType()) {
                case 67: {
                    if (objectArray[i] instanceof String) continue block9;
                    throw new DBFException("Invalid value for field " + i);
                }
                case 76: {
                    if (objectArray[i] instanceof Boolean) continue block9;
                    throw new DBFException("Invalid value for field " + i);
                }
                case 78: {
                    if (objectArray[i] instanceof Double) continue block9;
                    throw new DBFException("Invalid value for field " + i);
                }
                case 68: {
                    if (objectArray[i] instanceof Date) continue block9;
                    throw new DBFException("Invalid value for field " + i);
                }
                case 70: {
                    if (objectArray[i] instanceof Double) continue block9;
                    throw new DBFException("Invalid value for field " + i);
                }
            }
        }
        if (this.d == null) {
            this.b.addElement(objectArray);
            return;
        }
        try {
            this.a(this.d, objectArray);
            ++this.c;
            return;
        }
        catch (IOException iOException) {
            throw new DBFException("Error occured while writing record. " + iOException.getMessage());
        }
    }

    public void write(OutputStream outputStream) throws DBFException {
        try {
            if (this.d == null) {
                outputStream = new DataOutputStream(outputStream);
                this.a.d = this.b.size();
                this.a.a((DataOutput)((Object)outputStream));
                int n = this.b.size();
                for (int i = 0; i < n; ++i) {
                    Object[] objectArray = (Object[])this.b.elementAt(i);
                    this.a((DataOutput)((Object)outputStream), objectArray);
                }
            } else {
                this.a.d = this.c;
                this.d.seek(0L);
                this.a.a(this.d);
                this.d.seek(this.d.length());
                this.d.writeByte(26);
                this.d.close();
                return;
            }
            ((DataOutputStream)outputStream).write(26);
            ((DataOutputStream)outputStream).flush();
        }
        catch (IOException iOException) {
            throw new DBFException(iOException.getMessage());
        }
    }

    public void write() throws DBFException {
        this.write(null);
    }

    private void a(DataOutput dataOutput, Object[] objectArray) throws IOException {
        dataOutput.write(32);
        block8: for (int i = 0; i < this.a.g.length; ++i) {
            switch (this.a.g[i].getDataType()) {
                case 67: {
                    Object object;
                    if (objectArray[i] != null) {
                        object = objectArray[i].toString();
                        dataOutput.write(DbfUtils.textPadding((String)object, this.characterSetName, this.a.g[i].getFieldLength()));
                        continue block8;
                    }
                    dataOutput.write(DbfUtils.textPadding("", this.characterSetName, this.a.g[i].getFieldLength()));
                    continue block8;
                }
                case 68: {
                    Object object;
                    if (objectArray[i] != null) {
                        object = new GregorianCalendar();
                        ((Calendar)object).setTime((Date)objectArray[i]);
                        dataOutput.write(String.valueOf(((Calendar)object).get(1)).getBytes());
                        dataOutput.write(DbfUtils.textPadding(String.valueOf(((Calendar)object).get(2) + 1), this.characterSetName, 2, 12, (byte)48));
                        dataOutput.write(DbfUtils.textPadding(String.valueOf(((Calendar)object).get(5)), this.characterSetName, 2, 12, (byte)48));
                        continue block8;
                    }
                    dataOutput.write("        ".getBytes());
                    continue block8;
                }
                case 70: {
                    if (objectArray[i] != null) {
                        dataOutput.write(DbfUtils.doubleFormating((Double)objectArray[i], this.characterSetName, this.a.g[i].getFieldLength(), this.a.g[i].getDecimalCount()));
                        continue block8;
                    }
                    dataOutput.write(DbfUtils.textPadding(" ", this.characterSetName, this.a.g[i].getFieldLength(), 12));
                    continue block8;
                }
                case 78: {
                    if (objectArray[i] != null) {
                        dataOutput.write(DbfUtils.doubleFormating((Double)objectArray[i], this.characterSetName, this.a.g[i].getFieldLength(), this.a.g[i].getDecimalCount()));
                        continue block8;
                    }
                    dataOutput.write(DbfUtils.textPadding(" ", this.characterSetName, this.a.g[i].getFieldLength(), 12));
                    continue block8;
                }
                case 76: {
                    if (objectArray[i] != null) {
                        if ((Boolean)objectArray[i] == Boolean.TRUE) {
                            dataOutput.write(84);
                            continue block8;
                        }
                        dataOutput.write(70);
                        continue block8;
                    }
                    dataOutput.write(63);
                    continue block8;
                }
                case 77: {
                    continue block8;
                }
                default: {
                    throw new DBFException("Unknown field type " + this.a.g[i].getDataType());
                }
            }
        }
    }
}

