/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.MyJtextAreaWrapper;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.table.ColumnSizeProvider;
import ro.deversoft.utils.noarch.Logger;

public class GuiUtils {
    public static boolean isFullScreen = false;
    public static JFrame currentFrame;
    public static String appTitle;
    public static String clientName;
    public static String currentVersion;
    public static boolean daemon;
    private static final GridBagConstraints a;

    public static String[] getAllFonts() {
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment();
        stringArray = stringArray.getAvailableFontFamilyNames();
        return stringArray;
    }

    public static void selectAllText(JTextField jTextField) {
        jTextField.setSelectionStart(0);
        jTextField.setSelectionEnd(jTextField.getText().length());
    }

    public static void updateJTableColumnSize(JTable jTable, ColumnSizeProvider columnSizeProvider) {
        Dimension dimension = jTable.getPreferredSize();
        double d2 = 0.0;
        for (int i = 0; i < jTable.getColumnModel().getColumnCount(); ++i) {
            d2 += (double)columnSizeProvider.getColumnSize(i);
        }
        double d3 = dimension.width;
        double d4 = d3 / d2;
        for (int i = 0; i < jTable.getColumnModel().getColumnCount(); ++i) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(i);
            double d5 = d4 * (double)columnSizeProvider.getColumnSize(i);
            tableColumn.setPreferredWidth((int)d5);
            tableColumn.setWidth((int)d5);
        }
    }

    public static void updateJTableColumns(JTable enumeration, DefaultTableCellRenderer defaultTableCellRenderer) {
        enumeration = ((JTable)((Object)enumeration)).getColumnModel();
        enumeration = enumeration.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setCellRenderer(defaultTableCellRenderer);
        }
    }

    public static Frame getFrameForComponent(Component component) {
        return (Frame)SwingUtilities.windowForComponent(component);
    }

    public static Color negateColor(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        n = 255 - n;
        n2 = 255 - n2;
        n3 = 255 - n3;
        return new Color(n, n2, n3);
    }

    public static void updateJTableRowSize(JTable jTable, int n) {
        jTable.setRowHeight(n);
    }

    public static JPanel wrapInBackgroundImage(JComponent jComponent, Icon icon) {
        return GuiUtils.wrapInBackgroundImage(jComponent, icon, 1, 10);
    }

    public static JPanel wrapInBackgroundImage(JComponent jComponent, Icon icon, int n, int n2) {
        jComponent.setOpaque(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jComponent, a);
        jComponent = new JLabel(icon);
        jComponent.setPreferredSize(new Dimension(1, 1));
        jComponent.setMinimumSize(new Dimension(1, 1));
        ((JLabel)jComponent).setVerticalAlignment(n);
        ((JLabel)jComponent).setHorizontalAlignment(n2);
        jPanel.add((Component)jComponent, a);
        return jPanel;
    }

    public static Color getColor(String string) {
        if (Validators.correctString(string)) {
            int n = Integer.parseInt(string, 16);
            Color color = new Color(n);
            return color;
        }
        return null;
    }

    public static JPanel getCardClientPanel(String object, String object2, int n, int n2, int n3, int n4, String object3, int n5, int n6, int n7, int n8, int n9, String string) throws MalformedURLException {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        jPanel.setOpaque(false);
        object3 = new JLabel((String)object3);
        ((JComponent)object3).setFont(new Font(null, 0, n9));
        Color color = GuiUtils.getColor(string);
        ((JComponent)object3).setForeground(color);
        ((Component)object3).setLocation(n5, n6);
        ((Component)object3).setSize(n7, n8);
        jPanel.add((Component)object3);
        object2 = Utils.getImageFromDiskAbsolutePath((String)object2);
        object2 = new JLabel((Icon)object2);
        ((Component)object2).setLocation(n, n2);
        ((Component)object2).setSize(n3, n4);
        jPanel.add((Component)object2);
        object = Utils.getImageFromDiskAbsolutePath((String)object);
        return GuiUtils.wrapInBackgroundImage(jPanel, (Icon)object);
    }

    public static void setScrollSize(JScrollPane jComponent, int n) {
        JScrollBar jScrollBar = ((JScrollPane)jComponent).getVerticalScrollBar();
        Dimension dimension = jScrollBar.getSize();
        dimension = new Dimension(n, (int)dimension.getHeight());
        jScrollBar.setPreferredSize(dimension);
        jComponent = ((JScrollPane)jComponent).getHorizontalScrollBar();
        dimension = jComponent.getSize();
        dimension = new Dimension((int)dimension.getWidth(), n);
        jComponent.setPreferredSize(dimension);
    }

    public static JPanel buildJTextAreaWithWrapper(JTextArea jTextArea) {
        MyJtextAreaWrapper myJtextAreaWrapper = new MyJtextAreaWrapper((LayoutManager)new MigLayout("wrap", "[grow,fill]", "[grow]"));
        myJtextAreaWrapper.add(jTextArea);
        return myJtextAreaWrapper;
    }

    public static boolean isXComboBox(Component object) {
        return ((String)(object = ((Component)object).toString())).contains("ComboBoxEditor") || ((String)object).contains("javax.swing.JTextField[ComboBox.textField");
    }

    public static boolean openLinkInBrowser(String string) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(new URI(string));
                return true;
            }
            catch (IOException | URISyntaxException exception) {
                Logger.logException(GuiUtils.class.getName(), exception);
            }
        } else {
            try {
                Object object = System.getProperty("os.name").toLowerCase();
                if (((String)object).contains("windows")) {
                    object = Runtime.getRuntime();
                    ((Runtime)object).exec("rundll32 url.dll,FileProtocolHandler " + string);
                } else if (((String)object).contains("mac")) {
                    object = Runtime.getRuntime();
                    ((Runtime)object).exec("open" + string);
                } else if (((String)object).contains("linux")) {
                    object = Runtime.getRuntime();
                    String[] stringArray = new String[]{"firefox", "mozilla", "epiphany", "konqueror", "netscape", "opera", "links", "lynx"};
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < 8; ++i) {
                        stringBuffer.append((i == 0 ? "" : " || ") + stringArray[i] + " \"" + string + "\" ");
                    }
                    ((Runtime)object).exec(new String[]{"sh", "-c", stringBuffer.toString()});
                }
                return true;
            }
            catch (IOException iOException) {
                Logger.logException(GuiUtils.class.getName(), (Exception)iOException);
            }
        }
        return false;
    }

    public static Rectangle computeBounds(Component component, Rectangle rectangle, boolean bl, boolean bl2, int n, int n2) {
        int n3 = (int)rectangle.getX();
        int n4 = (int)rectangle.getY();
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        int n7 = component.getHeight();
        n4 = bl ? n4 + n6 + n2 - n7 : (n4 += n2);
        int n8 = component.getWidth();
        n3 = bl2 ? n3 + n5 + n - n8 : (n3 += n);
        return new Rectangle(n3, n4, n8, n7);
    }

    static {
        daemon = false;
        a = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        GuiUtils.a.gridy = 0;
        GuiUtils.a.weightx = 1.0;
        GuiUtils.a.weighty = 1.0;
        GuiUtils.a.fill = 1;
        GuiUtils.a.anchor = 18;
    }
}

