/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.JComponent;

public class JMultilineLabel
extends JComponent {
    private String text;
    private Insets margin = new Insets(5, 5, 5, 5);
    private int maxWidth = Integer.MAX_VALUE;
    private boolean justify;
    private final FontRenderContext frc = new FontRenderContext(null, false, false);

    private void morph() {
        this.revalidate();
        this.repaint();
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        String string2 = this.text;
        this.text = string;
        this.firePropertyChange("text", string2, this.text);
        if (string2 == null ? string != null : !string2.equals(string)) {
            this.morph();
        }
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        int n2 = this.maxWidth;
        this.maxWidth = n;
        this.firePropertyChange("maxWidth", n2, this.maxWidth);
        if (n2 != this.maxWidth) {
            this.morph();
        }
    }

    public boolean isJustified() {
        return this.justify;
    }

    public void setJustified(boolean bl) {
        boolean bl2 = this.justify;
        this.justify = bl;
        this.firePropertyChange("justified", bl2, this.justify);
        if (bl2 != this.justify) {
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.paintOrGetSize(null, this.getMaxWidth());
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.paintOrGetSize((Graphics2D)graphics, this.getWidth());
    }

    private Dimension paintOrGetSize(Graphics2D graphics2D, int n) {
        Insets insets = this.getInsets();
        double d2 = insets.left + insets.right + this.margin.left + this.margin.right;
        double d3 = insets.left + this.margin.left;
        double d4 = insets.top + this.margin.top;
        if ((n -= insets.left + insets.right + this.margin.left + this.margin.right) > 0 && this.text != null && this.text.length() > 0) {
            Object object = new AttributedString(this.getText());
            ((AttributedString)object).addAttribute(TextAttribute.FONT, this.getFont());
            object = ((AttributedString)object).getIterator();
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer((AttributedCharacterIterator)object, this.frc);
            double d5 = 0.0;
            while (lineBreakMeasurer.getPosition() < object.getEndIndex()) {
                TextLayout textLayout = lineBreakMeasurer.nextLayout(n);
                if (graphics2D != null && this.isJustified() && (double)textLayout.getVisibleAdvance() > 0.8 * (double)n) {
                    textLayout = textLayout.getJustifiedLayout(n);
                }
                if (graphics2D != null) {
                    textLayout.draw(graphics2D, (float)d3, (float)(d4 + (double)textLayout.getAscent()));
                }
                d4 += (double)(textLayout.getDescent() + textLayout.getLeading() + textLayout.getAscent());
                d5 = Math.max(d5, (double)textLayout.getVisibleAdvance());
            }
            d2 += d5;
        }
        return new Dimension((int)Math.ceil(d2), (int)Math.ceil(d4) + insets.bottom + this.margin.bottom);
    }
}

