/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui.keypad;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import ro.atreides.utils.gui.keypad.KeypadListener;
import ro.deversoft.utils.noarch.Logger;

public class VirtualKeypad
extends JPanel {
    private Vector listeners = new Vector();
    private int fontSize;

    public void addKeypadListener(KeypadListener keypadListener) {
        this.listeners.add(keypadListener);
    }

    public VirtualKeypad(int n) {
        this.fontSize = n;
        this.display(null);
    }

    public VirtualKeypad(String string) {
        this.display(string);
    }

    private void display(String object) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (object != null) {
            this.setBorder(new TitledBorder((String)object));
        }
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 7, 7, 7);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.buildDigitButton(7), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.buildDigitButton(8), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.buildDigitButton(9), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.buildDigitButton(4), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.buildDigitButton(5), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.buildDigitButton(6), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.buildDigitButton(1), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.buildDigitButton(2), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.buildDigitButton(3), gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 7, 0, 7);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        object = new JButton("OK");
        ((JComponent)object).setFont(new Font(null, 1, this.fontSize + 2));
        ((JComponent)object).setForeground(Color.RED);
        ((AbstractButton)object).addActionListener(new ActionListener(this){
            private /* synthetic */ VirtualKeypad a;
            {
                this.a = virtualKeypad;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                this.a.okPressed();
            }
        });
        ((Component)object).setFocusable(false);
        this.add((Component)object, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.add((Component)this.buildDigitButton(0), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        object = new JButton("<-");
        ((AbstractButton)object).addActionListener(new ActionListener(this){
            private /* synthetic */ VirtualKeypad a;
            {
                this.a = virtualKeypad;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                this.a.backspace();
            }
        });
        ((Component)object).setFocusable(false);
        this.add((Component)object, gridBagConstraints);
    }

    private JButton buildDigitButton(int n) {
        JButton jButton = new JButton("" + n);
        jButton.setFont(new Font(null, 0, this.fontSize));
        jButton.addActionListener(new ActionListener(this){
            private /* synthetic */ VirtualKeypad a;
            {
                this.a = virtualKeypad;
            }

            @Override
            public final void actionPerformed(ActionEvent object) {
                object = ((ActionEvent)object).getActionCommand();
                try {
                    int n = Integer.parseInt((String)object);
                    this.a.digitPressed(n);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    Logger.logException(this, (Exception)numberFormatException);
                    return;
                }
            }
        });
        jButton.setFocusable(false);
        return jButton;
    }

    private void okPressed() {
        for (KeypadListener keypadListener : this.listeners) {
            keypadListener.okPressed();
        }
    }

    private void backspace() {
        for (KeypadListener keypadListener : this.listeners) {
            keypadListener.backspace();
        }
    }

    private void digitPressed(int n) {
        for (KeypadListener keypadListener : this.listeners) {
            keypadListener.keypadPressed(n);
        }
    }
}

