/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui.keypad;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.keypad.KeypadListener;
import ro.deversoft.utils.noarch.Logger;

public class VirtualKeypad2
extends JPanel {
    private Vector<KeypadListener> listeners = new Vector();
    protected int fontSize;
    protected JTextField _number = new JTextField();
    protected JTextField _valueLine = new JTextField();
    private String valueS = "";
    private double value;
    private boolean enforceIntegers;
    protected Insets buttonMargin;
    protected Insets buttonInsets;
    protected int buttonFill;
    protected JButton decimal;
    protected JButton backspace;
    protected boolean addValueLine = false;

    public String getValueS() {
        return this.valueS;
    }

    public void addKeypadListener(KeypadListener keypadListener) {
        this.listeners.add(keypadListener);
    }

    public VirtualKeypad2(int n, boolean bl) {
        this(n, bl, null, new Insets(0, 7, 7, 7), 1, false);
    }

    public VirtualKeypad2(int n, boolean bl, Insets insets, Insets insets2, int n2) {
        this(n, bl, insets, insets2, n2, false);
    }

    public VirtualKeypad2(int n, boolean bl, Insets insets, Insets insets2, int n2, boolean bl2) {
        this.enforceIntegers = bl;
        this.fontSize = n;
        this.buttonMargin = insets;
        this.buttonInsets = insets2;
        this.buttonFill = n2;
        this.addValueLine = bl2;
        this.display(null);
    }

    public void setNumberEditable(boolean bl) {
        this._number.setEditable(bl);
    }

    protected void initButtons() {
        this._number.setEditable(false);
        this._number.setFont(new Font(null, 1, this.fontSize + 2));
        this._number.setForeground(Color.RED);
        this._number.addKeyListener(new KeyListener(this){
            private /* synthetic */ VirtualKeypad2 a;
            {
                this.a = virtualKeypad2;
            }

            @Override
            public final void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public final void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() >= '0' && keyEvent.getKeyChar() <= '9') {
                    int n = keyEvent.getKeyChar() - 48;
                    this.a.digitPressed(n);
                    return;
                }
                if (keyEvent.getKeyCode() == 8) {
                    this.a.backspace();
                    return;
                }
                if (keyEvent.getKeyCode() == 10) {
                    this.a.enterPressed();
                    return;
                }
                if (keyEvent.getKeyChar() == '.' && !this.a.enforceIntegers && !this.a.valueS.contains(".")) {
                    this.a.decimalPressed();
                    return;
                }
                System.out.println("char REFUSED : keychar " + keyEvent.getKeyChar() + " keycode : " + keyEvent.getKeyCode());
            }

            @Override
            public final void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.decimal = new JButton(".");
        this.decimal.setFont(new Font(null, 1, this.fontSize + 2));
        this.decimal.setForeground(Color.RED);
        this.decimal.addActionListener(new ActionListener(this){
            private /* synthetic */ VirtualKeypad2 a;
            {
                this.a = virtualKeypad2;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                this.a.decimalPressed();
            }
        });
        this.decimal.setFocusable(false);
        this.decimal.setMargin(this.buttonMargin);
        this.backspace = new JButton("<-");
        this.backspace.addActionListener(new ActionListener(this){
            private /* synthetic */ VirtualKeypad2 a;
            {
                this.a = virtualKeypad2;
            }

            @Override
            public final void actionPerformed(ActionEvent actionEvent) {
                this.a.backspace();
            }
        });
        this.backspace.setForeground(Color.RED);
        this.backspace.setFont(new Font(null, 1, this.fontSize + 2));
        this.backspace.setFocusable(false);
        this.backspace.setMargin(this.buttonMargin);
    }

    protected void display(String string) {
        this.initButtons();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (string != null) {
            this.setBorder(new TitledBorder(string));
        }
        gridBagConstraints.fill = this.buttonFill;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = this.buttonInsets;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        this.add((Component)this._number, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.buildDigitButton(7), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.buildDigitButton(8), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.add((Component)this.buildDigitButton(9), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.buildDigitButton(4), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.buildDigitButton(5), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.add((Component)this.buildDigitButton(6), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.buildDigitButton(1), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.buildDigitButton(2), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.add((Component)this.buildDigitButton(3), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.decimal, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.buildDigitButton(0), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.add((Component)this.backspace, gridBagConstraints);
    }

    protected JButton buildDigitButton(int n) {
        JButton jButton = new JButton("" + n);
        jButton.setFont(new Font(null, 0, this.fontSize));
        jButton.addActionListener(new ActionListener(this){
            private /* synthetic */ VirtualKeypad2 a;
            {
                this.a = virtualKeypad2;
            }

            @Override
            public final void actionPerformed(ActionEvent object) {
                object = ((ActionEvent)object).getActionCommand();
                try {
                    int n = Integer.parseInt((String)object);
                    this.a.digitPressed(n);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    Logger.logException(this, (Exception)numberFormatException);
                    return;
                }
            }
        });
        jButton.setFocusable(false);
        jButton.setMargin(this.buttonMargin);
        return jButton;
    }

    private void decimalPressed() {
        if (!this.valueS.contains(".") || !this.enforceIntegers) {
            this.valueS = this.valueS + ".";
            System.out.println("DECIMAL POINT ACCEPTED");
        }
        this.updateValue();
        for (KeypadListener keypadListener : this.listeners) {
            keypadListener.decimalPressed();
        }
    }

    private void backspace() {
        if (this.valueS.length() > 0) {
            this.valueS = this.valueS.substring(0, this.valueS.length() - 1);
            this.updateValue();
            for (KeypadListener keypadListener : this.listeners) {
                keypadListener.backspace();
            }
        }
    }

    private void digitPressed(int n) {
        this.valueS = this.valueS + n;
        this.updateValue();
        for (KeypadListener keypadListener : this.listeners) {
            keypadListener.keypadPressed(n);
        }
    }

    private void enterPressed() {
        for (KeypadListener keypadListener : this.listeners) {
            keypadListener.enterPressed();
        }
    }

    private void updateValue() {
        System.out.println("Values : " + this.valueS);
        try {
            this.value = Utils.parseDouble(this.valueS);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            if (this.enforceIntegers) {
                this.value = 0.0;
                this.valueS = "";
            }
            return;
        }
        finally {
            this._number.setText(this.valueS);
        }
    }

    public void setNumber(double d2) {
        this.valueS = Utils.getString3Decimals(d2);
        this.updateValue();
    }

    public void reset() {
        this.valueS = "";
        this.updateValue();
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public void requestFocus() {
        this._number.requestFocus();
    }

    public void setValueLine(String string) {
        this._valueLine.setText(string);
    }
}

