/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.licensing;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.security.MessageDigest;
import java.text.ParseException;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.licensing.DiskIdBean;
import ro.deversoft.utils.noarch.Formatters;
import ro.deversoft.utils.noarch.Logger;
import ro.deversoft.utils.noarch.UtilsNoarch;

public class LicenseVerifier {
    public static String getAppIdentifier(int n) {
        try {
            return LicenseVerifier.getHddID() + UtilsNoarch.getStringMaxSize(2, "" + n, new Character('0'), true);
        }
        catch (IOException iOException) {
            Logger.logException("LicenseVerifier", (Exception)iOException);
            return null;
        }
    }

    public static boolean isLicensed(String string, int n) {
        try {
            Object object = LicenseVerifier.getAppIdentifier(n);
            if (object == null || ((String)object).length() <= 0) {
                return false;
            }
            Object object2 = MessageDigest.getInstance("SHA1");
            object = (String)object + "d1hfu53j4h5jhg4asb5ndhjkdf8hgj2dfhg7k345";
            ((MessageDigest)object2).update(((String)object).getBytes());
            object = ((MessageDigest)object2).digest();
            object2 = new StringBuffer(((Object)object).length);
            for (int i = 0; i < ((Object)object).length; ++i) {
                Object object3 = object[i];
                ((StringBuffer)object2).append(Integer.toHexString(0xFF & object3));
            }
            if (((StringBuffer)object2).toString().equalsIgnoreCase(string)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
        }
        return false;
    }

    public static String getHddID() throws IOException {
        String string = System.getProperty("os.name");
        string = string.toLowerCase();
        System.out.println("osname : " + string);
        if (string.startsWith("linux")) {
            string = LicenseVerifier.getHddID_cid_linux();
            System.out.println("sdcard hddId : " + string);
            if (!Validators.correctString(string)) {
                string = LicenseVerifier.getHddID_scsiinfo();
                System.out.println("scsi hddId : " + string);
                if (!Validators.correctString(string)) {
                    string = LicenseVerifier.getHddID_hdparm();
                    System.out.println("hdparm hddId : " + string);
                }
            }
            return string;
        }
        if (string.startsWith("windows")) {
            string = LicenseVerifier.getHddID_diskid();
            System.out.println("diskid hddId : " + string);
            if (!Validators.correctString(string)) {
                string = LicenseVerifier.getHddID_vol();
                System.out.println("win hddId : " + string);
            }
            return string;
        }
        if (string.startsWith("mac")) {
            string = LicenseVerifier.getHddID_mac();
            System.out.println("mac Hdd id : " + string);
            return string;
        }
        return null;
    }

    protected static String getHddID_cid_linux() throws IOException {
        Object object = new File("/bin/cat");
        long l = object.length();
        if (l <= 20000L) {
            return null;
        }
        object = "/bin/cat /sys/block/mmcblk0/device/cid";
        object = LicenseVerifier.execute("/bin/cat /sys/block/mmcblk0/device/cid").split("\n");
        if (0 < ((String[])object).length) {
            String string = object[0];
            System.out.println("line: " + object[0]);
            return string;
        }
        return null;
    }

    protected static String getHddID_mac() throws IOException {
        String string = null;
        try {
            Object object = UtilsNoarch.executeGrabOutput(System.getProperty("user.dir"), "/usr/sbin/system_profiler", "SPSerialATADataType");
            object = new LineNumberReader(new InputStreamReader((InputStream)object));
            String string2 = ((LineNumberReader)object).readLine();
            boolean bl = false;
            while (string2 != null) {
                string2 = string2.trim();
                Object object2 = "Line : " + string2;
                Logger.logDebug(LicenseVerifier.class.getName(), (String)object2);
                if (string2.startsWith("Capacity")) {
                    bl = true;
                    object2 = "Found Capacity !!";
                    Logger.logDebug(LicenseVerifier.class.getName(), (String)object2);
                }
                if (bl && string2.startsWith("Serial Number:")) {
                    object2 = UtilsNoarch.splitString(string2, ':');
                    string = ((String)((Vector)object2).get(1)).trim();
                    object = "Found serial number: " + string;
                    Logger.logDebug(LicenseVerifier.class.getName(), (String)object);
                    break;
                }
                string2 = ((LineNumberReader)object).readLine();
            }
        }
        catch (Throwable throwable) {
            Logger.logError((Object)"getHddId_mac", throwable);
        }
        return string;
    }

    protected static String getHddID_hdparm() throws IOException {
        Object object;
        int n;
        String[] stringArray;
        String string = LicenseVerifier.getRootDevice();
        if (string.length() <= 0) {
            return null;
        }
        if (string.startsWith("/dev/md")) {
            stringArray = LicenseVerifier.execute("/sbin/mdadm --detail " + string).split("\n");
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].contains("/sd") || ((Vector)(object = UtilsNoarch.splitString(stringArray[n], ' '))).size() <= 0) continue;
                string = (String)((Vector)object).get(((Vector)object).size() - 1);
                break;
            }
        }
        stringArray = LicenseVerifier.execute("hdparm -I " + string).split("\n");
        for (n = 0; n < stringArray.length; ++n) {
            object = stringArray[n];
            if (!((String)object).contains("Serial Number:")) continue;
            int n2 = ((String)object).indexOf(58) + 1;
            int n3 = ((String)object).length();
            String string2 = ((String)object).substring(n2, n3);
            string2 = string2.trim();
            return string2;
        }
        return null;
    }

    protected static String getHddID_scsiinfo() throws IOException {
        Object object;
        Object object2 = LicenseVerifier.getRootDevice();
        if (object2.length() <= 0) {
            return null;
        }
        if (object2.startsWith("/dev/md") || object2.startsWith("/dev/mapper/")) {
            object = "/sbin/mdadm --detail " + (String)object2;
            try {
                String[] stringArray = LicenseVerifier.execute((String)object).split("\n");
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].contains("/sd") || ((Vector)(object = UtilsNoarch.splitString(stringArray[i], ' '))).size() <= 0) continue;
                    object2 = (String)((Vector)object).get(((Vector)object).size() - 1);
                }
            }
            catch (IOException iOException) {
                object2 = "/dev/sda";
            }
        } else {
            System.out.println("device not raid");
        }
        object = new File("/sbin/scsiinfo");
        long l = ((File)object).length();
        if (l <= 20000L) {
            return null;
        }
        object = "/sbin/scsiinfo -s " + (String)object2;
        object2 = LicenseVerifier.execute((String)object).split("\n");
        for (int i = 0; i < ((String[])object2).length; ++i) {
            String string = object2[i];
            if (!string.startsWith("Serial Number")) continue;
            int n = string.indexOf(39) + 1;
            i = string.lastIndexOf(39);
            String string2 = string.substring(n, i).trim();
            return string2;
        }
        return null;
    }

    protected static String getHddID_vol() throws IOException {
        String[] stringArray = System.getProperty("user.dir");
        stringArray = stringArray.substring(0, stringArray.indexOf(58) + 1);
        stringArray = LicenseVerifier.execute("cmd /c vol " + (String)stringArray).split("\n");
        String string = "Volume Serial Number is";
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            int n = string2.indexOf(string);
            if (n < 0) continue;
            return string2.substring(n + string.length(), string2.length()).trim();
        }
        return null;
    }

    protected static String getHddID_diskid() throws IOException {
        Object object = System.getProperty("user.dir");
        Hashtable<String, DiskIdBean> hashtable = new Hashtable<String, DiskIdBean>();
        String string = "Drive Model Number";
        String string2 = "Drive Serial Number";
        String string3 = "Volume Serial Number is";
        String string4 = "Serial Number";
        String string5 = "";
        boolean bl = false;
        boolean bl2 = false;
        try {
            object = UtilsNoarch.executeGrabOutput((String)object, "diskid32.exe");
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)object));
            String string6 = lineNumberReader.readLine();
            while (string6 != null) {
                System.out.println("diskid: " + string6);
                if (string6.startsWith(string)) {
                    string5 = LicenseVerifier.a(string6);
                    bl = true;
                } else if (string6.startsWith(string3)) {
                    string5 = LicenseVerifier.a(string6);
                    bl2 = true;
                } else if (bl) {
                    if (string6.startsWith(string2)) {
                        object = LicenseVerifier.a(string6);
                        LicenseVerifier.a(string5, (String)object, hashtable);
                        string5 = "";
                        bl = false;
                    } else {
                        System.out.println("diskid : was expecting " + string2);
                    }
                } else if (bl2) {
                    if (string6.startsWith(string4)) {
                        object = LicenseVerifier.a(string6);
                        LicenseVerifier.a(string5, (String)object, hashtable);
                        string5 = "";
                        bl2 = false;
                    } else {
                        System.out.println("diskid : was expecting " + string4);
                    }
                }
                string6 = lineNumberReader.readLine();
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace();
        }
        if (hashtable.size() > 0) {
            object = "";
            for (String string6 : hashtable.keySet()) {
                object = (String)object + string6 + " ";
            }
            object = ((String)object).trim();
            return object;
        }
        return null;
    }

    private static void a(String string, String string2, Hashtable<String, DiskIdBean> hashtable) {
        DiskIdBean diskIdBean = new DiskIdBean();
        string = string.replaceAll(" ", "-");
        string = string.toLowerCase();
        string2 = string2.replaceAll(" ", "-");
        string2 = string2.toLowerCase();
        String string3 = string + "_" + string2;
        System.out.println("diskid : Key= " + string3);
        diskIdBean.setModel(string);
        diskIdBean.setSerial(string2);
        hashtable.put(string3, diskIdBean);
    }

    private static String a(String string) {
        int n = string.lastIndexOf("[");
        int n2 = string.indexOf("]", n);
        String string2 = "";
        if (n2 > n) {
            string2 = string.substring(n + 1, n2).trim();
        }
        return string2;
    }

    protected static String getRootDevice() throws IOException {
        String[] stringArray = LicenseVerifier.execute("df -TP /").split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("line: " + stringArray[i]);
            Object object = stringArray[i];
            if (!((String)object).endsWith("/") || !((StringTokenizer)(object = new StringTokenizer((String)object))).hasMoreTokens()) continue;
            return ((StringTokenizer)object).nextToken();
        }
        return null;
    }

    public static String execute(String object) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        Object object2 = Runtime.getRuntime();
        object = ((Runtime)object2).exec((String)object);
        object = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()));
        while ((object2 = ((BufferedReader)object).readLine()) != null) {
            stringBuffer.append((String)object2);
            stringBuffer.append("\n");
        }
        ((BufferedReader)object).close();
        return stringBuffer.toString();
    }

    @Deprecated
    public static boolean verifyChecksum(String string, StringBuffer object) {
        try {
            SAXParser sAXParser = new SAXParser();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            object = new DefaultHandler(stringBuffer2, stringBuffer, (StringBuffer)object){
                private /* synthetic */ StringBuffer a;
                private /* synthetic */ StringBuffer b;
                private /* synthetic */ StringBuffer c;
                {
                    this.a = stringBuffer;
                    this.b = stringBuffer2;
                    this.c = stringBuffer3;
                }

                @Override
                public final void startElement(String object, String string, String string2, Attributes attributes) throws SAXException {
                    String string3;
                    if (string2.equalsIgnoreCase("license")) {
                        int n;
                        this.a.append(attributes.getValue("checksum"));
                        object = attributes.getValue("sequence");
                        if (Validators.correctString((String)object) && (n = Integer.parseInt((String)object)) > 0) {
                            this.b.append((String)object);
                            this.c.append((String)object);
                        }
                        string = "generatedAt";
                        string3 = attributes.getValue(string);
                        this.b.append(string3);
                        try {
                            object = Formatters.DATE_AND_TIME_FORMAT.parse(string3);
                            if (!((Date)object).before(new Date())) {
                                this.b.append("1");
                                System.out.println("Data < data generare");
                            } else if (((Date)(object = DateUtils.addDaysToDate((Date)object, 7))).after((Date)object)) {
                                System.out.println("Data curenta > data generare + 7");
                                this.b.append("1");
                            }
                        }
                        catch (ParseException parseException) {
                            Logger.logException(this, (Exception)parseException);
                            this.b.append("1");
                            System.out.println("Data generare incorecta");
                        }
                    }
                    if (string2.equalsIgnoreCase("systemProperty")) {
                        object = attributes.getValue("name");
                        string = attributes.getValue("value");
                        this.b.append((String)object + string);
                    }
                    if (string2.equalsIgnoreCase("clientProperty")) {
                        object = attributes.getValue("name");
                        string = attributes.getValue("value");
                        this.b.append((String)object + string);
                    }
                    if (string2.equalsIgnoreCase("app")) {
                        object = attributes.getValue("name");
                        string = attributes.getValue("days");
                        this.b.append((String)object + string);
                    }
                    if (string2.equalsIgnoreCase("module")) {
                        object = attributes.getValue("name");
                        string = attributes.getValue("days");
                        string3 = attributes.getValue("classname");
                        this.b.append((String)object + string + string3);
                    }
                    if (string2.equalsIgnoreCase("client")) {
                        object = attributes.getValue("name");
                        string = attributes.getValue("days");
                        this.b.append((String)object + string);
                    }
                }
            };
            sAXParser.setContentHandler((ContentHandler)object);
            sAXParser.setErrorHandler((ErrorHandler)object);
            sAXParser.parse(string);
            string = UtilsNoarch.computeChecksum(stringBuffer.toString());
            object = stringBuffer2.toString();
            return string.equals(object);
        }
        catch (IOException iOException) {
            Logger.logException(Class.class.getName(), (Exception)iOException);
        }
        catch (SAXException sAXException) {
            Logger.logException(Class.class.getName(), (Exception)sAXException);
        }
        return false;
    }
}

