/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.drivers.datecs.gen3.noarch;

import java.text.ParseException;
import ro.deversoft.utils.noarch.Formatters;

public class Validators {
    public static boolean correctString(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean correctDouble(String string) {
        if (Validators.correctString(string)) {
            try {
                Double.parseDouble(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return false;
    }

    public static boolean correctInteger(String string) {
        if (Validators.correctString(string)) {
            try {
                Validators.parseIntNoThousandSeparator(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return false;
    }

    public static int parseIntNoThousandSeparator(String string) throws NumberFormatException {
        try {
            return Formatters.NUMBER_0DECIMALS.parse(string).intValue();
        }
        catch (ParseException parseException) {
            throw new NumberFormatException(parseException.getMessage());
        }
    }
}

