/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.drivers.datecs.gen3.noarch.commands;

import java.util.Vector;
import ro.deversoft.drivers.datecs.gen3.noarch.Constants;
import ro.deversoft.drivers.datecs.gen3.noarch.Utils;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.Command;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.dailyClosure.Raport;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.informationToHost.DiagnosticResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.informationToHost.InfoCurentReceipt;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.informationToHost.LastDocumentPrinted;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.informationToHost.ReadingDateResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.informationToHost.TaxRegistrationNumber;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.others.CloseNonFiscalReceiptResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.others.DebetingCrediting;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.others.OpenNonFiscalReceiptResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.reports.ItemReportResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.reports.TaxRatesDruingPeriodResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.sales.ClosingFiscalReceiptResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.sales.OpeningFiscalReceiptResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.sales.SubtotalResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.sales.TotalResponse;

public class Response
extends Command {
    private byte[] data;
    private byte[] status;
    private boolean nakResponse = false;
    private boolean corectResponse = false;
    private boolean timeout = false;
    private Vector<Constants.ERROR_TYPE> errors = new Vector();
    private Vector<Constants.ERROR_TYPE> warnings = new Vector();
    private Vector<Constants.ERROR_TYPE> infos = new Vector();

    public Response(byte[] byArray, byte[] byArray2) {
        this.data = byArray;
        this.status = byArray2;
        this.corectResponse = true;
        this.readStatus(byArray2);
    }

    public Response() {
    }

    @Override
    protected byte[] buildData() {
        byte[] byArray = new byte[this.data.length + this.status.length + 1];
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        byArray[this.data.length] = 4;
        System.arraycopy(this.status, 0, byArray, byArray.length - 6, this.status.length);
        return byArray;
    }

    public static Object buildResponse(byte[] object) {
        byte by = object[0];
        byte[] byArray = new byte[((byte[])object).length - 1];
        System.arraycopy(object, 1, byArray, 0, ((byte[])object).length - 1);
        String string = Utils.getStringFromAscii(byArray);
        String[] stringArray = new String[((byte[])object).length - 1];
        if (((byte[])object).length > 1) {
            stringArray = string.split(",");
        }
        switch (by) {
            case 69: {
                Raport raport = new Raport(stringArray);
                object = raport;
                raport.setTipRaspuns(1);
                return object;
            }
            case 103: {
                InfoCurentReceipt infoCurentReceipt = new InfoCurentReceipt(stringArray);
                object = infoCurentReceipt;
                infoCurentReceipt.setTipRaspuns(2);
                return object;
            }
            case 113: {
                LastDocumentPrinted lastDocumentPrinted = new LastDocumentPrinted(stringArray);
                object = lastDocumentPrinted;
                lastDocumentPrinted.setTipRaspuns(3);
                return object;
            }
            case 99: {
                TaxRegistrationNumber taxRegistrationNumber = new TaxRegistrationNumber(stringArray);
                object = taxRegistrationNumber;
                taxRegistrationNumber.setTipRaspuns(4);
                return object;
            }
            case 39: {
                CloseNonFiscalReceiptResponse closeNonFiscalReceiptResponse = new CloseNonFiscalReceiptResponse(stringArray);
                object = closeNonFiscalReceiptResponse;
                closeNonFiscalReceiptResponse.setTipRaspuns(5);
                return object;
            }
            case 70: {
                DebetingCrediting debetingCrediting = new DebetingCrediting(stringArray);
                object = debetingCrediting;
                debetingCrediting.setTipRaspuns(6);
                return object;
            }
            case 38: {
                OpenNonFiscalReceiptResponse openNonFiscalReceiptResponse = new OpenNonFiscalReceiptResponse(stringArray);
                object = openNonFiscalReceiptResponse;
                openNonFiscalReceiptResponse.setTipRaspuns(7);
                return object;
            }
            case 111: {
                ItemReportResponse itemReportResponse = new ItemReportResponse(stringArray);
                object = itemReportResponse;
                itemReportResponse.setTipRaspuns(8);
                return object;
            }
            case 50: {
                TaxRatesDruingPeriodResponse taxRatesDruingPeriodResponse = new TaxRatesDruingPeriodResponse(stringArray);
                object = taxRatesDruingPeriodResponse;
                taxRatesDruingPeriodResponse.setTipRaspuns(9);
                return object;
            }
            case 56: {
                ClosingFiscalReceiptResponse closingFiscalReceiptResponse = new ClosingFiscalReceiptResponse(stringArray);
                object = closingFiscalReceiptResponse;
                closingFiscalReceiptResponse.setTipRaspuns(10);
                return object;
            }
            case 48: {
                OpeningFiscalReceiptResponse openingFiscalReceiptResponse = new OpeningFiscalReceiptResponse(stringArray);
                object = openingFiscalReceiptResponse;
                openingFiscalReceiptResponse.setTipRaspuns(11);
                return object;
            }
            case 51: {
                SubtotalResponse subtotalResponse = new SubtotalResponse(stringArray);
                object = subtotalResponse;
                subtotalResponse.setTipRaspuns(12);
                return object;
            }
            case 53: {
                TotalResponse totalResponse = new TotalResponse(byArray);
                object = totalResponse;
                totalResponse.setTipRaspuns(13);
                return object;
            }
            case 62: {
                ReadingDateResponse readingDateResponse = new ReadingDateResponse(stringArray);
                object = readingDateResponse;
                readingDateResponse.setTipRaspuns(14);
                return object;
            }
            case 90: {
                DiagnosticResponse diagnosticResponse = new DiagnosticResponse(stringArray);
                object = diagnosticResponse;
                diagnosticResponse.setTipRaspuns(15);
                return object;
            }
        }
        return null;
    }

    private void readStatus(byte[] byArray) {
        byte by = byArray[0];
        boolean bl = Utils.isOn(by, 0);
        boolean bl2 = Utils.isOn(by, 1);
        boolean bl3 = Utils.isOn(by, 3);
        by = (byte)(Utils.isOn(by, 5) ? 1 : 0);
        if (bl) {
            this.errors.add(Constants.ERROR_TYPE.msg00_SYNTAX_ERROR);
        }
        if (bl2) {
            this.errors.add(Constants.ERROR_TYPE.msg01_INVALID_COMMAND_CODE);
        }
        if (bl3) {
            this.warnings.add(Constants.ERROR_TYPE.msg03_CUSTOMER_DISPLAY_ERROR);
        }
        if (by != 0) {
            this.errors.add(Constants.ERROR_TYPE.msg05_GENERAL_ERROR);
        }
        by = byArray[1];
        bl = Utils.isOn(by, 6);
        bl2 = Utils.isOn(by, 1);
        by = (byte)(Utils.isOn(by, 0) ? 1 : 0);
        if (bl) {
            this.errors.add(Constants.ERROR_TYPE.msg16);
        }
        if (bl2) {
            this.errors.add(Constants.ERROR_TYPE.msg11_COMMAND_NOT_ALLOWED_IN_CURRENT_FISCAL_MODE);
        }
        if (by != 0) {
            this.errors.add(Constants.ERROR_TYPE.msg10);
        }
        by = byArray[2];
        bl = Utils.isOn(by, 0);
        bl2 = Utils.isOn(by, 2);
        bl3 = Utils.isOn(by, 3);
        boolean bl4 = Utils.isOn(by, 4);
        boolean bl5 = Utils.isOn(by, 5);
        by = (byte)(bl5 ? 1 : 0);
        if (bl5) {
            this.infos.add(Constants.ERROR_TYPE.msg25);
        }
        if (bl4) {
            this.warnings.add(Constants.ERROR_TYPE.msg24);
        }
        if (bl3) {
            this.infos.add(Constants.ERROR_TYPE.msg23_FISCAL_RECEIPT_OPEN);
        }
        if (bl2) {
            this.warnings.add(Constants.ERROR_TYPE.msg22);
        }
        if (bl) {
            this.errors.add(Constants.ERROR_TYPE.msg20_NO_PAPER);
        }
        by = byArray[3];
        Utils.isOn(by, 4);
        Utils.getBinary(by);
        by = byArray[4];
        bl = Utils.isOn(by, 5);
        bl2 = Utils.isOn(by, 4);
        bl3 = Utils.isOn(by, 3);
        bl4 = Utils.isOn(by, 2);
        by = (byte)(Utils.isOn(by, 1) ? 1 : 0);
        if (bl) {
            this.warnings.add(Constants.ERROR_TYPE.msg45);
        }
        if (bl2) {
            this.errors.add(Constants.ERROR_TYPE.msg44_FISCAL_MEMORY_FULL);
        }
        if (bl3) {
            this.warnings.add(Constants.ERROR_TYPE.msg43_FISCAL_MEMORY_NEAR_FULL);
        }
        if (bl4) {
            this.infos.add(Constants.ERROR_TYPE.msg42);
        }
        if (by != 0) {
            this.infos.add(Constants.ERROR_TYPE.msg41);
        }
        byte by2 = byArray[5];
        by = (byte)(Utils.isOn(by2, 4) ? 1 : 0);
        bl = Utils.isOn(by2, 3);
        by2 = (byte)(Utils.isOn(by2, 1) ? 1 : 0);
        if (by != 0) {
            this.infos.add(Constants.ERROR_TYPE.msg54);
        }
        if (bl) {
            this.infos.add(Constants.ERROR_TYPE.msg53);
        }
        if (by2 != 0) {
            this.infos.add(Constants.ERROR_TYPE.msg51);
        }
    }

    public boolean isNakResponse() {
        return this.nakResponse;
    }

    public boolean isCorectResponse() {
        return this.corectResponse;
    }

    public void setCorectResponse(boolean bl) {
        this.corectResponse = bl;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setNakResponse(boolean bl) {
        this.nakResponse = bl;
    }

    public Vector<Constants.ERROR_TYPE> getErrors() {
        return this.errors;
    }

    public Vector<Constants.ERROR_TYPE> getInfos() {
        return this.infos;
    }

    public Vector<Constants.ERROR_TYPE> getWarnings() {
        return this.warnings;
    }

    public boolean isTimeout() {
        return this.timeout;
    }

    public void setTimeout(boolean bl) {
        this.timeout = bl;
    }
}

