/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.licensing;

import com.google.code.gsonrmi.Parameter;
import com.google.code.gsonrmi.serializer.ExceptionSerializer;
import com.google.code.gsonrmi.serializer.ParameterSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.ParseException;
import ro.atreides.utils.Utils;
import ro.deversoft.licensing.noarch.JsonLicenseVerifier;
import ro.deversoft.licensing.noarch.ResellerKey;
import ro.deversoft.utils.noarch.FileUtils;
import ro.deversoft.utils.noarch.Formatters;
import ro.deversoft.utils.noarch.Logger;
import ro.deversoft.utils.noarch.UtilsNoarch;

public class ResellerKeyPcImpl {
    public static ResellerKey getResellerKeyFromFile(String string, String object) {
        ResellerKey resellerKey = null;
        try {
            object = object != null ? new GsonBuilder().registerTypeAdapter((Type)((Object)Exception.class), new ExceptionSerializer()).registerTypeAdapter((Type)((Object)Parameter.class), new ParameterSerializer()).setDateFormat((String)object).create() : new Gson();
            string = FileUtils.readFileToString(string);
            resellerKey = ((Gson)object).fromJson(string, ResellerKey.class);
        }
        catch (JsonSyntaxException | IOException exception) {
            Logger.logException(ResellerKey.class.getName(), exception);
        }
        return resellerKey;
    }

    public static final void main(String[] object) {
        try {
            ResellerKey resellerKey = new ResellerKey();
            String string = Utils.getCmdlineValue("-root", object);
            resellerKey.setRootEntityLicensingNode(string);
            string = Utils.getCmdlineValue("-reseller", object);
            resellerKey.setResellerLicensingNode(string);
            string = Utils.getCmdlineValue("-email", object);
            resellerKey.setEmail(string);
            string = Utils.getCmdlineValue("-tel", object);
            resellerKey.setTel(string);
            string = Utils.getCmdlineValue("-partner", object);
            resellerKey.setNumePartener(string);
            string = Utils.getCmdlineValue("-www", object);
            resellerKey.setWww(string);
            resellerKey.setAltele("");
            resellerKey.setBackupContact("0723190126");
            string = Utils.getCmdlineValue("-resellercontractnumber", object);
            resellerKey.setResellerContractNumber(string);
            string = Utils.getCmdlineValue("-rootcontractnumber", object);
            resellerKey.setRootEntityContractNumber(string);
            string = Utils.getCmdlineValue("-resellercontractexpire", object);
            resellerKey.setResellerContractExpire(Formatters.CIEL_NIR_IMPORT_FORMAT.parse(string));
            string = Utils.getCmdlineValue("-rootcontractexpire", object);
            resellerKey.setRootEntityContractExpire(Formatters.CIEL_NIR_IMPORT_FORMAT.parse(string));
            object = Utils.getCmdlineValue("-onlineorderurl", object);
            resellerKey.setOnlineOrderUrl((String)object);
            object = new StringBuffer();
            string = JsonLicenseVerifier.generateStringForCheckSum(resellerKey, ResellerKey.class.getDeclaredFields(), (StringBuffer)object);
            System.out.println("FieldOrder : " + object);
            System.err.println("FieldOrder : " + object);
            object = UtilsNoarch.computeChecksum(string);
            resellerKey.setChecksum((String)object);
            object = new GsonBuilder().setPrettyPrinting().create();
            object = object.toJson(resellerKey);
            FileUtils.writeTextToFile("reseller_key.json", (String)object);
            return;
        }
        catch (IOException | ParseException exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }
}

