/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.licensing.noarch;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import eu.memshare.export.dao.MemshareFile;
import eu.memshare.export.dao.MemshareNode;
import eu.memshare.export.dao.NodeFilter;
import eu.memshare.export.main.MemshareClient;
import eu.memshare.filetransfer.FileTransferStatusListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.io.FileUtils;
import ro.deversoft.licensing.noarch.DecryptUtils;
import ro.deversoft.licensing.noarch.ExportConstants;
import ro.deversoft.licensing.noarch.ExportEnums;
import ro.deversoft.licensing.noarch.ExportLicenseInterface;
import ro.deversoft.licensing.noarch.ExportUtils;
import ro.deversoft.licensing.noarch.JsonLicenseVerifier;
import ro.deversoft.licensing.noarch.LicenseBean;
import ro.deversoft.licensing.noarch.LicenseBeanInterface;
import ro.deversoft.licensing.noarch.LicenseTypeBean;
import ro.deversoft.licensing.noarch.LicensingMemshareKey;
import ro.deversoft.licensing.noarch.LicensingPcNameInterface;
import ro.deversoft.licensing.noarch.ResellerKey;
import ro.deversoft.utils.noarch.UtilsNoarch;

public class ExportLicense {
    private MemshareClient a = MemshareClient.getInstance();
    private static ExportLicense b;
    public static final String TAG;
    public static final String FALSE_STRING = "false";
    private LicensingMemshareKey c;
    public static String licensingMemshareFileKey;

    private ExportLicense() {
        try {
            Object object = new Gson();
            Object object2 = ExportLicense.getDecriptedFileContent(licensingMemshareFileKey);
            this.c = ((Gson)object).fromJson((String)object2, LicensingMemshareKey.class);
            object = new StringBuffer();
            object2 = UtilsNoarch.sortFields(LicensingMemshareKey.class.getDeclaredFields(), LicensingMemshareKey.getOrder());
            object2 = JsonLicenseVerifier.generateStringForCheckSum(this.c, object2, (StringBuffer)object);
            System.out.println("FieldOrder : " + object);
            System.err.println("FieldOrder : " + object);
            object = UtilsNoarch.computeChecksum((String)object2);
            if (!this.c.getChecksum().equals(object)) {
                System.err.println("Fisier " + licensingMemshareFileKey + " corupt !! Programul se va inchide");
                UtilsNoarch.systemExit();
            }
            return;
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            JsonSyntaxException jsonSyntaxException2 = jsonSyntaxException;
            jsonSyntaxException.printStackTrace();
            return;
        }
    }

    public static ExportLicense getInstance() {
        if (b == null) {
            b = new ExportLicense();
        }
        return b;
    }

    public static final String getDecriptedFileContent(String object) {
        try {
            String string = "RqEPI8owa0";
            byte[] byArray = "wVaxU7TkYg".getBytes("UTF-8");
            object = new File((String)object);
            object = FileUtils.readFileToByteArray((File)object);
            object = DecryptUtils.decrypt1(string, byArray, (byte[])object);
            object = new String((byte[])object, "UTF-8");
            return object;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            NoSuchAlgorithmException noSuchAlgorithmException2 = noSuchAlgorithmException;
            noSuchAlgorithmException.printStackTrace();
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            InvalidKeySpecException invalidKeySpecException2 = invalidKeySpecException;
            invalidKeySpecException.printStackTrace();
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            NoSuchPaddingException noSuchPaddingException2 = noSuchPaddingException;
            noSuchPaddingException.printStackTrace();
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            InvalidParameterSpecException invalidParameterSpecException2 = invalidParameterSpecException;
            invalidParameterSpecException.printStackTrace();
        }
        catch (InvalidKeyException invalidKeyException) {
            InvalidKeyException invalidKeyException2 = invalidKeyException;
            invalidKeyException.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            InvalidAlgorithmParameterException invalidAlgorithmParameterException2 = invalidAlgorithmParameterException;
            invalidAlgorithmParameterException.printStackTrace();
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            IllegalBlockSizeException illegalBlockSizeException2 = illegalBlockSizeException;
            illegalBlockSizeException.printStackTrace();
        }
        catch (BadPaddingException badPaddingException) {
            BadPaddingException badPaddingException2 = badPaddingException;
            badPaddingException.printStackTrace();
        }
        return null;
    }

    public boolean login() {
        boolean bl = false;
        try {
            bl = this.a.loginAndConnect(this.c.getUrl(), this.c.getUser(), this.c.getPassword(), this.c.getAccount());
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return bl;
    }

    public Long createUpperTree(String object, String object2, ResellerKey serializable) {
        Serializable serializable2 = this.createNewNode(null, serializable.getRootEntityLicensingNode());
        if (serializable2 == null) {
            return null;
        }
        if ((serializable = this.createNewNode((Long)serializable2, serializable.getResellerLicensingNode())) == null) {
            return null;
        }
        serializable2 = new HashMap();
        serializable2.put("partner", new ArrayList());
        if (!this.addTags((Long)serializable, (Map<String, List<String>>)((Object)serializable2))) {
            System.err.println(TAG + " Tag :partner" + " was not added.");
        }
        if ((object = this.createNewNode((Long)serializable, (String)object)) == null) {
            return null;
        }
        serializable = new HashMap();
        serializable.put("client", new ArrayList());
        if (!this.addTags((Long)object, (Map<String, List<String>>)((Object)serializable))) {
            System.err.println(TAG + " Tag :client" + " was not added.");
        }
        if ((object2 = this.createNewNode((Long)object, (String)object2)) == null) {
            return null;
        }
        serializable = new HashMap();
        serializable.put("bd", new ArrayList());
        if (!this.addTags((Long)object2, (Map<String, List<String>>)((Object)serializable))) {
            System.err.println(TAG + " Tag :bd" + " was not added.");
        }
        if ((object = this.createNewNode((Long)object, "Cereri")) == null) {
            return null;
        }
        serializable = new HashMap();
        serializable.put("requests", new ArrayList());
        if (!this.addTags((Long)object, (Map<String, List<String>>)((Object)serializable))) {
            System.err.println(TAG + " Tag :requests" + " was not added.");
        }
        return object2;
    }

    public boolean addTags(Long l, Map<String, List<String>> map) {
        boolean bl = true;
        System.out.println(TAG + "Adding tags to node : parent_id : " + l + " ; tags : " + map);
        if (!this.a()) {
            return false;
        }
        Boolean bl2 = this.a.saveMemshareTags(l, map, true, true);
        if (bl2 == null || !bl2.booleanValue()) {
            bl = false;
            System.err.println(TAG + "Tags: '" + map + "' were not added to node with id:" + l);
        }
        return bl;
    }

    public boolean addFile(Long l, File file) {
        boolean bl = true;
        System.out.println(TAG + "Adding file to node with id : " + l);
        if (!this.a()) {
            return false;
        }
        Boolean bl2 = null;
        try {
            bl2 = this.a.saveMemshareFile(l, file, this.getFileTransferListener(), true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileNotFoundException fileNotFoundException2 = fileNotFoundException;
            fileNotFoundException.printStackTrace();
        }
        if (bl2 == null || !bl2.booleanValue()) {
            bl = false;
            System.err.println(TAG + "File: '" + file.getName() + "' was not added to node with id:" + l);
        }
        return bl;
    }

    public boolean addMicrosheets(Long l, Map<String, List<Map<String, String>>> map) {
        if (!this.a()) {
            System.err.println(TAG + "Adding microsheets for node with id: " + l + " failed.");
            return false;
        }
        Boolean bl = this.a.saveMemshareMicrosheet(l, map, true, true);
        if (bl == null || !bl.booleanValue()) {
            System.err.println(TAG + "Microsheets were not added to node with id:" + l);
            return false;
        }
        System.out.println(TAG + "Microsheet added to node with id= " + l + "\n" + map);
        return true;
    }

    private boolean a() {
        boolean bl = false;
        if (this.a == null || !this.a.connected()) {
            for (int i = 0; i < 10; ++i) {
                if (this.login()) {
                    bl = true;
                    break;
                }
                bl = false;
            }
        } else {
            bl = true;
        }
        if (!bl) {
            System.err.print(TAG + "Can't connect to Memshare!");
        }
        return bl;
    }

    public Long createNewNode(Long l, String string) {
        System.out.println(TAG + "Adding node : parent_id : " + l + " ; node_title : " + string);
        if (!this.a()) {
            System.err.println(TAG + "Node " + string + " was not added!");
            return null;
        }
        l = this.a.saveMemshareNode(l, string, true);
        return l;
    }

    public boolean findAndGetLicenseFile(String object, Long object2, File file) {
        Object object3;
        Object object4;
        Object object5 = object2;
        object2 = object;
        object = this;
        if (!((ExportLicense)object).a()) {
            object4 = null;
        } else {
            object3 = new NodeFilter();
            Object object6 = new HashMap<String, List<String>>();
            object6.put("Finished", new ArrayList());
            object6.put("license", new ArrayList());
            ((NodeFilter)object3).setExcludeTags((Map<String, List<String>>)object6);
            object6 = new HashMap();
            object6.put("hdd", new ArrayList());
            object = ((ExportLicense)object).a.getChildrenNodes((Long)object5, (NodeFilter)object3);
            if (object == null || object.isEmpty()) {
                System.err.println(TAG + "No file received for the node with id :" + object5);
                object4 = null;
            } else {
                object5 = null;
                object = object.iterator();
                while (object.hasNext()) {
                    object3 = (MemshareNode)object.next();
                    object6 = ((MemshareNode)object3).getTitle();
                    if (!((String)object6).contains((CharSequence)object2)) continue;
                    object5 = ((MemshareNode)object3).getId();
                    break;
                }
                if (object5 == null) {
                    System.err.println(TAG + "Could not find a license file!");
                    object4 = null;
                } else {
                    object4 = object = object5;
                }
            }
        }
        if (object4 == null) {
            return false;
        }
        if (!this.a()) {
            return false;
        }
        object = this.a.getMemshareFiles((Long)object);
        object2 = null;
        object = object.iterator();
        while (object.hasNext()) {
            object5 = (MemshareFile)object.next();
            object3 = ((MemshareFile)object5).getName();
            if (!((String)object3).contains("original")) continue;
            object2 = object5;
        }
        if (object2 == null) {
            return false;
        }
        if (!this.a()) {
            return false;
        }
        try {
            this.a.downloadMemshareFile((MemshareFile)object2, file, this.getFileTransferListener());
            return true;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            return false;
        }
    }

    public FileTransferStatusListener getFileTransferListener() {
        FileTransferStatusListener fileTransferStatusListener = new FileTransferStatusListener(this){

            @Override
            public final void bytesReceived(long l, long l2) {
                System.out.println("Uploaded : " + l / l2 * 100L + "%");
            }

            @Override
            public final void interrupted() {
                System.out.println("Transfer intrerupt");
            }

            @Override
            public final void completed() {
                System.out.println("Transfer complet");
            }

            @Override
            public final void error(String string) {
                System.out.println("Eroare la transmisie : " + string);
            }
        };
        return fileTransferStatusListener;
    }

    private static String a(String object) {
        String string = "";
        try {
            object = new URL((String)object);
            object = new Scanner(((URL)object).openStream());
            String string2 = "\n";
            try {
                while (((Scanner)object).hasNextLine()) {
                    string = string + ((Scanner)object).nextLine() + string2;
                }
            }
            finally {
                ((Scanner)object).close();
            }
        }
        catch (IOException iOException) {
            System.err.println(TAG + iOException.getMessage());
        }
        return string;
    }

    public static List<String> parseFileFromUrlAsStringList(String iterator) {
        iterator = ExportLicense.parseFileFromUrl((String)((Object)iterator));
        ArrayList<String> arrayList = new ArrayList<String>();
        iterator = ((Vector)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            LicenseTypeBean licenseTypeBean = (LicenseTypeBean)iterator.next();
            arrayList.add(licenseTypeBean.getName());
        }
        return arrayList;
    }

    public static Vector<LicenseTypeBean> parseFileFromUrl(String object) {
        if (object == null) {
            return new Vector<LicenseTypeBean>();
        }
        String[] stringArray = ExportLicense.a((String)object);
        if (!ExportUtils.correctString((String)stringArray)) {
            System.err.println(TAG + "Empty file returned from from : " + (String)object);
            return new Vector<LicenseTypeBean>();
        }
        if ((stringArray = stringArray.split("\\r?\\n")).length <= 0) {
            System.err.println(TAG + "Error parsing file from : " + (String)object);
            return new Vector<LicenseTypeBean>();
        }
        object = new Vector();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null || string.trim().length() <= 0 || (string = string.trim()).startsWith("#")) continue;
            LicenseTypeBean licenseTypeBean = new LicenseTypeBean();
            if (string.startsWith("--")) {
                licenseTypeBean.setCategoryTitle(true);
                string = string.substring(2, string.length());
            }
            int n = string.indexOf("=");
            String string2 = string;
            String string3 = "";
            if (n > 0) {
                string3 = string.substring(n);
                string2 = string.substring(0, n);
            }
            licenseTypeBean.setName(string2);
            licenseTypeBean.setComments(string3);
            ((Vector)object).add(licenseTypeBean);
        }
        return object;
    }

    public void requestNewLicense(LicenseBean object, ExportLicenseInterface exportLicenseInterface, ResellerKey iterator) {
        ArrayList<String> arrayList;
        long l;
        exportLicenseInterface.checkGlobalConfigs();
        Object object2 = iterator;
        LicenseBean licenseBean = object;
        ExportLicense exportLicense = ExportLicense.getInstance();
        if (!exportLicense.login()) {
            System.err.println("Nu ma pot conecta la Memshare! Verificati conexiunea la Internet sau contactati adminul. ");
            l = -1L;
        } else {
            object2 = exportLicense.createUpperTree(licenseBean.getClientName(), licenseBean.getBdID(), (ResellerKey)object2);
            if (object2 == null || (Long)object2 == -1L) {
                System.err.println(TAG + "Something went wrong and the upper tree was not created in Memshare!");
                l = -1L;
            } else {
                HashMap<String, List<String>> hashMap = new HashMap<String, List<Map<String, String>>>();
                arrayList = new ArrayList<Map<String, String>>();
                arrayList.add((String)((Object)licenseBean.getCommonAttr()));
                hashMap.put(ExportEnums.LicenseMicrosheet.Licenta_Attr_Comune.name(), arrayList);
                exportLicense.addMicrosheets((Long)object2, hashMap);
                hashMap = ExportUtils.DATE_AND_TIME_FORMAT.format(new Date());
                hashMap = String.format("%s - %s", licenseBean.getPcName(), hashMap);
                object2 = exportLicense.createNewNode((Long)object2, (String)((Object)hashMap));
                if (object2 == null || (Long)object2 == -1L) {
                    System.err.println(TAG + "Something went wrong and the license node was not added in Memshare!");
                    l = -1L;
                } else {
                    boolean bl;
                    hashMap = new HashMap<String, List<String>>();
                    hashMap.put("hdd", new ArrayList());
                    arrayList = new ArrayList<String>();
                    arrayList.add("new");
                    hashMap.put("license", arrayList);
                    boolean bl2 = exportLicense.addTags((Long)object2, hashMap);
                    if (!bl2) {
                        System.err.println(TAG + "Something went wrong while sending the tags!");
                    }
                    if (!(bl = exportLicense.addMicrosheets((Long)object2, licenseBean.getAttributes()))) {
                        System.err.println(TAG + "Something went wrong while sending the microsheets!");
                    }
                    l = (Long)object2;
                }
            }
        }
        long l2 = l;
        exportLicenseInterface.registerLicenseRequest(RequestType.newLicense, l2);
        if (l2 > 0L) {
            exportLicenseInterface.showOkDialog("Cerere inregistrata cu succes (id= " + l2 + ") Notati numarul cererii !", "SUCCES");
            object = ((LicenseBean)object).getAttributes();
            object = object.get(ExportEnums.LicenseMicrosheet.Licenta_App.name());
            object = object.get(0);
            object2 = object.get(ExportEnums.Licenta_App.tip_aplicatie.name());
            object = (String)object.get(ExportEnums.Licenta_App.hdd_id.name());
            iterator = ((ResellerKey)((Object)iterator)).getOnlineOrderUrl();
            iterator = UtilsNoarch.splitString((String)((Object)iterator), ',');
            iterator = ((Vector)((Object)iterator)).iterator();
            while (iterator.hasNext()) {
                Object object3 = (String)iterator.next();
                if (((Vector)(object3 = UtilsNoarch.splitStringKeepStructure((String)object3, '=', '\u0002'))).size() <= 1) continue;
                arrayList = (String)((Vector)object3).get(0);
                String string = (String)((Vector)object3).get(1);
                Object object4 = "";
                if (((Vector)object3).size() > 2 && !((String)(object3 = (String)((Vector)object3).get(2))).equalsIgnoreCase("\u0002")) {
                    object4 = object3;
                }
                if (!((String)((Object)arrayList)).equalsIgnoreCase("*") && !((String)((Object)arrayList)).equalsIgnoreCase((String)object2) || !ExportUtils.correctString(string)) continue;
                try {
                    string = string.replace("%%rid%%", URLEncoder.encode(l2 + "---" + (String)object, "UTF-8"));
                    string = string.replace("%%pid%%", (CharSequence)object4);
                    exportLicenseInterface.openOnlineShopUrl(string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    object3 = unsupportedEncodingException;
                    unsupportedEncodingException.printStackTrace();
                }
            }
            System.out.println("TipApp = " + (String)object2);
        }
    }

    public static LicenseBean composeNewLicenseBean(LicenseBeanInterface licenseBeanInterface, LicensingPcNameInterface object) {
        HashMap<String, String> hashMap;
        LicenseBean licenseBean = new LicenseBean();
        licenseBean.setPcName(object.getPCName(licenseBeanInterface.getHDDId()));
        licenseBean.setBdID(licenseBeanInterface.getDBId());
        licenseBean.setClientName(licenseBeanInterface.getClientName());
        Cloneable cloneable = new HashMap<String, String>();
        cloneable.put(ExportEnums.Licenta_Attr_Comune.brand.name(), licenseBeanInterface.getBrand());
        cloneable.put(ExportEnums.Licenta_Attr_Comune.societate.name(), licenseBeanInterface.getSocietate());
        cloneable.put(ExportEnums.Licenta_Attr_Comune.cui.name(), licenseBeanInterface.getCui());
        licenseBean.setCommonAttr((Map<String, String>)((Object)cloneable));
        cloneable = new HashMap<String, String>();
        cloneable.put(ExportEnums.Licenta_App.hdd_id.name(), licenseBeanInterface.getHDDId());
        cloneable.put((String)ExportEnums.Licenta_App.sequence.name(), (String)("" + (licenseBeanInterface.getCurrentSequence() + 1)));
        cloneable.put((String)ExportEnums.Licenta_App.data_expirare.name(), (String)ExportConstants.DATE_FORMAT.format(licenseBeanInterface.getExpireDate()));
        Object object3 = licenseBeanInterface.getMajorVersion();
        cloneable.put((String)ExportEnums.Licenta_App.main_version.name(), (String)object3);
        cloneable.put((String)ExportEnums.Licenta_App.name.name(), (String)object.getPCName(licenseBeanInterface.getHDDId()));
        cloneable.put((String)ExportEnums.Licenta_App.tip_aplicatie.name(), (String)licenseBeanInterface.getChosenApp());
        object = new HashMap<String, List<Map<String, String>>>();
        object3 = new ArrayList<HashMap<String, String>>();
        ((ArrayList)object3).add(cloneable);
        object.put(ExportEnums.LicenseMicrosheet.Licenta_App.name(), (List<Map<String, String>>)object3);
        cloneable = new ArrayList();
        for (String object22 : licenseBeanInterface.getChosenModules()) {
            hashMap = new HashMap<String, String>();
            hashMap.put(ExportEnums.Licenta_Module.nume.name(), object22);
            hashMap.put(ExportEnums.Licenta_Module.exclude.name(), FALSE_STRING);
            ((ArrayList)cloneable).add(hashMap);
        }
        object.put(ExportEnums.LicenseMicrosheet.Licenta_Module.name(), (List<Map<String, String>>)((Object)cloneable));
        object3 = new ArrayList();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put(ExportEnums.DateContact.tip.name(), ExportEnums.DateContact_Tip.Email.name());
        hashMap2.put(ExportEnums.DateContact.valoare.name(), licenseBeanInterface.getEmailAddress());
        ((ArrayList)object3).add(hashMap2);
        hashMap = new HashMap<String, String>();
        hashMap.put(ExportEnums.DateContact.tip.name(), ExportEnums.DateContact_Tip.Tel.name());
        hashMap.put(ExportEnums.DateContact.valoare.name(), licenseBeanInterface.getMobileNumber());
        ((ArrayList)object3).add(hashMap);
        object.put(ExportEnums.LicenseMicrosheet.DateContact.name(), (List<Map<String, String>>)object3);
        licenseBean.setAttributes(object);
        return licenseBean;
    }

    static {
        TAG = ExportLicense.class.getSimpleName() + " : ";
        licensingMemshareFileKey = "licensing_memshare_key.bin";
    }

    public static enum RequestType {
        migrate,
        extend,
        newLicense;

    }
}

