/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.licensing.noarch;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import ro.deversoft.licensing.noarch.LicenseBean;

public class ExportUtils {
    private static final String a = ExportUtils.class.getSimpleName();
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat DATE_AND_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static final DecimalFormat NUMBER_0DECIMALS = new DecimalFormat("###0");
    public static final DecimalFormat NUMBER_0DECIMALS_THOUSANDS = new DecimalFormat("#,##0");

    public static Date getDateFromString(String object, String string) {
        object = new SimpleDateFormat((String)object);
        Date date = null;
        try {
            date = ((DateFormat)object).parse(string);
        }
        catch (ParseException parseException) {
            object = parseException;
            parseException.printStackTrace();
        }
        return date;
    }

    public static String getLicense(String object) {
        try {
            if (object == null || ((String)object).length() <= 0) {
                return null;
            }
            Object object2 = MessageDigest.getInstance("SHA1");
            object = (String)object + "jkdf8hgj2dfhg7k345d1hfu53j4h5jhg4asb5ndh";
            ((MessageDigest)object2).update(((String)object).getBytes());
            object = ((MessageDigest)object2).digest();
            object2 = new StringBuffer(((Object)object).length);
            for (int i = 0; i < ((Object)object).length; ++i) {
                Object object3 = object[i];
                ((StringBuffer)object2).append(Integer.toHexString(0xFF & object3));
            }
            return ((StringBuffer)object2).toString();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            return null;
        }
    }

    public static Boolean verifyJSONChecksum(File object) {
        boolean bl = false;
        if ((object = ExportUtils.readFile((File)object)) == null || ((String)object).isEmpty()) {
            System.err.println(a + "File is empty or not readable");
            return false;
        }
        object = ExportUtils.getLicenseBeanFromJson((String)object);
        String string = ExportUtils.generateStringForCheckSum((LicenseBean)object);
        string = ExportUtils.getLicense(string);
        object = ((LicenseBean)object).getChecksum();
        if (string == null || string.isEmpty()) {
            System.err.println(a + "Generated checksum is null or empty!");
            return false;
        }
        if (object == null || ((String)object).isEmpty()) {
            System.err.println(a + "Checksum from bean is null or empty!");
            return false;
        }
        if (string.equals(object)) {
            bl = true;
        }
        return bl;
    }

    public static String generateStringForCheckSum(LicenseBean licenseBean) {
        StringBuilder stringBuilder = new StringBuilder();
        Field[] fieldArray = LicenseBean.class.getDeclaredFields();
        Field[] fieldArray2 = fieldArray;
        fieldArray2 = fieldArray;
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            Object object = fieldArray2[i];
            ((Field)object).setAccessible(true);
            Iterator iterator = null;
            try {
                iterator = ((Field)object).get(licenseBean);
            }
            catch (IllegalAccessException illegalAccessException) {
                object = illegalAccessException;
                illegalAccessException.printStackTrace();
            }
            if (iterator == null) continue;
            if (iterator instanceof String) {
                object = ((String)((Object)iterator)).trim();
                stringBuilder.append((String)object);
                continue;
            }
            if (iterator instanceof Integer) {
                object = (Integer)((Object)iterator);
                stringBuilder.append(object);
                continue;
            }
            if (!(iterator instanceof Map)) continue;
            object = (Map)((Object)iterator);
            for (Object object2 : object.keySet()) {
                Iterator iterator2;
                Object object3 = object.get(object2);
                if (object3 instanceof String) {
                    iterator2 = ((String)object3).trim();
                    stringBuilder.append((String)object2);
                    stringBuilder.append((String)((Object)iterator2));
                }
                if (!(object3 instanceof List) || (iterator2 = (List)object3).isEmpty()) continue;
                object2 = iterator2.iterator();
                while (object2.hasNext()) {
                    object3 = (Map)object2.next();
                    iterator2 = object3.keySet().iterator();
                    while (iterator2.hasNext()) {
                        String string = (String)iterator2.next();
                        String string2 = (String)object3.get(string);
                        if (string2 == null || string2.isEmpty()) continue;
                        stringBuilder.append(string);
                        stringBuilder.append(string2);
                    }
                }
            }
        }
        return stringBuilder.toString();
    }

    public static LicenseBean getLicenseBeanFromJson(String string) {
        LicenseBean licenseBean = null;
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            licenseBean = gson.fromJson(string, LicenseBean.class);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            JsonSyntaxException jsonSyntaxException2 = jsonSyntaxException;
            jsonSyntaxException.printStackTrace();
        }
        return licenseBean;
    }

    public static String readFile(File comparable) {
        Object object;
        new StringBuilder();
        Scanner scanner = null;
        try {
            scanner = new Scanner((File)comparable);
        }
        catch (FileNotFoundException fileNotFoundException) {
            object = fileNotFoundException;
            fileNotFoundException.printStackTrace();
        }
        if (scanner == null) {
            return null;
        }
        object = "\n";
        try {
            comparable = new StringBuilder((int)((File)comparable).length());
            while (scanner.hasNextLine()) {
                ((StringBuilder)comparable).append(scanner.nextLine()).append((String)object);
            }
        }
        finally {
            scanner.close();
        }
        return ((StringBuilder)comparable).toString();
    }

    public static File createNewFile(String object) {
        object = new File((String)object);
        ((File)object).getParentFile().mkdirs();
        try {
            ((File)object).createNewFile();
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
        }
        if (!((File)object).exists() || !((File)object).isFile()) {
            return null;
        }
        return object;
    }

    public static String getPropertyFromAttributes(LicenseBean object, String string, String string2) {
        Object object2 = null;
        if (object == null || ((LicenseBean)object).getAttributes() == null || ((LicenseBean)object).getAttributes().isEmpty()) {
            return null;
        }
        if ((object = ((LicenseBean)object).getAttributes()).isEmpty()) {
            return null;
        }
        if (ExportUtils.a((List)(object = (List)object.get(string)))) {
            return null;
        }
        if (ExportUtils.a((Map)(object = (Map)object.get(0)))) {
            return null;
        }
        if (ExportUtils.correctString((String)(object = (String)object.get(string2)))) {
            object2 = object;
        }
        return object2;
    }

    public static boolean setPropertyToAttributes(LicenseBean object, String string, String string2, String string3) {
        if (object == null || ((LicenseBean)object).getAttributes() == null || ((LicenseBean)object).getAttributes().isEmpty()) {
            return false;
        }
        if ((object = ((LicenseBean)object).getAttributes()).isEmpty()) {
            return false;
        }
        if (ExportUtils.a((List)(object = (List)object.get(string)))) {
            return false;
        }
        if (ExportUtils.a((Map)(object = (Map)object.get(0)))) {
            return false;
        }
        object.put(string2, string3);
        return true;
    }

    private static boolean a(List list) {
        return list == null || list.isEmpty();
    }

    private static boolean a(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean correctString(String string) {
        return string != null && !string.trim().equals("");
    }

    public static boolean correctInteger(String string) {
        if (ExportUtils.correctString(string)) {
            try {
                ExportUtils.parseInt(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return false;
    }

    public static Integer parseInt(String string) throws NumberFormatException {
        try {
            return NUMBER_0DECIMALS.parse(string).intValue();
        }
        catch (ParseException parseException) {
            throw new NumberFormatException(parseException.getMessage());
        }
    }

    public static boolean correctBoolean(String string) {
        if (ExportUtils.correctString(string)) {
            return string.equals("true") || string.equals("false") || string.equals("1") || string.equals("0");
        }
        return false;
    }
}

