/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.licensing.noarch;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import ro.deversoft.licensing.noarch.ExportUtils;
import ro.deversoft.licensing.noarch.LicenseBean;
import ro.deversoft.utils.noarch.UtilsNoarch;

public class JsonLicenseVerifier {
    private static final String a = JsonLicenseVerifier.class.getSimpleName() + " : ";

    public static Vector<String> verifyChecksum(File object) {
        Vector<String> vector = new Vector<String>();
        if (object == null) {
            object = a + "File is empty or not readable";
            vector.add((String)object);
            System.err.println((String)object);
        } else {
            object = ExportUtils.readFile((File)object);
            if ((object = JsonLicenseVerifier.getLicenseBeanFromJson((String)object)) == null) {
                String string = a + "Invalid JSON file";
                System.err.println(string);
                vector.add(string);
            } else {
                CharSequence charSequence = new StringBuffer();
                Object object2 = UtilsNoarch.sortFields(LicenseBean.class.getDeclaredFields(), LicenseBean.getOrder());
                object2 = JsonLicenseVerifier.generateStringForCheckSum(object, object2, (StringBuffer)charSequence);
                System.out.println("FieldOrder : " + charSequence);
                System.err.println("FieldOrder : " + charSequence);
                charSequence = UtilsNoarch.computeChecksum((String)object2);
                if (!ExportUtils.correctString((String)charSequence)) {
                    object = a + "Generated checksum is null or empty!";
                    System.err.println((String)object);
                    vector.add((String)object);
                } else if (!ExportUtils.correctString((String)(object = ((LicenseBean)object).getChecksum()))) {
                    object2 = a + "Checksum from file is null or empty!";
                    System.err.println((String)object2);
                    vector.add((String)object2);
                } else {
                    boolean bl = ((String)charSequence).equals(object);
                    if (!bl) {
                        object = a + "Checksum differs : from file = " + (String)object + " , calculated = " + (String)charSequence;
                        System.err.println((String)object);
                        vector.add((String)object);
                    }
                }
            }
        }
        return vector;
    }

    public static LicenseBean getLicenseBeanFromJson(String string) {
        LicenseBean licenseBean = null;
        try {
            Gson gson = new Gson();
            licenseBean = gson.fromJson(string, LicenseBean.class);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            JsonSyntaxException jsonSyntaxException2 = jsonSyntaxException;
            jsonSyntaxException.printStackTrace();
        }
        return licenseBean;
    }

    public static String generateStringForCheckSum(Object object, Field[] fieldArray, StringBuffer stringBuffer) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Field field : fieldArray) {
            Object object2;
            field.setAccessible(true);
            Object object32 = null;
            try {
                object32 = field.get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                object2 = illegalAccessException;
                illegalAccessException.printStackTrace();
            }
            if (object32 == null) continue;
            if (object32 instanceof String) {
                if (field.getName().equalsIgnoreCase("checksum")) continue;
                stringBuffer.append(field.getName() + ",");
                object2 = ((String)object32).trim();
                stringBuilder.append((String)object2);
                continue;
            }
            if (!(object32 instanceof Map)) continue;
            object2 = (Map)object32;
            stringBuffer.append(field.getName() + ",");
            for (Object object32 : object2.keySet()) {
                Iterator iterator;
                Object object4 = object2.get(object32);
                if (object4 instanceof String) {
                    iterator = ((String)object4).trim();
                    stringBuilder.append((String)object32);
                    stringBuilder.append((String)((Object)iterator));
                }
                if (!(object4 instanceof List) || (iterator = (List)object4).isEmpty()) continue;
                object32 = iterator.iterator();
                while (object32.hasNext()) {
                    object4 = (Map)object32.next();
                    iterator = object4.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        String string2 = (String)object4.get(string);
                        if (string2 == null || string2.isEmpty()) continue;
                        stringBuilder.append(string);
                        stringBuilder.append(string2);
                    }
                }
            }
        }
        return stringBuilder.toString();
    }
}

