/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.utils.noarch;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.deversoft.utils.noarch.Logger;

public class FileUtils {
    public static final String TEMP_DIR = "tmp";
    private static final Pattern a = Pattern.compile("(([^0-9]*))");

    public static boolean moveFileToDir(File file, File file2) {
        return FileUtils.moveFileToDir(file, file2, true);
    }

    public static boolean moveFileToDir(File file, File file2, boolean bl) {
        return file != null && FileUtils.moveFileToDir(file, file2, file.getName(), bl);
    }

    public static boolean moveFileToDir(File serializable, File file, String string, boolean bl) {
        if (serializable == null || file == null || !serializable.exists() || file.isFile()) {
            return false;
        }
        if (!file.exists() && !file.mkdirs()) {
            return false;
        }
        if ((file = new File(file, string)).equals(serializable)) {
            return true;
        }
        if (bl && file.exists()) {
            file.delete();
        }
        try {
            return serializable.renameTo(file);
        }
        catch (Exception exception) {
            serializable = exception;
            exception.printStackTrace();
            return false;
        }
    }

    public static int moveFilesToDir(File[] fileArray, File file, boolean bl) {
        int n = 0;
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (!FileUtils.moveFileToDir(file2, file, bl)) continue;
            ++n;
        }
        return n;
    }

    public static void copyFiles(String string, String string2) throws IOException {
        File[] fileArray = new File(string);
        fileArray = fileArray.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            Object object;
            if (fileArray[i].isDirectory()) {
                object = new File(string2 + File.separator + fileArray[i].getName());
                ((File)object).mkdirs();
                FileUtils.copyFiles(string + File.separator + fileArray[i].getName(), string2 + File.separator + fileArray[i].getName());
                continue;
            }
            object = new FileInputStream(fileArray[i]);
            FileOutputStream fileOutputStream = new FileOutputStream(string2 + File.separator + fileArray[i].getName());
            FileUtils.copyFiles((InputStream)object, fileOutputStream);
            fileOutputStream.close();
            ((InputStream)object).close();
        }
    }

    public static void copySingleFile(String object, String string) throws IOException {
        object = new File((String)object);
        FileInputStream fileInputStream = new FileInputStream((File)object);
        object = new FileOutputStream(string + File.separator + ((File)object).getName());
        FileUtils.copyFiles(fileInputStream, (OutputStream)object);
        ((FileOutputStream)object).close();
        ((InputStream)fileInputStream).close();
    }

    public static void copyFiles(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[65536];
        int n = 0;
        while (n == 0) {
            n = inputStream.read(byArray);
            if (n != -1) {
                outputStream.write(byArray, 0, n);
                outputStream.flush();
            }
            n = n == -1 ? 1 : 0;
        }
    }

    public static File[] listFiles(String string, String object, String string2) {
        object = new FilenameFilter((String)object, string2){
            private /* synthetic */ String a;
            private /* synthetic */ String b;
            {
                this.a = string;
                this.b = string2;
            }

            @Override
            public final boolean accept(File file, String string) {
                return string.startsWith(this.a) && string.endsWith(this.b);
            }
        };
        return new File(string).listFiles((FilenameFilter)object);
    }

    public static String readFileToString(String string) throws IOException {
        return FileUtils.readFileToString(string, "\n", Charset.defaultCharset());
    }

    public static String readFileToString(String string, String object) throws IOException {
        if (object == null) {
            return FileUtils.readFileToString(string, "\n", Charset.defaultCharset());
        }
        object = Charset.forName((String)object);
        return FileUtils.readFileToString(string, "\n", (Charset)object);
    }

    public static String readFileToString(String object, String string, Charset object2) throws IOException {
        object = new FileInputStream((String)object);
        object = new LineNumberReader(new InputStreamReader((InputStream)object, (Charset)object2));
        object2 = ((LineNumberReader)object).readLine();
        String string2 = "";
        while (object2 != null) {
            try {
                string2 = string2 + (String)object2 + string;
            }
            catch (Exception exception) {
                try {
                    Logger.logException("FileUtils", exception);
                }
                catch (Throwable throwable) {
                    ((LineNumberReader)object).readLine();
                    throw throwable;
                }
                object2 = ((LineNumberReader)object).readLine();
                continue;
            }
            object2 = ((LineNumberReader)object).readLine();
        }
        ((BufferedReader)object).close();
        return string2;
    }

    public static String getCurrentDir() {
        return System.getProperty("user.dir");
    }

    public static File getCurrentDirAsFile() {
        String string = System.getProperty("user.dir");
        return new File(string);
    }

    public static String buildCurrentDataDir(String object) {
        object = new File(FileUtils.getCurrentDir() + File.separator + "data" + File.separator + (String)object);
        ((File)object).mkdirs();
        return ((File)object).getAbsolutePath();
    }

    public static void writeTextToFile(String object, String string) throws IOException {
        object = new FileWriter((String)object);
        ((Writer)object).write(string);
        ((OutputStreamWriter)object).flush();
        ((OutputStreamWriter)object).close();
    }

    public static void writeTextToFile(String object, String string, String string2) throws IOException {
        object = new FileOutputStream((String)object);
        ((FileOutputStream)object).write(string.getBytes(string2));
        ((OutputStream)object).flush();
        ((FileOutputStream)object).close();
    }

    public static boolean appendTextToFileWithLocking(String object, String string) throws IOException {
        object = new FileOutputStream((String)object, true);
        FileLock fileLock = null;
        long l = 300000L;
        while (fileLock == null && l > 0L) {
            fileLock = ((FileOutputStream)object).getChannel().tryLock();
            if (fileLock != null) continue;
            try {
                Thread.sleep(100L);
                l -= 100L;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (fileLock == null) {
            return false;
        }
        ((FileOutputStream)object).write(string.getBytes());
        ((OutputStream)object).flush();
        fileLock.release();
        ((FileOutputStream)object).close();
        return true;
    }

    public static String getTempDir() {
        String string = FileUtils.getCurrentDir() + File.separator + TEMP_DIR;
        return string;
    }

    public static final boolean buildTempDir() {
        File file = new File(FileUtils.getTempDir());
        return file.mkdirs();
    }

    public static final boolean buildDir(String object, String string) {
        object = new File((String)object + File.separator + string);
        return ((File)object).mkdirs();
    }

    public static final boolean buildDir(String string) {
        return FileUtils.buildDir(FileUtils.getCurrentDir(), string);
    }

    public static void removeFileRecurse(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                FileUtils.removeFileRecurse(fileArray[i]);
            }
        }
        file.delete();
    }

    public static long getFreeSpace(File object) {
        String string = System.getProperty("os.name");
        try {
            if (string.indexOf("Windows") != -1) {
                object = Runtime.getRuntime().exec("cmd /c dir /-c " + ((File)object).getAbsolutePath());
                object = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()));
                while ((string = ((BufferedReader)object).readLine()) != null && !string.endsWith("libres") && !string.endsWith("free")) {
                }
                if (string == null) {
                    return -1L;
                }
                string = string.substring(string.lastIndexOf(")") + 1);
                object = a.matcher(string);
                string = ((Matcher)object).replaceAll("");
                return Long.parseLong(string);
            }
            if (string.equals("Linux")) {
                return FileUtils.a((File)object);
            }
            System.err.println("Unknown os=" + string);
            return FileUtils.a((File)object);
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace(System.err);
            return -1L;
        }
    }

    private static long a(File file) throws IOException {
        Object object;
        Object object2 = Runtime.getRuntime().exec("df");
        object2 = new BufferedReader(new InputStreamReader(((Process)object2).getInputStream()));
        Vector<String> vector = new Vector<String>();
        while ((object = ((BufferedReader)object2).readLine()) != null) {
            if (((String)object).charAt(0) != '/') continue;
            vector.add((String)object);
        }
        for (int i = vector.size() - 1; i >= 0; --i) {
            object = (String)vector.elementAt(i);
            object = new StringTokenizer((String)object);
            ((StringTokenizer)object).nextToken();
            ((StringTokenizer)object).nextToken();
            ((StringTokenizer)object).nextToken();
            String string = ((StringTokenizer)object).nextToken();
            ((StringTokenizer)object).nextToken();
            object = ((StringTokenizer)object).nextToken();
            if (!file.getAbsolutePath().startsWith((String)object)) continue;
            long l = Long.parseLong(string);
            return l;
        }
        return 0L;
    }

    public static Vector getUnixPartitions() throws IOException {
        Object object;
        Object object2 = Runtime.getRuntime().exec("df");
        object2 = new BufferedReader(new InputStreamReader(((Process)object2).getInputStream()));
        Vector<Object> vector = new Vector<Object>();
        while ((object = ((BufferedReader)object2).readLine()) != null) {
            if (((String)object).charAt(0) != '/') continue;
            object = new StringTokenizer((String)object);
            ((StringTokenizer)object).nextToken();
            ((StringTokenizer)object).nextToken();
            ((StringTokenizer)object).nextToken();
            ((StringTokenizer)object).nextToken();
            ((StringTokenizer)object).nextToken();
            object = ((StringTokenizer)object).nextToken();
            vector.add(object);
        }
        return vector;
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] getBytesFromFile(String var0) {
        var1_3 = null;
        try {
            var1_3 = new FileInputStream((String)var0);
            var0 = new byte[0x800000];
            var2_6 = var1_3.read((byte[])var0);
            var3_7 = new byte[var2_6];
            System.arraycopy(var0, 0, var3_7, 0, var2_6);
            var0 = var3_7;
            ** try [egrp 1[TRYBLOCK] [0 : 36->43)] { 
        }
        catch (IOException var0_1) {
            Logger.logException("FileUtils", (Exception)var0_1);
            return null;
        }
        finally {
            if (var1_3 != null) {
                try {
                    var1_3.close();
                }
                catch (IOException var3_8) {
                    Logger.logException("FileUtils", (Exception)var3_8);
                }
            }
        }
lbl-1000:
        // 1 sources

        {
            var1_3.close();
        }
lbl12:
        // 1 sources

        catch (IOException var1_4) {
            Logger.logException("FileUtils", (Exception)var1_4);
        }
        return var0;
    }

    /*
     * Loose catch block
     */
    public static Object readObjectFrom(String string, String string2) {
        Object object;
        block12: {
            object = null;
            ObjectInput objectInput = null;
            objectInput = new ObjectInputStream(new FileInputStream(string));
            object = objectInput.readObject();
            try {
                objectInput.close();
            }
            catch (Exception exception) {}
            break block12;
            catch (Exception exception) {
                try {
                    Logger.logException(string2, exception);
                }
                catch (Throwable throwable) {
                    try {
                        if (objectInput != null) {
                            objectInput.close();
                        }
                    }
                    catch (Exception exception2) {}
                    throw throwable;
                }
                try {
                    if (objectInput != null) {
                        objectInput.close();
                    }
                }
                catch (Exception exception3) {}
            }
        }
        return object;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeObjectTo(Object object, String string, String string2) {
        ObjectOutput objectOutput = null;
        objectOutput = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
        objectOutput.writeObject(object);
        try {
            objectOutput.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (Exception exception) {
            try {
                Logger.logException(string2, exception);
                if (objectOutput == null) return;
            }
            catch (Throwable throwable) {
                if (objectOutput == null) throw throwable;
                try {
                    objectOutput.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                objectOutput.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    public static boolean deleteFile(String object) {
        object = new File((String)object);
        boolean bl = ((File)object).delete();
        return bl;
    }

    public static Properties getPropertiesFromClasspath(String string) throws IOException {
        Properties properties = new Properties();
        InputStream inputStream = FileUtils.class.getResourceAsStream(string);
        if (inputStream != null) {
            properties.load(inputStream);
            return properties;
        }
        throw new FileNotFoundException("Property file " + string + " not found in the classpath");
    }

    public static Properties getPropertiesFromFile(String object) throws IOException {
        new Properties();
        Properties properties = new Properties();
        object = new File(FileUtils.getCurrentDir() + File.separator + "conf" + File.separator + (String)object);
        if (!((File)object).exists()) {
            FileUtils.writeTextToFile(((File)object).getAbsolutePath(), "\n");
        }
        object = new FileInputStream((File)object);
        properties.load((InputStream)object);
        return properties;
    }

    public static String readFileToStringWindows(String string) throws IOException {
        return FileUtils.readFileToString(string, "\r\n", Charset.defaultCharset());
    }

    public static Vector<String> getItemsInFolder(String fileArray) {
        Vector<String> vector = new Vector<String>();
        fileArray = new File((String)fileArray);
        File[] fileArray2 = fileArray.listFiles();
        fileArray = fileArray2;
        fileArray = fileArray2;
        int n = fileArray2.length;
        for (int i = 0; i < n; ++i) {
            File file = fileArray[i];
            vector.add(file.getName());
        }
        Collections.sort(vector);
        return vector;
    }

    static {
        Pattern.compile("(\\s*(\\S+)\\s*)");
    }
}

