/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.utils.noarch;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.deversoft.utils.noarch.Formatters;
import ro.deversoft.utils.noarch.Logger;
import ro.deversoft.utils.noarch.QRCodeTextException;

public class UtilsNoarch {
    public static boolean numbersUseThousandsSeparator = false;

    public static String getQRCodeTextContentForTable(String string, String string2, String string3) {
        String string4 = string + string2 + string3;
        string4 = UtilsNoarch.computeChecksum(string4);
        string = string + "|" + string2 + "|" + string3 + "|" + string4 + "|   soft by www.deversoft.ro   ";
        return string;
    }

    public static Vector<String> readQRCodeContentForTable(String object, String string) throws QRCodeTextException {
        Vector vector = UtilsNoarch.splitString((String)object, '|');
        if (vector.size() < 4) {
            throw new QRCodeTextException("Invalid format (message = " + (String)object + " , tokens = " + vector.size() + ")");
        }
        object = (String)vector.get(0);
        if (!((String)object).equals(string)) {
            throw new QRCodeTextException("Invalid APP (expected= " + string + " , found = " + (String)object + ")");
        }
        string = (String)vector.get(1);
        String string2 = (String)vector.get(2);
        vector = (String)vector.get(3);
        String string3 = (String)object + string + string2;
        if (!((String)((Object)vector)).equals(string3 = UtilsNoarch.computeChecksum(string3))) {
            throw new QRCodeTextException("Incorrect checksum (declared=" + vector + " , calculated = " + string3 + ")");
        }
        vector = new Vector();
        vector.add(object);
        vector.add(string);
        object = UtilsNoarch.splitString(string2, ';');
        if (((Vector)object).size() < 2) {
            throw new QRCodeTextException("Incorrect table def : " + string2);
        }
        vector.add(((Vector)object).get(0));
        vector.add(((Vector)object).get(1));
        return vector;
    }

    public static final void systemExit() {
        System.exit(0);
    }

    public static Vector splitString(String object, char c2) {
        object = new StringTokenizer((String)object, "" + c2);
        Vector<String> vector = new Vector<String>();
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string = ((StringTokenizer)object).nextToken();
            vector.add(string);
        }
        return vector;
    }

    public static Vector splitStringKeepStructure(String object, char c2, char c3) {
        object = new StringTokenizer((String)object, "" + c2, true);
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string = ((StringTokenizer)object).nextToken();
            if (string.equalsIgnoreCase("" + c2)) {
                if (bl) {
                    vector.add("" + c3);
                }
                bl = true;
                continue;
            }
            bl = false;
            vector.add(string);
        }
        return vector;
    }

    public static String joinString(String string, List<String> object) {
        String string2 = "";
        object = object.iterator();
        while (object.hasNext()) {
            String string3 = (String)object.next();
            string2 = string2 + string3 + string;
        }
        if (string2.length() > 0) {
            string2 = string2.substring(0, string2.length() - string.length());
        }
        return string2;
    }

    public static String joinString(String string, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            arrayList.add(string2);
        }
        return UtilsNoarch.joinString(string, arrayList);
    }

    public static String computeChecksum(String object) {
        try {
            if (object == null || ((String)object).length() <= 0) {
                return null;
            }
            Object object2 = MessageDigest.getInstance("SHA1");
            object = (String)object + "jkdf8hgj2dfhg7k345d1hfu53j4h5jhg4asb5ndh";
            ((MessageDigest)object2).update(((String)object).getBytes());
            object = ((MessageDigest)object2).digest();
            object2 = new StringBuffer(((Object)object).length);
            for (int i = 0; i < ((Object)object).length; ++i) {
                Object object3 = object[i];
                ((StringBuffer)object2).append(Integer.toHexString(0xFF & object3));
            }
            return ((StringBuffer)object2).toString();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            return null;
        }
    }

    public static void processCsvFile(String object, Map<Integer, String> map, Vector<Map<String, String>> vector, char c2, char c3) throws IOException {
        object = new LineNumberReader(new FileReader((String)object));
        boolean bl = true;
        Object object2 = ((LineNumberReader)object).readLine();
        while (object2 != null) {
            object2 = UtilsNoarch.splitStringKeepStructure((String)object2, c2, c3);
            int n = 0;
            Map<String, String> map2 = Collections.synchronizedMap(new LinkedHashMap());
            object2 = ((Vector)object2).iterator();
            while (object2.hasNext()) {
                String string = (String)object2.next();
                if (bl) {
                    map.put(n, string);
                } else {
                    String string2 = map.get(n);
                    map2.put(string2, string);
                }
                ++n;
            }
            if (!bl) {
                vector.add(map2);
            }
            bl = false;
            object2 = ((LineNumberReader)object).readLine();
        }
    }

    public static String getDoubleWithDecimalPoint(String string, int n) {
        String string2 = string;
        if (string.length() < n) {
            string2 = UtilsNoarch.getStringMaxSize(n, string, Character.valueOf('0'), true);
        }
        if ((string = string2.substring(0, string2.length() - n)).equals("")) {
            string = "0";
        }
        String string3 = string2.substring(string2.length() - n, string2.length());
        string = string + "." + string3;
        return string;
    }

    public static String getStringMaxSize(int n, String string, Character c2, boolean bl) {
        if (string == null) {
            string = "";
        }
        if (string.length() > n) {
            return string.substring(0, n);
        }
        if (string.length() < n) {
            String string2 = string;
            if (c2 != null) {
                for (int i = string.length(); i < n; ++i) {
                    string2 = bl ? c2.charValue() + string2 : string2 + c2.charValue();
                }
            }
            return string2;
        }
        return string;
    }

    public static InputStream executeGrabOutput(String string, String ... stringArray) throws Throwable {
        Object object;
        String string2 = "";
        Object object2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string3 = object2[i];
            string2 = string2 + string3 + " ";
        }
        object2 = new ProcessBuilder(new String[0]);
        if (string != null) {
            object = new File(string);
            String string4 = "Execut \"" + string2 + "\" din directorul \"" + ((File)object).getAbsolutePath() + "\"";
            System.out.println(string4);
            ((ProcessBuilder)object2).directory((File)object);
        } else {
            object = "Execut \"" + string2 + "\" din directorul default";
            System.out.println((String)object);
        }
        ((ProcessBuilder)object2).command(stringArray);
        ((ProcessBuilder)object2).redirectErrorStream(true);
        object = ((ProcessBuilder)object2).start();
        return ((Process)object).getInputStream();
    }

    public static OS_TYPE detectOS() {
        OS_TYPE oS_TYPE = null;
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("linux")) {
            oS_TYPE = OS_TYPE.LINUX;
        } else if (string.startsWith("windows")) {
            oS_TYPE = OS_TYPE.WINDOWS;
        } else if (string.startsWith("mac")) {
            oS_TYPE = OS_TYPE.MAC;
        }
        return oS_TYPE;
    }

    /*
     * Loose catch block
     */
    public static Properties loadPropertiesFromClasspath(String object, Class serializable) {
        InputStream inputStream;
        block11: {
            Properties properties = new Properties();
            inputStream = null;
            inputStream = serializable.getResourceAsStream((String)object);
            properties.load(inputStream);
            object = properties;
            if (inputStream == null) break block11;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                serializable = iOException;
                iOException.printStackTrace();
            }
        }
        return object;
        catch (Exception exception) {
            block12: {
                try {
                    object = exception;
                    exception.printStackTrace();
                    if (inputStream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            serializable = iOException;
                            iOException.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    object = iOException;
                    iOException.printStackTrace();
                }
            }
            return null;
        }
    }

    public static int parseInt(String object) throws NumberFormatException {
        if (numbersUseThousandsSeparator) {
            try {
                object = Formatters.NUMBER_0DECIMALS_THOUSANDS.parse((String)object);
                return ((Number)object).intValue();
            }
            catch (ParseException parseException) {
                throw new NumberFormatException(parseException.getMessage());
            }
        }
        try {
            return Formatters.NUMBER_0DECIMALS.parse((String)object).intValue();
        }
        catch (ParseException parseException) {
            throw new NumberFormatException(parseException.getMessage());
        }
    }

    public static Field[] sortFields(Field[] fieldArray, Map<String, Double> object) {
        Object object2 = new Vector<Field>();
        for (int i = 0; i < fieldArray.length; ++i) {
            ((Vector)object2).add(fieldArray[i]);
        }
        Collections.sort(object2, new Comparator<Field>(object){
            private /* synthetic */ Map a;
            {
                this.a = map;
            }

            @Override
            public final /* synthetic */ int compare(Object object, Object object2) {
                double d2;
                Field field = (Field)object2;
                object2 = (Field)object;
                object = this;
                double d3 = (Double)object.a.get(((Field)object2).getName());
                if (d3 < (d2 = ((Double)object.a.get(field.getName())).doubleValue())) {
                    return -1;
                }
                if (d2 < d3) {
                    return 1;
                }
                return 0;
            }
        });
        Field[] fieldArray2 = new Field[((Vector)object2).size()];
        int n = 0;
        object = ((Vector)object2).iterator();
        while (object.hasNext()) {
            object2 = (Field)object.next();
            fieldArray2[n++] = object2;
        }
        return fieldArray2;
    }

    public static boolean isValidEmailAddress(String object) {
        Object object2 = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
        object2 = Pattern.compile("^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$");
        object = ((Pattern)object2).matcher((CharSequence)object);
        return ((Matcher)object).matches();
    }

    public static String getSqlInSequenceForIdFields(Collection object) {
        try {
            Vector<Integer> vector = new Vector<Integer>();
            if (object != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    Object e2 = object.next();
                    Method[] methodArray = e2.getClass();
                    Method[] methodArray2 = methodArray.getMethods();
                    methodArray = methodArray2;
                    methodArray = methodArray2;
                    int n = methodArray2.length;
                    for (int i = 0; i < n; ++i) {
                        Method method = methodArray[i];
                        String string = method.getName();
                        if (!string.equals("getId")) continue;
                        int n2 = (Integer)method.invoke(e2, new Object[0]);
                        vector.add(n2);
                    }
                }
                return UtilsNoarch.getSqlInSequence(vector);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.logException(UtilsNoarch.class, (Exception)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.logException(UtilsNoarch.class, (Exception)invocationTargetException);
        }
        return "";
    }

    public static String getSqlInSequence(Vector vector) {
        return UtilsNoarch.getSqlInSequence(vector, false);
    }

    public static String getSqlInSequence(Vector vector, boolean bl) {
        return UtilsNoarch.getSqlInSequence(vector, bl, ',');
    }

    public static String getSqlInSequence(Vector vector, boolean bl, char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int i = 0; i < vector.size(); ++i) {
            Object e2 = vector.elementAt(i);
            stringBuffer.append(e2);
            if (i >= vector.size() - 1) continue;
            stringBuffer.append(c2);
            if (!bl) continue;
            stringBuffer.append(' ');
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static enum OS_TYPE {
        WINDOWS,
        LINUX,
        MAC;

    }

    public static enum QRCODES_APP_NAMES {
        deverFoodPdaScanTable;

    }
}

