/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.resources.ResourceManager;
import com.sun.javaws.JnlpxArgs;
import com.sun.jnlp.ApiDialog;
import com.sun.jnlp.CheckServicePermission;
import com.sun.jnlp.FileContentsImpl;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jnlp.ExtendedService;
import javax.jnlp.FileContents;

public final class ExtendedServiceImpl
implements ExtendedService {
    private static ExtendedServiceImpl _sharedInstance = null;
    private static int DEFAULT_FILESIZE = Integer.MAX_VALUE;

    private ExtendedServiceImpl() {
    }

    public static synchronized ExtendedServiceImpl getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = new ExtendedServiceImpl();
        }
        return _sharedInstance;
    }

    public FileContents openFile(File file) throws IOException {
        if (file == null) {
            return null;
        }
        final File file2 = new File(file.getPath());
        if (!(CheckServicePermission.hasFileAccessPermissions(file2.toString()) || JnlpxArgs.getFileReadWriteList().contains(file2.toString()) || this.askUser(file2.getPath()))) {
            return null;
        }
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return new FileContentsImpl(file2, DEFAULT_FILESIZE);
                }
                catch (IOException iOException) {
                    return iOException;
                }
            }
        });
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        return (FileContents)object;
    }

    synchronized boolean askUser(String string) {
        String string2;
        String string3;
        if (CheckServicePermission.hasFileAccessPermissions()) {
            return true;
        }
        ApiDialog apiDialog = new ApiDialog();
        String string4 = ResourceManager.getString((String)"api.extended.open.title");
        ApiDialog.DialogResult dialogResult = apiDialog.askUser(string4, string3 = ResourceManager.getString((String)"api.extended.open.message"), null, string2 = ResourceManager.getString((String)"api.extended.open.label"), string, false);
        return dialogResult == ApiDialog.DialogResult.OK || dialogResult == ApiDialog.DialogResult.ALWAYS;
    }

    public FileContents[] openFiles(File[] fileArray) throws IOException {
        int n;
        if (fileArray == null || fileArray.length <= 0) {
            return null;
        }
        final File[] fileArray2 = new File[fileArray.length];
        for (n = 0; n < fileArray.length; ++n) {
            fileArray2[n] = new File(fileArray[n].getPath());
        }
        n = 1;
        for (int i = 0; i < fileArray2.length; ++i) {
            if (CheckServicePermission.hasFileAccessPermissions(fileArray2[i].toString())) continue;
            n = 0;
            break;
        }
        String string = "";
        for (int i = 0; i < fileArray2.length; ++i) {
            string = string + fileArray2[i].getPath() + "\n";
        }
        if (n == 0 && !this.askUser(string)) {
            return null;
        }
        Object[] objectArray = AccessController.doPrivileged(new PrivilegedAction<Object[]>(){

            @Override
            public Object[] run() {
                Object[] objectArray = new FileContents[fileArray2.length];
                try {
                    for (int i = 0; i < fileArray2.length; ++i) {
                        objectArray[i] = new FileContentsImpl(fileArray2[i], DEFAULT_FILESIZE);
                    }
                }
                catch (IOException iOException) {
                    objectArray[0] = iOException;
                }
                return objectArray;
            }
        });
        if (objectArray[0] instanceof IOException) {
            throw (IOException)objectArray[0];
        }
        return (FileContents[])objectArray;
    }
}

