/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh;

import com.shfarr.ui.GraphicsUtils;
import com.shfarr.ui.plaf.fh.textures.Texture;
import com.shfarr.ui.plaf.fh.theme.ThemeManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class FhProgressBarUI
extends BasicProgressBarUI {
    public static final BasicStroke fakeStroke = new BasicStroke(0.0f);

    public static ComponentUI createUI(JComponent c) {
        return new FhProgressBarUI();
    }

    public void paint(Graphics g, JComponent c) {
        int i;
        ThemeManager.instance().probeAntialiasing(g);
        super.paint(g, c);
        Graphics2D g2D = (Graphics2D)g;
        Insets ins = this.progressBar.getBorder() != null ? this.progressBar.getBorder().getBorderInsets(this.progressBar) : new Insets(0, 0, 0, 0);
        Dimension dim = this.progressBar.getSize();
        BoundedRangeModel model = this.progressBar.getModel();
        int amountFull = 0;
        int lineSX = 0;
        int lineEX = 0;
        int lineSY = 0;
        int lineEY = 0;
        Rectangle rectFilled = new Rectangle();
        Rectangle rectUnfilled = new Rectangle();
        Rectangle strippedBounds = new Rectangle(ins.left, ins.top, dim.width - ins.left - ins.right, dim.height - ins.top - ins.bottom);
        if (model.getMaximum() - model.getMinimum() != 0) {
            amountFull = this.progressBar.getOrientation() == 0 ? (int)Math.round((double)(dim.width - ins.left - ins.right) * this.progressBar.getPercentComplete()) : (int)Math.round((double)(dim.height - ins.top - ins.bottom) * this.progressBar.getPercentComplete());
        }
        Texture[] textures = new Texture[]{(Texture)UIManager.getDefaults().get("ProgressBar.uncompletedAreaTexture"), (Texture)UIManager.getDefaults().get("ProgressBar.completedAreaTexture"), (Texture)UIManager.getDefaults().get("ProgressBar.texture")};
        if (this.progressBar.getOrientation() == 0) {
            rectFilled.setBounds(ins.left, ins.top, amountFull, dim.height - ins.top - ins.bottom);
            rectUnfilled.setBounds(ins.left + amountFull, ins.top, dim.width - ins.left - ins.right - amountFull, dim.height - ins.top - ins.bottom);
            lineSX = ins.left + amountFull;
            lineSY = ins.top;
            lineEX = ins.left + amountFull;
            lineEY = dim.height - ins.bottom;
        } else {
            rectFilled.setBounds(ins.left, dim.height - ins.bottom - amountFull, dim.width - ins.left - ins.right, amountFull);
            rectUnfilled.setBounds(ins.left, ins.top, dim.width - ins.left - ins.right, dim.height - ins.bottom - amountFull);
            lineSX = ins.left;
            lineSY = dim.height - ins.bottom - amountFull;
            lineEX = dim.width - ins.right;
            lineEY = dim.height - ins.bottom - amountFull;
            if (ThemeManager.instance().probeSmallTextures()) {
                i = 0;
                while (i < textures.length) {
                    textures[i].rotate(1);
                    ++i;
                }
            }
        }
        if (ThemeManager.instance().probeSmallTextures()) {
            if (textures[0] != null) {
                textures[0].apply(rectUnfilled, g2D, c);
            }
            if (textures[1] != null) {
                textures[1].apply(rectFilled, g2D, c);
            }
            if (textures[2] != null) {
                textures[2].apply(strippedBounds, g2D, c);
            }
        }
        g.setColor(new Color(GraphicsUtils.darker(this.progressBar.getForeground().getRGB(), 0.2f)));
        ((Graphics2D)g).setStroke(fakeStroke);
        g.drawLine(lineSX, lineSY, lineEX, lineEY);
        if (this.progressBar.getOrientation() == 1 && ThemeManager.instance().probeSmallTextures()) {
            i = 0;
            while (i < textures.length) {
                textures[i].rotate(-1);
                ++i;
            }
        }
    }
}

