/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh.theme;

import com.shfarr.io.IOUtils;
import com.shfarr.ui.LabelComponentGroup;
import com.shfarr.ui.layouts.MaxLayout;
import com.shfarr.ui.layouts.QueueLayout;
import com.shfarr.ui.plaf.fh.FhLookAndFeel;
import com.shfarr.ui.plaf.fh.FhRootPaneUI;
import com.shfarr.ui.plaf.fh.theme.Preferences;
import com.shfarr.ui.plaf.fh.theme.Theme;
import com.shfarr.ui.plaf.fh.theme.edit.ThemeEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileSystemView;

public class ThemeManager
implements ActionListener,
ChangeListener {
    public static final String[] BUILT_IN_THEMES = new String[]{"Classic(built-in)", "Flat(built-in)", "Flat_with_shadows(built-in)"};
    protected static ThemeManager currentManager = null;
    protected JPanel contentPane = null;
    protected JPanel aboutPanel = null;
    protected JPanel generalPanel = null;
    protected Theme currentTheme = null;
    protected Preferences preferences = null;
    private JTextField themeDirectoryField = null;
    private JComboBox themeCombo = null;
    private JCheckBox manageIconsCheck = null;
    private JCheckBox smoothText = null;
    private JCheckBox paintLargeTextures = null;
    private JCheckBox paintSmallTextures = null;
    private JPanel accessibility = null;
    private JSlider fontAdjustment = null;
    private JSlider brightnessAdjustment = null;
    private JSlider contrastAdjustment = null;
    private JSlider saturationAdjustment = null;
    private JCheckBox strengthenFonts = null;
    private JCheckBox strengthenBorders = null;
    private JPanel licensePanel = null;
    private JPanel helpPanel = null;
    private JTabbedPane tabPane = null;
    private JEditorPane editor = null;
    private JPanel adjustmentPanel = null;
    private JCheckBox usingCustomBaseColor = null;
    private JPanel customColorChooser = null;
    private JButton customColorChooserButton = null;
    private JFrame frame = null;
    private JDialog dialog = null;
    private String[] tabTitles = new String[]{"About", "General", "Behaviour", "Accessibility", "Theme Editor", "License"};
    private boolean updateNeeded = false;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JButton applyButton = null;
    static /* synthetic */ Class class$0;

    private ThemeManager() {
    }

    protected JPanel getAboutPanel() {
        if (this.aboutPanel == null) {
            this.aboutPanel = new JPanel(new BorderLayout(5, 5));
            this.aboutPanel.setOpaque(true);
            this.aboutPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.aboutPanel.add((Component)new JLabel(new ImageIcon(ClassLoader.getSystemResource("fhlaf_resources/fhbig.png"))), "West");
        }
        return this.aboutPanel;
    }

    protected JPanel getHelpPanel() {
        if (this.helpPanel == null) {
            this.helpPanel = new JPanel(new BorderLayout());
            this.helpPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
            try {
                this.editor = new JEditorPane(ClassLoader.getSystemResource("fhlaf_resources/help.html"));
                this.editor.setEditable(false);
                JScrollPane sp = new JScrollPane(this.editor);
                sp.setPreferredSize(new Dimension(100, 100));
                this.helpPanel.add((Component)sp, "Center");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.helpPanel;
    }

    protected JPanel getLicensePanel() {
        if (this.licensePanel == null) {
            this.licensePanel = new JPanel(new BorderLayout());
            this.licensePanel.setBorder(new EmptyBorder(10, 10, 10, 10));
            try {
                this.editor = new JEditorPane(ClassLoader.getSystemResource("fhlaf_resources/license.html"));
                this.editor.setEditable(false);
                JScrollPane sp = new JScrollPane(this.editor);
                sp.setPreferredSize(new Dimension(100, 100));
                this.licensePanel.add((Component)sp, "Center");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.licensePanel;
    }

    protected JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton("Ok");
            this.okButton.addActionListener(this);
            this.okButton.setDisplayedMnemonicIndex(0);
            this.okButton.setMnemonic('o');
        }
        return this.okButton;
    }

    protected JButton getApplyButton() {
        if (this.applyButton == null) {
            this.applyButton = new JButton("Apply");
            this.applyButton.addActionListener(this);
            this.applyButton.setDisplayedMnemonicIndex(0);
            this.applyButton.setMnemonic('a');
        }
        return this.applyButton;
    }

    protected JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(this);
            this.cancelButton.setDisplayedMnemonicIndex(0);
            this.cancelButton.setMnemonic('c');
        }
        return this.cancelButton;
    }

    protected JComponent getContentPane() {
        if (this.contentPane == null) {
            JPanel buttonPane = new JPanel(new QueueLayout(4, 100, 2));
            buttonPane.setBorder(new EmptyBorder(3, 3, 3, 2));
            buttonPane.add((Component)this.getApplyButton(), QueueLayout.END);
            buttonPane.add((Component)this.getOkButton(), QueueLayout.END);
            buttonPane.add((Component)this.getCancelButton(), QueueLayout.END);
            this.tabPane = new JTabbedPane();
            this.tabPane.addTab(this.tabTitles[0], this.getAboutPanel());
            this.tabPane.addTab(this.tabTitles[1], this.getGeneralPanel());
            this.tabPane.addTab(this.tabTitles[2], this.getAdJustmentPanel());
            this.tabPane.addTab(this.tabTitles[3], this.getAccessibility());
            this.tabPane.addTab(this.tabTitles[4], ThemeEditor.instance());
            this.tabPane.addTab(this.tabTitles[5], this.getLicensePanel());
            this.contentPane = new JPanel(new BorderLayout());
            this.contentPane.add((Component)this.tabPane, "Center");
            this.contentPane.add((Component)buttonPane, "South");
        }
        return this.contentPane;
    }

    protected JCheckBox getStrengthenFonts() {
        if (this.strengthenFonts == null) {
            this.strengthenFonts = new JCheckBox("All fonts are bold", this.getPreferences().isStrengthenFonts());
            this.strengthenFonts.setBorder(new EmptyBorder(0, 1, 0, 0));
            this.strengthenFonts.setActionCommand("Change Occured");
            this.strengthenFonts.addActionListener(this);
        }
        return this.strengthenFonts;
    }

    protected JCheckBox getStrengthenBorders() {
        if (this.strengthenBorders == null) {
            this.strengthenBorders = new JCheckBox("Duplicate borders", this.getPreferences().isBordersDoubled());
            this.strengthenBorders.setBorder(new EmptyBorder(0, 1, 0, 0));
        }
        return this.strengthenBorders;
    }

    protected JSlider getFontAdjustment() {
        if (this.fontAdjustment == null) {
            this.fontAdjustment = new JSlider();
            this.fontAdjustment.setMinimum(0);
            this.fontAdjustment.setMajorTickSpacing(100);
            this.fontAdjustment.setMinorTickSpacing(5);
            this.fontAdjustment.setSnapToTicks(true);
            this.fontAdjustment.setPaintTicks(true);
            this.fontAdjustment.setPaintLabels(true);
            this.fontAdjustment.setMaximum(300);
            this.fontAdjustment.setValue(this.getPreferences().getFontSizeAdjustment());
            this.fontAdjustment.addChangeListener(this);
        }
        return this.fontAdjustment;
    }

    protected JSlider getContrastAdjustment() {
        if (this.contrastAdjustment == null) {
            this.contrastAdjustment = new JSlider();
            this.contrastAdjustment.setMinimum(-50);
            this.contrastAdjustment.setMajorTickSpacing(25);
            this.contrastAdjustment.setMinorTickSpacing(5);
            this.contrastAdjustment.setSnapToTicks(true);
            this.contrastAdjustment.setPaintTicks(true);
            this.contrastAdjustment.setPaintLabels(true);
            this.contrastAdjustment.setMaximum(50);
            this.contrastAdjustment.setValue(this.getPreferences().getContrast());
            this.contrastAdjustment.addChangeListener(this);
        }
        return this.contrastAdjustment;
    }

    protected JSlider getBrightnessAdjustment() {
        if (this.brightnessAdjustment == null) {
            this.brightnessAdjustment = new JSlider();
            this.brightnessAdjustment.setMinimum(-50);
            this.brightnessAdjustment.setMajorTickSpacing(25);
            this.brightnessAdjustment.setMinorTickSpacing(5);
            this.brightnessAdjustment.setSnapToTicks(true);
            this.brightnessAdjustment.setPaintTicks(true);
            this.brightnessAdjustment.setPaintLabels(true);
            this.brightnessAdjustment.setMaximum(50);
            this.brightnessAdjustment.setValue(this.getPreferences().getBrightness());
            this.brightnessAdjustment.addChangeListener(this);
        }
        return this.brightnessAdjustment;
    }

    protected JSlider getSaturationAdjustment() {
        if (this.saturationAdjustment == null) {
            this.saturationAdjustment = new JSlider();
            this.saturationAdjustment.setMinimum(0);
            this.saturationAdjustment.setMajorTickSpacing(25);
            this.saturationAdjustment.setMinorTickSpacing(5);
            this.saturationAdjustment.setSnapToTicks(true);
            this.saturationAdjustment.setPaintTicks(true);
            this.saturationAdjustment.setPaintLabels(true);
            this.saturationAdjustment.setMaximum(100);
            this.saturationAdjustment.setValue(this.getPreferences().getSaturation());
            this.saturationAdjustment.addChangeListener(this);
        }
        return this.saturationAdjustment;
    }

    public JCheckBox getUsingCustomBaseColor() {
        if (this.usingCustomBaseColor == null) {
            this.usingCustomBaseColor = new JCheckBox("Use Custom Base Color", this.getPreferences().isUsingCustomBaseColor());
            this.usingCustomBaseColor.setBorder(new EmptyBorder(0, 1, 0, 0));
            this.usingCustomBaseColor.setActionCommand("use custom color");
            this.usingCustomBaseColor.addActionListener(this);
        }
        return this.usingCustomBaseColor;
    }

    protected JButton getCustomColorChooserButton() {
        if (this.customColorChooserButton == null) {
            this.customColorChooserButton = new JButton("Select Custom Color");
            this.customColorChooserButton.addActionListener(this);
            this.customColorChooserButton.setActionCommand("choose custom color");
            this.customColorChooserButton.setRolloverEnabled(true);
            this.customColorChooserButton.setEnabled(this.getPreferences().isUsingCustomBaseColor());
        }
        if (this.getPreferences().getCustomBaseColor() != null) {
            this.customColorChooser.setBackground(this.getPreferences().getCustomBaseColor());
        }
        return this.customColorChooserButton;
    }

    protected JPanel getCustomColorChooser() {
        if (this.customColorChooser == null) {
            this.customColorChooser = new JPanel();
            this.customColorChooser.setPreferredSize(new Dimension(100, 24));
            this.customColorChooser.setBorder(new CompoundBorder(new MatteBorder(0, 1, 0, 5, this.getContentPane().getBackground()), new MatteBorder(2, 2, 2, 2, Color.black)));
        }
        if (this.getPreferences().getCustomBaseColor() != null) {
            this.customColorChooser.setBackground(this.getPreferences().getCustomBaseColor());
        }
        return this.customColorChooser;
    }

    protected JPanel getAdJustmentPanel() {
        if (this.adjustmentPanel == null) {
            this.adjustmentPanel = new JPanel(new BorderLayout());
            this.adjustmentPanel.setBorder(new EmptyBorder(30, 30, 30, 30));
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)this.getCustomColorChooser(), "Center");
            panel.add((Component)this.getCustomColorChooserButton(), "East");
            JPanel panelTop = new JPanel(new MaxLayout());
            panelTop.add(new LabelComponentGroup(new String[]{"", "", "", " Base Color Saturation", "", "", "", "", ""}, new Component[]{this.getUsingCustomBaseColor(), panel, new JLabel(), this.getSaturationAdjustment(), new JLabel(), this.getManageIconsCheck(), this.getSmoothText(), this.getPaintLargeTextures(), this.getPaintSmallTextures()}, 2));
            this.adjustmentPanel.add((Component)panelTop, "North");
        }
        return this.adjustmentPanel;
    }

    protected JPanel getAccessibility() {
        if (this.accessibility == null) {
            this.accessibility = new JPanel(new BorderLayout());
            this.accessibility.setBorder(new EmptyBorder(30, 30, 30, 30));
            JPanel panel = new JPanel(new QueueLayout(4, 100, 2));
            panel.add(this.getStrengthenFonts());
            JPanel panelTop = new JPanel(new MaxLayout());
            panelTop.add(new LabelComponentGroup(new String[]{"", "", " Font Size Adjustment ( % )", "", " Brighness", " Contrast"}, new Component[]{panel, new JLabel(), this.getFontAdjustment(), new JLabel(), this.getBrightnessAdjustment(), this.getContrastAdjustment()}, 2));
            this.accessibility.add((Component)panelTop, "North");
        }
        return this.accessibility;
    }

    protected JCheckBox getPaintSmallTextures() {
        if (this.paintSmallTextures == null) {
            this.paintSmallTextures = new JCheckBox("Paint Small Textures", this.getPreferences().isSmallTexturesPainted());
            this.paintSmallTextures.setBorder(new EmptyBorder(0, 1, 0, 0));
            this.paintSmallTextures.setActionCommand("Change Occured");
            this.paintSmallTextures.addActionListener(this);
        }
        return this.paintSmallTextures;
    }

    protected JCheckBox getPaintLargeTextures() {
        if (this.paintLargeTextures == null) {
            this.paintLargeTextures = new JCheckBox("Paint Large Textures", this.getPreferences().isLargeTexturesPainted());
            this.paintLargeTextures.setBorder(new EmptyBorder(0, 1, 0, 0));
            this.paintLargeTextures.setActionCommand("Change Occured");
            this.paintLargeTextures.addActionListener(this);
        }
        return this.paintLargeTextures;
    }

    protected JCheckBox getSmoothText() {
        if (this.smoothText == null) {
            this.smoothText = new JCheckBox("Smooth Text Edges", this.getPreferences().isAntialiasingTexts());
            this.smoothText.setBorder(new EmptyBorder(0, 1, 0, 0));
            this.smoothText.setActionCommand("Change Occured");
            this.smoothText.addActionListener(this);
        }
        return this.smoothText;
    }

    protected JCheckBox getManageIconsCheck() {
        if (this.manageIconsCheck == null) {
            this.manageIconsCheck = new JCheckBox("Manage Button Icons", this.getPreferences().isManageButtonIcons());
            this.manageIconsCheck.setBorder(new EmptyBorder(0, 1, 0, 0));
            this.manageIconsCheck.setActionCommand("Change Occured");
            this.manageIconsCheck.addActionListener(this);
        }
        return this.manageIconsCheck;
    }

    protected JTextField getThemeDirectoryField() {
        if (this.themeDirectoryField == null) {
            this.themeDirectoryField = new JTextField(this.getPreferences().getThemeDirectory());
        }
        return this.themeDirectoryField;
    }

    protected JComboBox getThemeCombo() {
        if (this.themeCombo == null) {
            this.themeCombo = new JComboBox();
            this.updateThemeCombo();
        }
        return this.themeCombo;
    }

    public void updateThemeCombo() {
        String[] themes;
        this.getThemeCombo().removeActionListener(this);
        this.getThemeCombo().removeAllItems();
        int i = 0;
        while (i < BUILT_IN_THEMES.length) {
            this.getThemeCombo().addItem(BUILT_IN_THEMES[i]);
            ++i;
        }
        if (this.getPreferences().getThemeDirectory() != null && (themes = new File(this.getPreferences().getThemeDirectory()).list()) != null) {
            int i2 = 0;
            while (i2 < themes.length) {
                block5: {
                    int k = 0;
                    while (k < this.getThemeCombo().getItemCount()) {
                        if (!this.getThemeCombo().getItemAt(k).equals(themes[i2])) {
                            ++k;
                            continue;
                        }
                        break block5;
                    }
                    this.getThemeCombo().addItem(themes[i2]);
                }
                ++i2;
            }
        }
        this.getThemeCombo().setSelectedItem(this.getPreferences().getCurrentTheme() == null ? this.themeCombo.getItemAt(0) : this.getPreferences().getCurrentTheme());
        this.getThemeCombo().setActionCommand("Change Theme");
        this.getThemeCombo().addActionListener(this);
    }

    protected JPanel getGeneralPanel() {
        if (this.generalPanel == null) {
            this.generalPanel = new JPanel(new BorderLayout());
            this.generalPanel.setBorder(new EmptyBorder(30, 15, 15, 30));
            this.getThemeDirectoryField().setPreferredSize(new Dimension(200, this.getThemeDirectoryField().getPreferredSize().height));
            JPanel aPanel = new JPanel(new BorderLayout());
            aPanel.add((Component)this.getThemeDirectoryField(), "Center");
            JButton button = new JButton("...");
            button.addActionListener(this);
            button.setActionCommand("browse theme dir");
            button.setMargin(new Insets(1, 1, 1, 1));
            button.setPreferredSize(new Dimension(this.getThemeDirectoryField().getPreferredSize().height + 2, this.getThemeDirectoryField().getPreferredSize().height));
            aPanel.add((Component)button, "East");
            JButton newTheme = new JButton("New Theme");
            newTheme.addActionListener(this);
            JButton customizeTheme = new JButton("Customize Theme");
            customizeTheme.addActionListener(this);
            LabelComponentGroup group = new LabelComponentGroup(new String[]{"Extarnal Theme Directory", "", "Current Theme", "", "", "", "", "", "", ""}, new JComponent[]{aPanel, new JLabel(), this.getThemeCombo(), new JLabel(), new JLabel(this.getCurrentTheme().getDescription()), new JLabel("Version: " + this.getCurrentTheme().getVersion()), new JLabel("Author: " + this.getCurrentTheme().getAuthor()), new JLabel(), newTheme, customizeTheme}, 0);
            this.generalPanel.add((Component)group, "North");
        }
        return this.generalPanel;
    }

    public static ThemeManager instance() {
        if (currentManager == null) {
            currentManager = new ThemeManager();
        }
        return currentManager;
    }

    public void launch(JComponent jc, JFrame frame) {
        this.frame = frame;
        if (this.editor != null) {
            this.editor.setPreferredSize(new Dimension(100, 100));
        }
        this.getThemeCombo().setSelectedItem(this.getPreferences().getCurrentTheme() == null ? this.themeCombo.getItemAt(0) : this.getPreferences().getCurrentTheme());
        this.getSmoothText().setSelected(this.getPreferences().isAntialiasingTexts());
        this.getPaintSmallTextures().setSelected(this.getPreferences().isSmallTexturesPainted());
        this.getPaintLargeTextures().setSelected(this.getPreferences().isLargeTexturesPainted());
        this.getThemeDirectoryField().setText(this.getPreferences().getThemeDirectory());
        this.getManageIconsCheck().setSelected(this.getPreferences().isManageButtonIcons());
        this.getFontAdjustment().setValue(this.getPreferences().getFontSizeAdjustment());
        this.getBrightnessAdjustment().setValue(this.getPreferences().getBrightness());
        this.getContrastAdjustment().setValue(this.getPreferences().getContrast());
        this.getSaturationAdjustment().setValue(this.getPreferences().getSaturation());
        this.getStrengthenFonts().setSelected(this.getPreferences().isStrengthenFonts());
        this.getStrengthenBorders().setSelected(this.getPreferences().isBordersDoubled());
        this.getUsingCustomBaseColor().setSelected(this.getPreferences().isUsingCustomBaseColor());
        this.getCustomColorChooser().setEnabled(this.getUsingCustomBaseColor().isSelected());
        if (!this.getPreferences().isLicenseViewed()) {
            this.tabPane.setSelectedIndex(this.tabTitles.length - 1);
            this.tabPane.addChangeListener(this);
        }
        this.setUpdateNeeded(false);
        if (frame == null) {
            JDialog dialog = SwingUtilities.windowForComponent(jc) instanceof Frame ? new JDialog((Frame)SwingUtilities.windowForComponent(jc), " ::: L&F Control center :::", true) : new JDialog((Dialog)SwingUtilities.windowForComponent(jc), " ::: L&F Control center :::", true);
            dialog.setContentPane(this.getContentPane());
            dialog.setDefaultCloseOperation(2);
            dialog.pack();
            dialog.setLocationRelativeTo(SwingUtilities.windowForComponent(jc));
            dialog.setVisible(true);
        } else {
            frame.setContentPane(this.getContentPane());
            frame.pack();
            frame.setVisible(true);
        }
    }

    public Theme getCurrentTheme() {
        if (this.currentTheme == null) {
            try {
                this.currentTheme = new Theme(this.getPreferences().getCurrentTheme() == null ? this.themeCombo.getItemAt(0).toString() : this.getPreferences().getCurrentTheme());
            }
            catch (Exception e) {
                try {
                    this.currentTheme = new Theme(BUILT_IN_THEMES[BUILT_IN_THEMES.length - 1]);
                    this.getPreferences().setCurrentTheme(this.currentTheme.getName());
                }
                catch (Exception ex) {
                    System.out.println("Unable to load the default theme! System exits.");
                    ex.printStackTrace();
                    System.exit(1);
                }
            }
            this.currentTheme.addChangeListener(this);
        }
        return this.currentTheme;
    }

    public Preferences getPreferences() {
        if (this.preferences == null) {
            try {
                ObjectInputStream stream = new ObjectInputStream(new FileInputStream(String.valueOf(this.getDirectoryName()) + "/.properties"));
                this.preferences = (Preferences)stream.readObject();
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.preferences == null) {
                this.preferences = new Preferences();
            }
        }
        return this.preferences;
    }

    protected static void customize(Theme theme, String name) {
        new File(String.valueOf(ThemeManager.instance().getPreferences().getThemeDirectory()) + "/" + name + "/icons").mkdirs();
        try {
            Iterator iter = theme.themeFiles().iterator();
            while (iter.hasNext()) {
                String file = (String)iter.next();
                IOUtils.save(IOUtils.load(theme.getResourceURL(file)), String.valueOf(ThemeManager.instance().getPreferences().getThemeDirectory()) + "/" + name + "/" + file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent ae) {
        Color c;
        if (ae.getActionCommand().equals("Change Occured")) {
            this.setUpdateNeeded(true);
        }
        if (ae.getActionCommand().equals("Change Theme")) {
            this.getPreferences().setCurrentTheme(this.getThemeCombo().getSelectedItem().toString());
            this.setUpdateNeeded(true);
        }
        if (ae.getActionCommand().equals("New Theme")) {
            String theme;
            String name = JOptionPane.showInputDialog(SwingUtilities.windowForComponent((JButton)ae.getSource()), "Theme Name", "New Theme");
            if (name != null && (theme = (String)JOptionPane.showInputDialog(SwingUtilities.windowForComponent((JButton)ae.getSource()), "Choose one of the built in themes as start", "New Theme", 3, null, BUILT_IN_THEMES, BUILT_IN_THEMES[0])) != null) {
                try {
                    ThemeManager.customize(new Theme(theme), name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.updateThemeCombo();
            this.getThemeCombo().setSelectedItem(name);
            this.setUpdateNeeded(true);
        }
        if (ae.getActionCommand().equals("Customize Theme")) {
            String input = JOptionPane.showInputDialog(SwingUtilities.windowForComponent((JButton)ae.getSource()), "Theme Name", "New Theme based on " + this.currentTheme.getName());
            if (input != null) {
                ThemeManager.customize(this.currentTheme, input);
            }
            this.updateThemeCombo();
            this.getThemeCombo().setSelectedItem(input);
            this.setUpdateNeeded(true);
        }
        if (ae.getActionCommand().equals("use custom color")) {
            this.getCustomColorChooserButton().setEnabled(this.getUsingCustomBaseColor().isSelected());
            this.setUpdateNeeded(true);
        }
        if (ae.getActionCommand().equals("choose custom color") && (c = JColorChooser.showDialog(SwingUtilities.windowForComponent((JButton)ae.getSource()), "Custom Color", this.getPreferences().getCustomBaseColor())) != null) {
            this.getPreferences().setCustomBaseColor(c);
            this.getCustomColorChooser().setBackground(c);
            this.setUpdateNeeded(true);
        }
        if (ae.getActionCommand().equals("browse theme dir")) {
            JFileChooser chooser = new JFileChooser(this.getPreferences().getThemeDirectory());
            chooser.setFileSelectionMode(1);
            chooser.setFileSelectionMode(1);
            if (chooser.showOpenDialog(SwingUtilities.windowForComponent((JButton)ae.getSource())) == 0) {
                this.getThemeDirectoryField().setText(chooser.getSelectedFile().getPath());
            }
            return;
        }
        if (ae.getActionCommand().equals("Ok") || ae.getActionCommand().equals("Apply")) {
            this.currentTheme = null;
            this.getPreferences().setCurrentTheme(this.getThemeCombo().getSelectedItem().toString());
            this.getPreferences().setAntialiasingTexts(this.getSmoothText().isSelected());
            this.getPreferences().setSmallTexturesPainted(this.getPaintSmallTextures().isSelected());
            this.getPreferences().setLargeTexturesPainted(this.getPaintLargeTextures().isSelected());
            this.getPreferences().setThemeDirectory(this.getThemeDirectoryField().getText());
            this.getPreferences().setManageButtonIcons(this.getManageIconsCheck().isSelected());
            this.getPreferences().setFontSizeAdjustment(this.getFontAdjustment().getValue());
            this.getPreferences().setBrightness(this.getBrightnessAdjustment().getValue());
            this.getPreferences().setContrast(this.getContrastAdjustment().getValue());
            this.getPreferences().setSaturation(this.getSaturationAdjustment().getValue());
            this.getPreferences().setStrengthenFonts(this.getStrengthenFonts().isSelected());
            this.getPreferences().setBordersDoubled(this.getStrengthenBorders().isSelected());
            this.getPreferences().setUsingCustomBaseColor(this.getUsingCustomBaseColor().isSelected());
            try {
                new File(this.getDirectoryName()).mkdirs();
                ObjectOutputStream stream = new ObjectOutputStream(new FileOutputStream(String.valueOf(this.getDirectoryName()) + "/.properties"));
                stream.writeObject(this.getPreferences());
                stream.close();
                this.currentTheme = null;
                this.getCurrentTheme();
                this.update();
                this.setUpdateNeeded(false);
            }
            catch (Exception stream) {
                // empty catch block
            }
        }
        if (ae.getActionCommand().equals("Ok") || ae.getActionCommand().equals("Cancel")) {
            Window window = SwingUtilities.windowForComponent((Component)ae.getSource());
            window.dispose();
            this.setUpdateNeeded(false);
        }
    }

    protected String getDirectoryName() {
        File file = FileSystemView.getFileSystemView().getHomeDirectory();
        if (file.getName().equalsIgnoreCase("desktop")) {
            return String.valueOf(file.getParent()) + "/.fhlaf";
        }
        return file + "/.fhlaf";
    }

    protected void update() {
        if (!this.updateNeeded) {
            return;
        }
        try {
            UIManager.setLookAndFeel(new FhLookAndFeel());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Iterator i = FhRootPaneUI.registeredWindows.iterator();
        while (i.hasNext()) {
            Container w = ThemeManager.rootContainerForComponent((Component)i.next());
            if (w != null) {
                SwingUtilities.updateComponentTreeUI(w);
                continue;
            }
            i.remove();
        }
    }

    protected static Container rootContainerForComponent(Component aComponent) {
        while (aComponent.getParent() != null) {
            if ((aComponent = aComponent.getParent()) instanceof Window || aComponent instanceof Dialog) break;
        }
        return (Container)aComponent;
    }

    protected void setUpdateNeeded(boolean val) {
        this.updateNeeded = val;
        if (this.updateNeeded) {
            this.getOkButton().setEnabled(true);
            this.getCancelButton().setEnabled(true);
            this.getApplyButton().setEnabled(true);
        } else {
            this.getOkButton().setEnabled(false);
            this.getCancelButton().setEnabled(true);
            this.getApplyButton().setEnabled(false);
        }
        if (this.tabPane != null) {
            this.tabPane.setEnabledAt(4, this.getCurrentTheme().isEditable());
        }
        this.getCustomColorChooser().setBorder(new CompoundBorder(new MatteBorder(0, 1, 0, 5, this.getContentPane().getBackground()), new MatteBorder(2, 2, 2, 2, Color.black)));
    }

    public boolean probeSmallTextures() {
        return this.getPreferences().isSmallTexturesPainted();
    }

    public boolean probeLargeTextures() {
        return this.getPreferences().isLargeTexturesPainted();
    }

    public void probeAntialiasing(Graphics g) {
        if (this.getPreferences().isAntialiasingTexts()) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.tabPane) {
            if (!this.getPreferences().isLicenseViewed()) {
                int ans = JOptionPane.showConfirmDialog(SwingUtilities.windowForComponent((JComponent)e.getSource()), "I have understand and accept the terms of the license agreement.", "Confirmation", 0);
                if (ans == 0) {
                    this.getPreferences().setLicenseViewed(true);
                } else {
                    System.exit(0);
                }
                this.tabPane.removeChangeListener(this);
            }
        } else {
            this.setUpdateNeeded(true);
        }
    }

    public static void main(String[] arguments) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.shfarr.ui.plaf.fh.FhLookAndFeel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            UIManager.setLookAndFeel(clazz.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JFrame frame = new JFrame(" ::: L&F Control center :::");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                System.exit(1);
            }
        });
        ThemeManager.instance().launch(null, frame);
    }
}

