/*
 * Decompiled with CFR 0.152.
 */
package mseries.ui;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.util.Date;
import mseries.ui.MDateFormat;

public class MDateFormatter
implements MDateFormat {
    private DateFormat shortFormatter = DateFormat.getDateTimeInstance(3, 3);
    private DateFormat mediumFormatter = DateFormat.getDateTimeInstance(2, 3);
    private DateFormat longFormatter = DateFormat.getDateTimeInstance(1, 3);
    private DateFormat shortDFormatter = DateFormat.getDateInstance(3);
    private DateFormat mediumDFormatter = DateFormat.getDateInstance(2);
    private DateFormat longDFormatter = DateFormat.getDateInstance(1);
    private static DateFormat formatter;
    private static MDateFormatter thisFormatter;

    private MDateFormatter() {
        formatter = DateFormat.getDateInstance(3);
        formatter.setLenient(false);
        this.shortFormatter.setLenient(false);
        this.mediumFormatter.setLenient(false);
        this.longFormatter.setLenient(false);
        this.shortDFormatter.setLenient(false);
        this.mediumDFormatter.setLenient(false);
        this.longDFormatter.setLenient(false);
    }

    public static MDateFormat getInstance() {
        if (thisFormatter == null) {
            thisFormatter = new MDateFormatter();
        }
        return thisFormatter;
    }

    public String format(Date date) {
        String formattedDate = "";
        try {
            formattedDate = formatter.format(date);
        }
        catch (NullPointerException npe) {
            System.out.println(npe.toString());
        }
        return formattedDate;
    }

    public StringBuffer format(Date date, StringBuffer appendTo, FieldPosition pos) {
        return formatter.format(date, appendTo, pos);
    }

    public Date parse(String text) throws ParseException {
        Date date;
        String inputText = new String(text);
        try {
            date = this.dateTimeParse(inputText);
        }
        catch (ParseException pe) {
            date = this.dateParse(inputText);
            inputText = inputText + " 00:00:00";
            date = this.dateTimeParse(inputText);
        }
        return date;
    }

    public Date dateParse(String text) throws ParseException {
        Date date = new Date();
        try {
            date = this.longDFormatter.parse(text);
        }
        catch (ParseException le) {
            try {
                date = this.mediumDFormatter.parse(text);
            }
            catch (ParseException me) {
                date = this.shortDFormatter.parse(text);
            }
        }
        return date;
    }

    public Date dateTimeParse(String text) throws ParseException {
        Date date = new Date();
        try {
            date = this.longFormatter.parse(text);
        }
        catch (ParseException le) {
            try {
                date = this.mediumFormatter.parse(text);
            }
            catch (ParseException me) {
                date = this.shortFormatter.parse(text);
            }
        }
        return date;
    }

    public static void main(String[] args) {
        Date d = new Date();
        MDateFormat df = null;
        try {
            df = MDateFormatter.getInstance();
            System.out.println(df.parse(args[0]));
        }
        catch (ParseException pe) {
            System.out.println(pe);
        }
        System.out.println(df.format(d));
    }
}

