/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.Externalizable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.UserRealm;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletHttpContext;
import org.mortbay.jetty.servlet.WebApplicationHandler;
import org.mortbay.log.LogFactory;
import org.mortbay.util.JarResource;
import org.mortbay.util.LazyList;
import org.mortbay.util.Loader;
import org.mortbay.util.MultiException;
import org.mortbay.util.Resource;

public class WebApplicationContext
extends ServletHttpContext
implements Externalizable {
    private static Log log = LogFactory.getLog(class$org$mortbay$jetty$servlet$WebApplicationContext == null ? (class$org$mortbay$jetty$servlet$WebApplicationContext = WebApplicationContext.class$("org.mortbay.jetty.servlet.WebApplicationContext")) : class$org$mortbay$jetty$servlet$WebApplicationContext);
    private String _defaultsDescriptor = "org/mortbay/jetty/servlet/webdefault.xml";
    private String _war;
    private boolean _extract;
    private boolean _ignorewebjetty;
    private boolean _distributable;
    private Configuration[] _configurations;
    private String[] _configurationClassNames;
    private transient Map _resourceAliases;
    private transient Resource _webApp;
    private transient Resource _webInf;
    private transient WebApplicationHandler _webAppHandler;
    private transient Object _contextListeners;
    private transient Map _errorPages;
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$WebApplicationContext;
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$WebApplicationHandler;
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$ServletHandler;

    public WebApplicationContext() {
    }

    public WebApplicationContext(String webApp) {
        this._war = webApp;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getContextPath());
        out.writeObject(this.getVirtualHosts());
        HttpHandler[] handlers = this.getHandlers();
        for (int i = 0; i < handlers.length && !(handlers[i] instanceof WebApplicationHandler); ++i) {
            out.writeObject(handlers[i]);
        }
        out.writeObject(this.getAttributes());
        out.writeBoolean(this.isRedirectNullPath());
        out.writeInt(this.getMaxCachedFileSize());
        out.writeInt(this.getMaxCacheSize());
        out.writeBoolean(this.getStatsOn());
        out.writeObject(this.getPermissions());
        out.writeBoolean(this.isClassLoaderJava2Compliant());
        out.writeObject(this._defaultsDescriptor);
        out.writeObject(this._war);
        out.writeBoolean(this._extract);
        out.writeBoolean(this._ignorewebjetty);
        out.writeBoolean(this._distributable);
        out.writeObject(this._configurationClassNames);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setContextPath((String)in.readObject());
        this.setVirtualHosts((String[])in.readObject());
        Object o = in.readObject();
        while (o instanceof HttpHandler) {
            this.addHandler((HttpHandler)o);
            o = in.readObject();
        }
        this.setAttributes((Map)o);
        this.setRedirectNullPath(in.readBoolean());
        this.setMaxCachedFileSize(in.readInt());
        this.setMaxCacheSize(in.readInt());
        this.setStatsOn(in.readBoolean());
        this.setPermissions((PermissionCollection)in.readObject());
        this.setClassLoaderJava2Compliant(in.readBoolean());
        this._defaultsDescriptor = (String)in.readObject();
        this._war = (String)in.readObject();
        this._extract = in.readBoolean();
        this._ignorewebjetty = in.readBoolean();
        this._distributable = in.readBoolean();
        this._configurationClassNames = (String[])in.readObject();
    }

    public void setConfigurationClassNames(String[] configurationClassNames) {
        if (null != configurationClassNames) {
            this._configurationClassNames = new String[configurationClassNames.length];
            System.arraycopy(configurationClassNames, 0, this._configurationClassNames, 0, configurationClassNames.length);
        }
    }

    public String[] getConfigurationClassNames() {
        return this._configurationClassNames;
    }

    public void setWAR(String war) {
        this._war = war;
    }

    public String getWAR() {
        return this._war;
    }

    public WebApplicationHandler getWebApplicationHandler() {
        if (this._webAppHandler == null) {
            this.getServletHandler();
        }
        return this._webAppHandler;
    }

    private void resolveWebApp() throws IOException {
        if (this._webApp == null && this._war != null && this._war.length() > 0) {
            Resource jarWebApp;
            this._webApp = Resource.newResource(this._war);
            if (this._webApp.getAlias() != null) {
                log.info((Object)(this._webApp + " anti-aliased to " + this._webApp.getAlias()));
                this._webApp = Resource.newResource(this._webApp.getAlias());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Try webapp=" + this._webApp + ", exists=" + this._webApp.exists() + ", directory=" + this._webApp.isDirectory()));
            }
            if (this._webApp.exists() && !this._webApp.isDirectory() && !this._webApp.toString().startsWith("jar:") && (jarWebApp = Resource.newResource("jar:" + this._webApp + "!/")).exists() && jarWebApp.isDirectory()) {
                this._webApp = jarWebApp;
                this._war = this._webApp.toString();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Try webapp=" + this._webApp + ", exists=" + this._webApp.exists() + ", directory=" + this._webApp.isDirectory()));
                }
            }
            if (this._webApp.exists() && (!this._webApp.isDirectory() || this._extract && this._webApp.getFile() == null || this._extract && this._webApp.getFile() != null && !this._webApp.getFile().isDirectory())) {
                File tempDir = new File(this.getTempDirectory(), "webapp");
                if (tempDir.exists()) {
                    tempDir.delete();
                }
                tempDir.mkdir();
                tempDir.deleteOnExit();
                log.info((Object)("Extract " + this._war + " to " + tempDir));
                JarResource.extract(this._webApp, tempDir, true);
                this._webApp = Resource.newResource(tempDir.getCanonicalPath());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Try webapp=" + this._webApp + ", exists=" + this._webApp.exists() + ", directory=" + this._webApp.isDirectory()));
                }
            }
            if (!this._webApp.exists() || !this._webApp.isDirectory()) {
                log.warn((Object)("Web application not found " + this._war));
                throw new FileNotFoundException(this._war);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("webapp=" + this._webApp));
            }
            this._webInf = this._webApp.addPath("WEB-INF/");
            if (!this._webInf.exists() || !this._webInf.isDirectory()) {
                this._webInf = null;
            } else {
                Resource work = this._webInf.addPath("work");
                if (work.exists() && work.isDirectory() && work.getFile() != null && work.getFile().canWrite() && this.getAttribute("javax.servlet.context.tempdir") == null) {
                    this.setAttribute("javax.servlet.context.tempdir", work.getFile());
                }
            }
            super.setBaseResource(this._webApp);
        }
    }

    public Resource getWebInf() throws IOException {
        if (this._webInf == null) {
            this.resolveWebApp();
        }
        return this._webInf;
    }

    public synchronized ServletHandler getServletHandler() {
        if (this._webAppHandler == null) {
            this._webAppHandler = (WebApplicationHandler)this.getHandler(class$org$mortbay$jetty$servlet$WebApplicationHandler == null ? (class$org$mortbay$jetty$servlet$WebApplicationHandler = WebApplicationContext.class$("org.mortbay.jetty.servlet.WebApplicationHandler")) : class$org$mortbay$jetty$servlet$WebApplicationHandler);
            if (this._webAppHandler == null) {
                if (this.getHandler(class$org$mortbay$jetty$servlet$ServletHandler == null ? (class$org$mortbay$jetty$servlet$ServletHandler = WebApplicationContext.class$("org.mortbay.jetty.servlet.ServletHandler")) : class$org$mortbay$jetty$servlet$ServletHandler) != null) {
                    throw new IllegalStateException("Cannot have ServletHandler in WebApplicationContext");
                }
                this._webAppHandler = new WebApplicationHandler();
                this.addHandler(this._webAppHandler);
            }
        }
        return this._webAppHandler;
    }

    public void setPermissions(PermissionCollection permissions) {
        if (!this._ignorewebjetty) {
            log.warn((Object)"Permissions set with web-jetty.xml enabled");
        }
        super.setPermissions(permissions);
    }

    public boolean isIgnoreWebJetty() {
        return this._ignorewebjetty;
    }

    public void setIgnoreWebJetty(boolean b) {
        this._ignorewebjetty = b;
        if (b && this.getPermissions() != null) {
            log.warn((Object)"Permissions set with web-jetty.xml enabled");
        }
    }

    public boolean isDistributable() {
        return this._distributable;
    }

    public void setDistributable(boolean distributable) {
        this._distributable = distributable;
    }

    public Configuration[] getConfigurations() {
        return this._configurations;
    }

    protected Configuration[] loadConfigurations() throws Exception {
        String[] names = this._configurationClassNames;
        if (null == names) {
            names = ((Server)this.getHttpServer()).getWebApplicationConfigurationClassNames();
        }
        if (null != names) {
            Object[] nullArgs = new Object[]{};
            Configuration[] configurations = new Configuration[names.length];
            for (int i = 0; i < names.length; ++i) {
                configurations[i] = (Configuration)Loader.loadClass(class$org$mortbay$jetty$servlet$WebApplicationContext == null ? WebApplicationContext.class$("org.mortbay.jetty.servlet.WebApplicationContext") : class$org$mortbay$jetty$servlet$WebApplicationContext, names[i]).getConstructors()[0].newInstance(nullArgs);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Loaded instance of " + names[i]));
            }
            return configurations;
        }
        return new Configuration[0];
    }

    protected void configureClassPath() throws Exception {
        for (int i = 0; i < this._configurations.length; ++i) {
            this._configurations[i].setWebApplicationContext(this);
            this._configurations[i].configureClassPath();
        }
    }

    protected void configureDefaults() throws Exception {
        for (int i = 0; i < this._configurations.length; ++i) {
            this._configurations[i].setWebApplicationContext(this);
            this._configurations[i].configureDefaults();
        }
    }

    protected void configureWebApp() throws Exception {
        for (int i = 0; i < this._configurations.length; ++i) {
            this._configurations[i].setWebApplicationContext(this);
            this._configurations[i].configureWebApp();
        }
    }

    protected void doStart() throws Exception {
        if (this.isStarted()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader lastContextLoader = thread.getContextClassLoader();
        MultiException mex = null;
        try {
            ServletHolder jspHolder;
            this.resolveWebApp();
            this.getServletHandler();
            this._configurations = this.loadConfigurations();
            this.configureClassPath();
            this.initClassLoader(true);
            thread.setContextClassLoader(this.getClassLoader());
            this.initialize();
            this.configureDefaults();
            Map.Entry entry = this._webAppHandler.getHolderEntry("test.jsp");
            if (entry != null && (jspHolder = (ServletHolder)entry.getValue()) != null && jspHolder.getInitParameter("classpath") == null) {
                String fileClassPath = this.getFileClassPath();
                jspHolder.setInitParameter("classpath", fileClassPath);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Set classpath=" + fileClassPath + " for " + jspHolder));
                }
            }
            this.configureWebApp();
            this._webAppHandler.setAutoInitializeServlets(false);
            super.doStart();
            mex = new MultiException();
            if (this._contextListeners != null && this._webAppHandler != null) {
                ServletContextEvent event = new ServletContextEvent(this.getServletContext());
                for (int i = 0; i < LazyList.size(this._contextListeners); ++i) {
                    try {
                        ((ServletContextListener)LazyList.get(this._contextListeners, i)).contextInitialized(event);
                        continue;
                    }
                    catch (Exception ex) {
                        mex.add(ex);
                    }
                }
            }
            if (this._webAppHandler != null && this._webAppHandler.isStarted()) {
                try {
                    this._webAppHandler.initializeServlets();
                }
                catch (Exception ex) {
                    mex.add(ex);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)("Configuration error on " + this._war), (Throwable)e);
            throw e;
        }
        finally {
            thread.setContextClassLoader(lastContextLoader);
        }
        if (mex != null) {
            mex.ifExceptionThrow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        MultiException mex = new MultiException();
        Thread thread = Thread.currentThread();
        ClassLoader lastContextLoader = thread.getContextClassLoader();
        try {
            if (this._contextListeners != null && this._webAppHandler != null) {
                ServletContextEvent event = new ServletContextEvent(this.getServletContext());
                int i = LazyList.size(this._contextListeners);
                while (i-- > 0) {
                    try {
                        ((ServletContextListener)LazyList.get(this._contextListeners, i)).contextDestroyed(event);
                    }
                    catch (Exception e) {
                        mex.add(e);
                    }
                }
            }
            this._contextListeners = null;
            try {
                super.doStop();
            }
            catch (Exception e) {
                mex.add(e);
            }
            this.clearSecurityConstraints();
            if (this._webAppHandler != null) {
                this.removeHandler(this._webAppHandler);
            }
            this._webAppHandler = null;
            if (this._errorPages != null) {
                this._errorPages.clear();
            }
            this._errorPages = null;
            this._webApp = null;
            this._webInf = null;
            this._configurations = null;
        }
        finally {
            thread.setContextClassLoader(lastContextLoader);
        }
        if (mex != null) {
            mex.ifExceptionThrow();
        }
    }

    public void destroy() {
        super.destroy();
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this._defaultsDescriptor = null;
        this._war = null;
        this._configurationClassNames = null;
        if (this._resourceAliases != null) {
            this._resourceAliases.clear();
        }
        this._resourceAliases = null;
        this._contextListeners = null;
        if (this._errorPages != null) {
            this._errorPages.clear();
        }
        this._errorPages = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String pathInContext, String pathParams, HttpRequest httpRequest, HttpResponse httpResponse) throws HttpException, IOException {
        block6: {
            if (!this.isStarted()) {
                return;
            }
            try {
                super.handle(pathInContext, pathParams, httpRequest, httpResponse);
                Object var6_5 = null;
                if (httpRequest.isHandled()) break block6;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (!httpRequest.isHandled()) {
                    httpResponse.sendError(404);
                }
                httpRequest.setHandled(true);
                if (!httpResponse.isCommitted()) {
                    httpResponse.completing();
                    httpResponse.commit();
                }
                throw throwable;
            }
            httpResponse.sendError(404);
        }
        httpRequest.setHandled(true);
        if (!httpResponse.isCommitted()) {
            httpResponse.completing();
            httpResponse.commit();
        }
    }

    public synchronized void addEventListener(EventListener listener) throws IllegalArgumentException {
        if (listener instanceof ServletContextListener) {
            this._contextListeners = LazyList.add(this._contextListeners, listener);
        }
        super.addEventListener(listener);
    }

    public synchronized void removeEventListener(EventListener listener) {
        this._contextListeners = LazyList.remove(this._contextListeners, listener);
        super.removeEventListener(listener);
    }

    public String getDisplayName() {
        return this.getHttpContextName();
    }

    public void setDisplayName(String name) {
        this.setHttpContextName(name);
    }

    public void setDefaultsDescriptor(String defaults) {
        this._defaultsDescriptor = defaults;
    }

    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public void setExtractWAR(boolean extract) {
        this._extract = extract;
    }

    public boolean getExtractWAR() {
        return this._extract;
    }

    protected void initialize() throws Exception {
    }

    protected UserRealm getUserRealm(String name) {
        return this.getHttpServer().getRealm(name);
    }

    public String toString() {
        String name = this.getDisplayName();
        return "WebApplicationContext[" + this.getContextPath() + "," + (name == null ? this._war : name) + "]";
    }

    public void setResourceAlias(String alias, String uri) {
        if (this._resourceAliases == null) {
            this._resourceAliases = new HashMap(5);
        }
        this._resourceAliases.put(alias, uri);
    }

    public Map getResourceAliases() {
        if (this._resourceAliases == null) {
            return null;
        }
        return Collections.unmodifiableMap(this._resourceAliases);
    }

    public String getResourceAlias(String alias) {
        if (this._resourceAliases == null) {
            return null;
        }
        return (String)this._resourceAliases.get(alias);
    }

    public String removeResourceAlias(String alias) {
        if (this._resourceAliases == null) {
            return null;
        }
        return (String)this._resourceAliases.remove(alias);
    }

    public Resource getResource(String uriInContext) throws IOException {
        IOException ioe = null;
        Resource resource = null;
        try {
            resource = super.getResource(uriInContext);
            if (resource != null && resource.exists()) {
                return resource;
            }
        }
        catch (IOException e) {
            ioe = e;
        }
        String aliasedUri = this.getResourceAlias(uriInContext);
        if (aliasedUri != null) {
            return super.getResource(aliasedUri);
        }
        if (ioe != null) {
            throw ioe;
        }
        return resource;
    }

    public void setErrorPage(String error, String uriInContext) {
        if (this._errorPages == null) {
            this._errorPages = new HashMap();
        }
        this._errorPages.put(error, uriInContext);
    }

    public String getErrorPage(String error) {
        if (this._errorPages == null) {
            return null;
        }
        return (String)this._errorPages.get(error);
    }

    public String removeErrorPage(String error) {
        if (this._errorPages == null) {
            return null;
        }
        return (String)this._errorPages.remove(error);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Configuration
    extends Serializable {
        public void setWebApplicationContext(WebApplicationContext var1);

        public WebApplicationContext getWebApplicationContext();

        public void configureClassPath() throws Exception;

        public void configureDefaults() throws Exception;

        public void configureWebApp() throws Exception;
    }
}

