/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi.transport;

import com.google.code.gsonrmi.transport.Collections;
import com.google.code.gsonrmi.transport.DeliveryFailure;
import com.google.code.gsonrmi.transport.Message;
import com.google.code.gsonrmi.transport.MessageProcessor;
import com.google.code.gsonrmi.transport.Proxy$AddConnection;
import com.google.code.gsonrmi.transport.Proxy$CleanUp;
import com.google.code.gsonrmi.transport.Proxy$Connection;
import com.google.code.gsonrmi.transport.Proxy$Options;
import com.google.code.gsonrmi.transport.Route;
import com.google.code.gsonrmi.transport.Route$GroupBy;
import com.google.code.gsonrmi.transport.Transport;
import com.google.code.gsonrmi.transport.Transport$Shutdown;
import com.google.gson.Gson;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class Proxy
extends MessageProcessor {
    protected final Transport transport;
    protected final Gson gson;
    private final Map<String, Proxy$Connection> a;
    private final TimerTask a;

    protected Proxy(Transport transport, Gson gson) {
        this(transport, gson, new Proxy$Options());
    }

    protected Proxy(Transport transport, Gson gson, Proxy$Options proxy$Options) {
        this.transport = transport;
        this.transport.register(this.getScheme(), this.mq);
        this.gson = gson;
        this.a = new HashMap<String, Proxy$Connection>();
        this.a = transport.sendEvery(new Message(null, Arrays.asList(new Route(URI.create(this.getScheme() + ":proxy"))), new Proxy$CleanUp()), proxy$Options.cleanupInterval, proxy$Options.cleanupInterval);
    }

    public abstract String getScheme();

    public abstract Proxy$Connection createConnection(String var1);

    public void addConnection(Proxy$Connection proxy$Connection) {
        this.mq.add(new Message(null, null, new Proxy$AddConnection(proxy$Connection)));
    }

    @Override
    protected void process(Message object) {
        if (((Message)object).contentOfType(Transport$Shutdown.class)) {
            this.handle(((Message)object).getContentAs(Transport$Shutdown.class, this.gson));
            return;
        }
        if (((Message)object).contentOfType(Proxy$AddConnection.class)) {
            Proxy$AddConnection proxy$AddConnection = ((Message)object).getContentAs(Proxy$AddConnection.class, this.gson);
            object = this;
            System.out.println("Adding new Connection: " + proxy$AddConnection.con.getRemoteAuthority());
            ((Proxy)object).a.put(proxy$AddConnection.con.getRemoteAuthority(), proxy$AddConnection.con);
            return;
        }
        if (((Message)object).contentOfType(Proxy$CleanUp.class)) {
            this.handle(((Message)object).getContentAs(Proxy$CleanUp.class, this.gson));
            return;
        }
        this.handle((Message)object);
    }

    public void handle(Transport$Shutdown object) {
        object = this.a.values().iterator();
        while (object.hasNext()) {
            ((Proxy$Connection)object.next()).shutdown();
        }
        this.a.cancel();
    }

    protected void handle(Message message) {
        LinkedList<Route> linkedList = new LinkedList<Route>();
        for (Map.Entry entry : Collections.group(message.dests, (Object)Route$GroupBy.AUTHORITY).entrySet()) {
            String string = (String)entry.getKey();
            List<Route> object = entry.getValue();
            Proxy$Connection proxy$Connection = this.a.get(string);
            if (proxy$Connection == null || !proxy$Connection.isAlive()) {
                System.out.println("Removing Connection: " + proxy$Connection);
                this.a.remove(string);
                proxy$Connection = this.createConnection(string);
                if (proxy$Connection != null) {
                    System.out.println("Adding new Connection: " + proxy$Connection.getRemoteAuthority());
                    this.a.put(string, proxy$Connection);
                }
            }
            if (proxy$Connection != null) {
                proxy$Connection.send(new Message(message.src, object, message.content, message.contentType));
                continue;
            }
            linkedList.addAll(object);
        }
        if (!linkedList.isEmpty() && !message.contentOfType(DeliveryFailure.class)) {
            DeliveryFailure deliveryFailure = new DeliveryFailure(new Message(message.src, linkedList, message.content, message.contentType));
            this.transport.send(new Message(null, Arrays.asList(message.src), deliveryFailure));
        }
    }

    protected void handle(Proxy$CleanUp proxy$CleanUp) {
        int n2 = this.a.size();
        Iterator<Proxy$Connection> iterator = this.a.values().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().isAlive()) continue;
            iterator.remove();
        }
        if (this.a.size() < n2) {
            System.err.println("INFO: " + this.getClass().getSimpleName() + " cleanup connections " + n2 + " -> " + this.a.size());
        }
    }

    public Map<String, Proxy$Connection> getCons() {
        return this.a;
    }
}

