/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field.types;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.BaseDataType;
import com.j256.ormlite.logger.LoggerFactory$1;
import java.math.BigInteger;

public class BigIntegerType
extends BaseDataType {
    public static int DEFAULT_WIDTH = 255;
    private static final BigIntegerType singleTon = new BigIntegerType();

    public static BigIntegerType getSingleton() {
        return singleTon;
    }

    protected BigIntegerType() {
        super(SqlType.STRING, new Class[]{BigInteger.class});
    }

    protected BigIntegerType(SqlType sqlType, Class<?>[] classArray) {
        super(sqlType, classArray);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String string) {
        try {
            return new BigInteger(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LoggerFactory$1.create("Problems with field " + fieldType + " parsing default BigInteger string '" + string + "'", illegalArgumentException);
        }
    }

    @Override
    public Object resultToSqlArg$6e4db97a(FieldType fieldType, k k2, int n2) {
        return k2.a();
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object object, int n2) {
        try {
            return new BigInteger((String)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LoggerFactory$1.create("Problems with column " + n2 + " parsing BigInteger string '" + object + "'", illegalArgumentException);
        }
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object object) {
        return ((BigInteger)object).toString();
    }

    @Override
    public int getDefaultWidth() {
        return DEFAULT_WIDTH;
    }

    @Override
    public boolean isAppropriateId() {
        return false;
    }
}

