/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi.internal;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.asteriskjava.fastagi.AgiException;
import org.asteriskjava.fastagi.MappingStrategy;
import org.asteriskjava.fastagi.command.AsyncAgiBreakCommand;
import org.asteriskjava.fastagi.internal.AgiChannelFactory;
import org.asteriskjava.fastagi.internal.AgiConnectionHandler;
import org.asteriskjava.fastagi.internal.AgiReader;
import org.asteriskjava.fastagi.internal.AgiWriter;
import org.asteriskjava.fastagi.internal.AsyncAgiReader;
import org.asteriskjava.fastagi.internal.AsyncAgiWriter;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.event.AsyncAgiEvent;

public class AsyncAgiConnectionHandler
extends AgiConnectionHandler {
    private final ManagerConnection connection;
    private volatile String channelName;
    private final List<String> environment;
    private final BlockingQueue<AsyncAgiEvent> asyncAgiEvents;
    private AsyncAgiWriter writer;

    public AsyncAgiConnectionHandler(MappingStrategy mappingStrategy, AsyncAgiEvent asyncAgiEvent, AgiChannelFactory agiChannelFactory) {
        super(mappingStrategy, agiChannelFactory);
        if (!asyncAgiEvent.isStart()) {
            throw new IllegalArgumentException("AsyncAgiEvent passed to AsyncAgiConnectionHandler is not a start sub event");
        }
        this.connection = (ManagerConnection)asyncAgiEvent.getSource();
        this.channelName = asyncAgiEvent.getChannel();
        this.environment = asyncAgiEvent.decodeEnv();
        this.asyncAgiEvents = new LinkedBlockingQueue<AsyncAgiEvent>();
        this.setIgnoreMissingScripts(true);
    }

    @Override
    protected AgiReader createReader() {
        return new AsyncAgiReader(this.connection, this.environment, this.asyncAgiEvents);
    }

    @Override
    protected AgiWriter createWriter() {
        this.writer = new AsyncAgiWriter(this.connection, this.channelName);
        return this.writer;
    }

    @Override
    public void release() {
        if (!(this.writer == null || this.getScript() == null && this.isIgnoreMissingScripts())) {
            try {
                this.writer.sendCommand(new AsyncAgiBreakCommand());
                return;
            }
            catch (AgiException agiException) {}
        }
    }

    public void onAsyncAgiExecEvent(AsyncAgiEvent asyncAgiEvent) {
        this.asyncAgiEvents.offer(asyncAgiEvent);
    }

    public void onAsyncAgiEndEvent(AsyncAgiEvent asyncAgiEvent) {
        this.asyncAgiEvents.offer(asyncAgiEvent);
    }

    public void updateChannelName(String string) {
        this.channelName = string;
        this.writer.updateChannelName(string);
    }
}

