/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.asteriskjava.live.AsteriskServer;
import org.asteriskjava.live.LiveObject;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

abstract class AbstractLiveObject
implements LiveObject {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final PropertyChangeSupport changes;
    protected final AsteriskServerImpl server;

    AbstractLiveObject(AsteriskServerImpl asteriskServerImpl) {
        this.server = asteriskServerImpl;
        this.changes = new PropertyChangeSupport(this);
    }

    @Override
    public AsteriskServer getServer() {
        return this.server;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        boolean bl2 = true;
        PropertyChangeListener[] propertyChangeListenerArray = this.changes.getPropertyChangeListeners();
        int n2 = propertyChangeListenerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (propertyChangeListenerArray[i2] != propertyChangeListener) continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            this.changes.addPropertyChangeListener(string, propertyChangeListener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(string, propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (object != null || object2 != null) {
            try {
                this.changes.firePropertyChange(string, object, object2);
                return;
            }
            catch (Exception exception) {
                this.logger.warn("Uncaught exception in PropertyChangeListener", exception);
            }
        }
    }
}

