/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.asteriskjava.live.MeetMeRoom;
import org.asteriskjava.live.MeetMeUser;
import org.asteriskjava.live.internal.AbstractLiveObject;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.live.internal.MeetMeUserImpl;
import org.asteriskjava.manager.action.CommandAction;

class MeetMeRoomImpl
extends AbstractLiveObject
implements MeetMeRoom {
    private static final String COMMAND_PREFIX = "meetme";
    private static final String LOCK_COMMAND = "lock";
    private static final String UNLOCK_COMMAND = "unlock";
    private final String roomNumber;
    private final Map<Integer, MeetMeUserImpl> users;

    MeetMeRoomImpl(AsteriskServerImpl asteriskServerImpl, String string) {
        super(asteriskServerImpl);
        this.roomNumber = string;
        this.users = new HashMap<Integer, MeetMeUserImpl>(20);
    }

    @Override
    public String getRoomNumber() {
        return this.roomNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<MeetMeUser> getUsers() {
        Map<Integer, MeetMeUserImpl> map = this.users;
        synchronized (map) {
            return new ArrayList<MeetMeUser>(this.users.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Map<Integer, MeetMeUserImpl> map = this.users;
        synchronized (map) {
            return this.users.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<MeetMeUserImpl> getUserImpls() {
        Map<Integer, MeetMeUserImpl> map = this.users;
        synchronized (map) {
            return new ArrayList<MeetMeUserImpl>(this.users.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUser(MeetMeUserImpl meetMeUserImpl) {
        Map<Integer, MeetMeUserImpl> map = this.users;
        synchronized (map) {
            this.users.put(meetMeUserImpl.getUserNumber(), meetMeUserImpl);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MeetMeUserImpl getUser(Integer n2) {
        Map<Integer, MeetMeUserImpl> map = this.users;
        synchronized (map) {
            return this.users.get(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUser(MeetMeUserImpl meetMeUserImpl) {
        Map<Integer, MeetMeUserImpl> map = this.users;
        synchronized (map) {
            this.users.remove(meetMeUserImpl.getUserNumber());
            return;
        }
    }

    @Override
    public void lock() {
        this.sendMeetMeCommand(LOCK_COMMAND);
    }

    @Override
    public void unlock() {
        this.sendMeetMeCommand(UNLOCK_COMMAND);
    }

    private void sendMeetMeCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(COMMAND_PREFIX);
        stringBuffer.append(" ");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(this.roomNumber);
        this.server.sendAction(new CommandAction(stringBuffer.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("MeetMeRoom[");
        MeetMeRoomImpl meetMeRoomImpl = this;
        synchronized (meetMeRoomImpl) {
            stringBuffer.append("roomNumber='").append(this.getRoomNumber()).append("',");
            n2 = System.identityHashCode(this);
        }
        stringBuffer.append("systemHashcode=").append(n2);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

