/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.asteriskjava.manager.event.DisconnectEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.ProtocolIdentifierReceivedEvent;
import org.asteriskjava.manager.internal.Dispatcher;
import org.asteriskjava.manager.internal.EventBuilder;
import org.asteriskjava.manager.internal.EventBuilderImpl;
import org.asteriskjava.manager.internal.ManagerReader;
import org.asteriskjava.manager.internal.ManagerUtil;
import org.asteriskjava.manager.internal.ResponseBuilder;
import org.asteriskjava.manager.internal.ResponseBuilderImpl;
import org.asteriskjava.manager.response.ManagerResponse;
import org.asteriskjava.util.DateUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.SocketConnectionFacade;

public class ManagerReaderImpl
implements ManagerReader {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final EventBuilder eventBuilder;
    private final ResponseBuilder responseBuilder;
    private final Dispatcher dispatcher;
    private final Map<String, Class<? extends ManagerResponse>> expectedResponseClasses;
    private final Object source;
    private SocketConnectionFacade socket;
    private volatile boolean die = false;
    private boolean dead = false;
    private IOException terminationException;

    public ManagerReaderImpl(Dispatcher dispatcher, Object object) {
        this.dispatcher = dispatcher;
        this.source = object;
        this.eventBuilder = new EventBuilderImpl();
        this.responseBuilder = new ResponseBuilderImpl();
        this.expectedResponseClasses = new ConcurrentHashMap<String, Class<? extends ManagerResponse>>();
    }

    @Override
    public void setSocket(SocketConnectionFacade socketConnectionFacade) {
        this.socket = socketConnectionFacade;
    }

    @Override
    public void registerEventClass(Class<? extends ManagerEvent> clazz) {
        this.eventBuilder.registerEventClass(clazz);
    }

    @Override
    public void expectResponseClass(String string, Class<? extends ManagerResponse> clazz) {
        this.expectedResponseClasses.put(string, clazz);
    }

    @Override
    public void run() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.socket == null) {
            throw new IllegalStateException("Unable to run: socket is null.");
        }
        this.die = false;
        this.dead = false;
        try {
            String string;
            while (!this.die && (string = this.socket.readLine()) != null) {
                if (string.startsWith("Asterisk Call Manager/") || string.startsWith("Asterisk Call Manager Proxy/") || string.startsWith("Asterisk Manager Proxy/") || string.startsWith("OpenPBX Call Manager/") || string.startsWith("CallWeaver Call Manager/")) {
                    ManagerEvent managerEvent = new ProtocolIdentifierReceivedEvent(this.source);
                    ((ProtocolIdentifierReceivedEvent)managerEvent).setProtocolIdentifier(string);
                    managerEvent.setDateReceived(DateUtil.getDate());
                    this.dispatcher.dispatchEvent(managerEvent);
                    continue;
                }
                if ("Follows".equals(hashMap.get("response")) && string.endsWith("--END COMMAND--")) {
                    hashMap.put("__result__", string);
                    continue;
                }
                if (string.length() > 0) {
                    int n2 = string.indexOf("From ");
                    int n3 = string.indexOf("To ");
                    if (n2 == 0 || n3 == 0) {
                        n2 = string.indexOf(" ");
                        n3 = 1;
                    } else {
                        n2 = string.indexOf(": ");
                        n3 = 2;
                    }
                    if (n2 > 0 && string.length() > n2 + n3) {
                        String string2 = string.substring(0, n2).toLowerCase(Locale.ENGLISH);
                        String string3 = string.substring(n2 + n3);
                        this.addToBuffer(hashMap, string2, string3);
                    }
                }
                if (string.length() != 0) continue;
                if (hashMap.containsKey("event")) {
                    ManagerEvent managerEvent = this.buildEvent(this.source, hashMap);
                    if (managerEvent != null) {
                        this.dispatcher.dispatchEvent(managerEvent);
                    } else {
                        this.logger.debug("buildEvent returned null");
                    }
                } else if (hashMap.containsKey("response")) {
                    ManagerResponse managerResponse = this.buildResponse(hashMap);
                    if (managerResponse != null) {
                        this.dispatcher.dispatchResponse(managerResponse);
                    }
                } else if (hashMap.size() > 0) {
                    this.logger.debug("Buffer contains neither response nor event");
                }
                hashMap.clear();
            }
            this.dead = true;
            this.logger.debug("Reached end of stream, terminating reader.");
            return;
        }
        catch (IOException iOException) {
            this.terminationException = iOException;
            this.dead = true;
            this.logger.info("Terminating reader thread: " + iOException.getMessage());
            return;
        }
        finally {
            this.dead = true;
            DisconnectEvent disconnectEvent = new DisconnectEvent(this.source);
            disconnectEvent.setDateReceived(DateUtil.getDate());
            this.dispatcher.dispatchEvent(disconnectEvent);
        }
    }

    private void addToBuffer(Map<String, Object> map, String string, String string2) {
        if (map.containsKey(string)) {
            Object object = map.get(string);
            if (object instanceof List) {
                ((List)object).add(string2);
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (object instanceof String) {
                arrayList.add((String)object);
            } else {
                arrayList.add(object.toString());
            }
            arrayList.add(string2);
            map.put(string, arrayList);
            return;
        }
        map.put(string, string2);
    }

    @Override
    public void die() {
        this.die = true;
    }

    @Override
    public boolean isDead() {
        return this.dead;
    }

    @Override
    public IOException getTerminationException() {
        return this.terminationException;
    }

    private ManagerResponse buildResponse(Map<String, Object> object) {
        Class<? extends ManagerResponse> clazz = null;
        String string = ManagerUtil.getInternalActionId((String)object.get("actionid"));
        if (string != null && (clazz = this.expectedResponseClasses.get(string)) != null) {
            this.expectedResponseClasses.remove(string);
        }
        if ((object = this.responseBuilder.buildResponse(clazz, (Map<String, Object>)object)) != null) {
            ((ManagerResponse)object).setDateReceived(DateUtil.getDate());
        }
        return object;
    }

    private ManagerEvent buildEvent(Object object, Map<String, Object> map) {
        if ((object = this.eventBuilder.buildEvent(object, map)) != null) {
            ((ManagerEvent)object).setDateReceived(DateUtil.getDate());
        }
        return object;
    }
}

