/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Container;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.FigModifyingModeImpl;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.ui.PopupGenerator;

public class ModePopup
extends FigModifyingModeImpl {
    private static final long serialVersionUID = 288785293995576958L;
    private static final Log LOG = LogFactory.getLog(ModePopup.class);

    public ModePopup(Editor editor) {
        super(editor);
    }

    @Override
    public boolean canExit() {
        return false;
    }

    @Override
    public String instructions() {
        return " ";
    }

    public boolean showPopup(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        Object object = this.editor.hit(n2, n3);
        mouseEvent = this.editor.retranslateMouseEvent(mouseEvent);
        if (object == null && (jPopupMenu = this.editor.getPopupMenu()) != null) {
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            mouseEvent.consume();
            return true;
        }
        if (!(object instanceof PopupGenerator)) {
            return false;
        }
        Serializable serializable = this.editor.getSelectionManager();
        if (!((SelectionManager)serializable).containsFig((Fig)object)) {
            ((SelectionManager)serializable).select((Fig)object);
        } else {
            object = ((SelectionManager)serializable).getFigs();
            object = new Vector(object);
            ((SelectionManager)serializable).select((Collection)object);
        }
        object = ((SelectionManager)serializable).findCommonSuperClass();
        if (object != null && (object = ((SelectionManager)serializable).findFirstSelectionOfType((Class)object)) instanceof PopupGenerator) {
            object = ((PopupGenerator)object).getPopUpActions(mouseEvent);
            serializable = new JPopupMenu();
            int n4 = object.size();
            for (int i2 = 0; i2 < n4; ++i2) {
                Object e2 = object.get(i2);
                if (e2 instanceof AbstractAction) {
                    ((JPopupMenu)serializable).add((AbstractAction)e2);
                    continue;
                }
                if (e2 instanceof JMenu) {
                    ((JPopupMenu)serializable).add((JMenu)e2);
                    continue;
                }
                if (e2 instanceof JMenuItem) {
                    ((JPopupMenu)serializable).add((JMenuItem)e2);
                    continue;
                }
                if (!(e2 instanceof JSeparator)) continue;
                ((Container)serializable).add((JSeparator)e2);
            }
            ((JPopupMenu)serializable).show(this.editor.getJComponent(), mouseEvent.getX(), mouseEvent.getY());
            mouseEvent.consume();
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || mouseEvent.getModifiers() == 4) {
            boolean bl2 = this.showPopup(mouseEvent);
            if (LOG.isDebugEnabled()) {
                if (bl2) {
                    LOG.debug((Object)"MouseReleased detected as a popup trigger and popup displayed and event consumed");
                    return;
                }
                LOG.debug((Object)"MouseReleased detected as a popup trigger but no popup to display");
            }
            return;
        }
        LOG.debug((Object)"MouseReleased is not a popup trigger");
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || mouseEvent.getModifiers() == 4) {
            boolean bl2 = this.showPopup(mouseEvent);
            if (LOG.isDebugEnabled()) {
                if (bl2) {
                    LOG.debug((Object)"MousePressed detected as a popup and popup displayed and event consumed");
                    return;
                }
                LOG.debug((Object)"MousePressed detected as a popup but no popup to display");
            }
            return;
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || mouseEvent.getModifiers() == 4) {
            boolean bl2 = this.showPopup(mouseEvent);
            if (LOG.isDebugEnabled()) {
                if (bl2) {
                    LOG.debug((Object)"MouseClicked detected as a popup and popup displayed and event consumed");
                    return;
                }
                LOG.debug((Object)"MouseClicked detected as a popup but no popup to display");
            }
        }
    }
}

