/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.properties.ui;

import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.JPanel;
import org.tigris.gef.presentation.Fig;

public class PropSheet
extends JPanel
implements PropertyChangeListener {
    protected Object _sel = null;
    protected Hashtable _pendingStores = new Hashtable();
    protected Hashtable _pdsEditors = new Hashtable();
    protected Hashtable _editorsPds = new Hashtable();
    protected boolean _autoApply = true;
    protected boolean _ignorePropChanges = false;
    protected String _tabName = "Misc";
    protected Font _propertiesFont = new Font("Dialog", 0, 10);
    protected long _lastUpdateTime = System.currentTimeMillis();
    public static final int MIN_UPDATE = 200;

    public void setSelection(Object object) {
        if (this._sel == object) {
            return;
        }
        if (this._sel instanceof Fig) {
            ((Fig)this._sel).removePropertyChangeListener(this);
        }
        this._sel = object;
        if (this._sel instanceof Fig) {
            ((Fig)this._sel).addPropertyChangeListener(this);
        }
        this.updateComponents();
    }

    public void setAutoApply(boolean bl2) {
        this._autoApply = bl2;
        if (this._autoApply) {
            this.apply();
        }
    }

    public String getTabName() {
        return this._tabName;
    }

    public void setTabName(String string) {
        this._tabName = string;
    }

    public boolean canEdit(Object object) {
        return true;
    }

    @Override
    public void setVisible(boolean bl2) {
        super.setVisible(bl2);
        if (!bl2) {
            this.setSelection(null);
        }
    }

    public Font getPropertiesFont() {
        return this._propertiesFont;
    }

    public void setPropertiesFont(Font font) {
        this._propertiesFont = font;
    }

    public void store(PropertyDescriptor propertyDescriptor, Object object) {
        if (propertyDescriptor == null || object == null) {
            return;
        }
        this._pendingStores.put(propertyDescriptor, object);
        if (this._autoApply) {
            this.apply();
        }
    }

    public void apply() {
        try {
            this._ignorePropChanges = true;
            if (this._sel != null) {
                Enumeration enumeration = this._pendingStores.keys();
                while (enumeration.hasMoreElements()) {
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)enumeration.nextElement();
                    this.applyProperty(propertyDescriptor, this._pendingStores.get(propertyDescriptor));
                }
            }
            if (this._sel instanceof Fig) {
                ((Fig)this._sel).endTrans();
            }
            this._pendingStores.clear();
            return;
        }
        finally {
            this.updateComponents();
            this._ignorePropChanges = false;
        }
    }

    protected void applyProperty(PropertyDescriptor propertyDescriptor, Object object) {
        try {
            Object[] objectArray = new Object[]{object};
            Object[] objectArray2 = objectArray;
            objectArray[0] = object;
            propertyDescriptor.getWriteMethod().invoke(this._sel, objectArray2);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            if (invocationTargetException.getTargetException() instanceof PropertyVetoException) {
                System.out.println("Vetoed; because: " + invocationTargetException2.getTargetException().getMessage());
                return;
            }
            System.out.println("InvocationTargetException while updating " + propertyDescriptor.getName() + "\n" + invocationTargetException2.getTargetException().toString());
            return;
        }
        catch (Exception exception) {
            System.out.println("Unexpected exception while updating " + propertyDescriptor.getName() + "\n" + exception.toString());
            return;
        }
    }

    public void revert() {
        this._pendingStores.clear();
        this.updateComponents();
    }

    public void updateComponents() {
    }

    public void updateComponent(PropertyDescriptor propertyDescriptor) {
        this.updateComponents();
    }

    @Override
    public void propertyChange(PropertyChangeEvent object) {
        if (this._ignorePropChanges) {
            return;
        }
        ((PropertyChangeEvent)object).getPropertyName();
        object = ((EventObject)object).getSource();
        if (object == this._sel && !this._ignorePropChanges) {
            long l2 = System.currentTimeMillis();
            if (this._lastUpdateTime + 200L > l2) {
                return;
            }
            this.updateComponents();
            this._lastUpdateTime = l2;
            return;
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this._editorsPds.get(object);
        if (propertyDescriptor != null) {
            this.store(propertyDescriptor, ((PropertyEditor)object).getValue());
        }
    }
}

