/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class ColorFactory {
    private static final Map USED_COLORS_BY_RGB_STRING = new HashMap();
    private static final Map USED_COLORS_BY_RGB_INTEGER = new HashMap();

    private ColorFactory() {
    }

    public static Color getColor(String object, Color color) {
        if ((object = ColorFactory.getColor((String)object)) != null) {
            return object;
        }
        return color;
    }

    public static Color getColor(String object) {
        object = ((String)object).equalsIgnoreCase("white") ? Color.white : (((String)object).equalsIgnoreCase("black") ? Color.black : (((String)object).equalsIgnoreCase("red") ? Color.red : (((String)object).equalsIgnoreCase("green") ? Color.green : (((String)object).equalsIgnoreCase("blue") ? Color.blue : (((String)object).indexOf(32) > 0 ? ColorFactory.getColorByRgb((String)object) : ColorFactory.getColorByRgb(Integer.valueOf((String)object)))))));
        return object;
    }

    private static Color getColorByRgb(String string) {
        Object object = (Color)USED_COLORS_BY_RGB_STRING.get(string);
        if (object == null) {
            object = new StringTokenizer(string, " ");
            int n2 = Integer.parseInt(((StringTokenizer)object).nextToken());
            int n3 = Integer.parseInt(((StringTokenizer)object).nextToken());
            int n4 = Integer.parseInt(((StringTokenizer)object).nextToken());
            object = new Color(n2, n3, n4);
            ColorFactory.cacheColor(string, (Color)object);
        }
        return object;
    }

    private static Color getColorByRgb(Integer n2) {
        Color color = (Color)USED_COLORS_BY_RGB_INTEGER.get(n2);
        if (color == null) {
            color = Color.decode(n2.toString());
            ColorFactory.cacheColor(n2, color);
        }
        return color;
    }

    private static void cacheColor(Color color) {
        ColorFactory.cacheColor(ColorFactory.colorToInteger(color), color);
    }

    private static void cacheColor(String string, Color color) {
        ColorFactory.cacheColor(string, ColorFactory.colorToInteger(color), color);
    }

    private static Integer colorToInteger(Color color) {
        return new Integer(color.getRGB());
    }

    private static void cacheColor(Integer n2, Color color) {
        ColorFactory.cacheColor(color.getRed() + " " + color.getGreen() + " " + color.getBlue(), n2, color);
    }

    private static void cacheColor(String string, Integer n2, Color color) {
        USED_COLORS_BY_RGB_INTEGER.put(n2, color);
        USED_COLORS_BY_RGB_STRING.put(string, color);
    }

    static {
        ColorFactory.cacheColor(Color.white);
        ColorFactory.cacheColor(Color.black);
        ColorFactory.cacheColor(Color.red);
        ColorFactory.cacheColor(Color.green);
        ColorFactory.cacheColor(Color.blue);
    }
}

