/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.utils.noarch.jsonqueue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import ro.deversoft.utils.noarch.FileUtils;
import ro.deversoft.utils.noarch.ProguardKeepMethods;
import ro.deversoft.utils.noarch.ProguardKeepNames;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class JsonPersistentQueue<T>
implements Serializable,
ProguardKeepMethods,
ProguardKeepNames {
    public static final String dateFormat = "yyyy_MM_dd_HH_mm_ss_SSS";
    public static final SimpleDateFormat DATE_TIME_SECONDS_MILLIS_FORMAT = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS");
    private transient String a;
    private transient Map<Class, JsonDeserializer> a = Collections.synchronizedMap(new LinkedHashMap());
    private List<T> list = new Vector<T>();

    public JsonPersistentQueue(String string, Map<Class, JsonDeserializer> map, Type type) {
        this.setFilename(string);
        for (Class object : map.keySet()) {
            this.addDeserializer(object, map.get(object));
        }
        try {
            GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
            gsonBuilder.setDateFormat(dateFormat);
            for (Class clazz : map.keySet()) {
                gsonBuilder.registerTypeAdapter(clazz, map.get(clazz));
            }
            Gson gson = gsonBuilder.create();
            this.list = (List)gson.fromJson((Reader)new FileReader(string), type);
            System.out.println("List : " + this.list);
            return;
        }
        catch (IOException iOException) {
            System.err.println("File " + string + " not found, nothing to read, starting with empty queue !");
            iOException.printStackTrace();
            return;
        }
    }

    public void setFilename(String string) {
        this.a = string;
    }

    public void addDeserializer(Class clazz, JsonDeserializer jsonDeserializer) {
        this.a.put(clazz, jsonDeserializer);
    }

    public synchronized Object getNext() {
        if (this.list != null && this.list.size() > 0) {
            return this.list.get(0);
        }
        return null;
    }

    public synchronized List getAllItemsAsCopy() {
        if (this.list != null && this.list.size() > 0) {
            Vector<T> vector = new Vector<T>();
            for (T t2 : this.list) {
                vector.add(t2);
            }
            return vector;
        }
        return null;
    }

    public synchronized int getSize() {
        return this.list.size();
    }

    public synchronized void removeBon(T t2) {
        this.list.remove(t2);
        this.a();
    }

    public synchronized void addBon(T t2) {
        this.list.add(t2);
        this.a();
    }

    public synchronized void addBonFirst(T t2) {
        this.list.add(0, t2);
        this.a();
    }

    private synchronized void a() {
        String string = new GsonBuilder().setPrettyPrinting().setDateFormat(dateFormat).create().toJson(this.list);
        FileUtils.writeTextToFile(this.a, string);
    }
}

