/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.tigris.gef.base.Editor;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigPainter;
import org.tigris.gef.util.EnumerationEmpty;
import org.tigris.gef.util.EnumerationPredicate;
import org.tigris.gef.util.PredFigInRect;
import org.tigris.gef.util.PredFigNodeInRect;

public abstract class Layer
implements Serializable {
    private String _name = "aLayer";
    private String _type = "aLayer";
    private boolean _hidden = false;
    private boolean _grayed = false;
    private boolean _locked = false;
    private boolean _alwaysOnTop = false;
    private double _scale = 1.0;
    protected boolean _onMenu = false;
    private transient List _editors = new ArrayList();

    public Layer() {
    }

    public Layer(String name) {
        this._name = name;
    }

    public Layer(String name, String type) {
        this._name = name;
        this._type = type;
    }

    public Object clone() {
        Layer lay;
        try {
            lay = (Layer)this.getClass().newInstance();
        }
        catch (IllegalAccessException ignore) {
            return null;
        }
        catch (InstantiationException ignore) {
            return null;
        }
        lay._name = this._name;
        lay._type = this._type;
        lay._onMenu = this._onMenu;
        lay._grayed = this._grayed;
        lay.setHidden(this._hidden);
        lay.setGrayed(this._grayed);
        lay.setScale(this._scale);
        lay.setLocked(this._locked);
        lay.setAlwaysOnTop(this._alwaysOnTop);
        return lay;
    }

    public String toString() {
        return super.toString() + "[" + this._name + "]";
    }

    public String getName() {
        if (this._name == null) {
            return "";
        }
        return this._name;
    }

    public void setName(String n) {
        this._name = n;
    }

    public void setHidden(boolean b) {
        this._hidden = b;
    }

    public boolean getHidden() {
        return this._hidden;
    }

    public void setGrayed(boolean b) {
        this._grayed = b;
    }

    public boolean getGrayed() {
        return this._grayed;
    }

    public void setLocked(boolean b) {
        this._locked = b;
    }

    public boolean getLocked() {
        return this._locked;
    }

    public void setAlwaysOnTop(boolean onTop) {
        this._alwaysOnTop = onTop;
    }

    public boolean isAlwaysOnTop() {
        return this._alwaysOnTop;
    }

    public void setScale(double scale) {
        this._scale = scale;
    }

    public double getScale() {
        return this._scale;
    }

    public void setOnMenu(boolean b) {
        this._onMenu = b;
    }

    public boolean getOnMenu() {
        return this._onMenu;
    }

    public abstract List getContents();

    public List getContentsNoEdges() {
        List contents = this.getContents();
        int size = contents.size();
        Vector v = new Vector(size);
        for (int i = 0; i < size; ++i) {
            Object o = contents.get(i);
            if (o instanceof FigEdge) continue;
            v.add(o);
        }
        return v;
    }

    public List getContentsEdgesOnly() {
        List contents = this.getContents();
        int size = contents.size();
        ArrayList list = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            Object o = contents.get(i);
            if (!(o instanceof FigEdge)) continue;
            list.add(o);
        }
        return list;
    }

    public List getEditors() {
        return new ArrayList(this._editors);
    }

    public void add(Fig f) {
    }

    public void remove(Fig f) {
    }

    public void removeAll() {
    }

    public Enumeration elements() {
        return EnumerationEmpty.theInstance();
    }

    public Fig hit(Rectangle r) {
        return null;
    }

    public Enumeration elementsIn(Rectangle r) {
        return new EnumerationPredicate(this.elements(), new PredFigInRect(r));
    }

    public Enumeration nodesIn(Rectangle r) {
        return new EnumerationPredicate(this.elements(), new PredFigNodeInRect(r));
    }

    public abstract Fig presentationFor(Object var1);

    public String getPerspectiveType() {
        return this._type;
    }

    public void setPerspectiveType(String t) {
        this._type = t;
    }

    public void sendToBack(Fig f) {
    }

    public void bringForward(Fig f) {
    }

    public void sendBackward(Fig f) {
    }

    public void bringToFront(Fig f) {
    }

    public void bringInFrontOf(Fig f1, Fig f2) {
    }

    public void reorder(Fig f, int function) {
    }

    public void print(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.paint(g, null);
    }

    public void paint(Graphics g, FigPainter painter) {
        if (this._hidden) {
            return;
        }
        if (!this._grayed) {
            this.paintContents(g, painter);
        } else {
            this.paintGrayContents(g);
        }
    }

    public void paintContents(Graphics g, FigPainter painter) {
        this.paintContents(g);
    }

    public abstract void paintContents(Graphics var1);

    public void paintGrayContents(Graphics g) {
        g.setColor(Color.lightGray);
        this.paintContents(g);
    }

    public Rectangle calcDrawingArea() {
        Enumeration iter = this.elements();
        if (!iter.hasMoreElements()) {
            return new Rectangle();
        }
        Fig f = (Fig)iter.nextElement();
        Rectangle drawingArea = new Rectangle(f.getBounds());
        while (iter.hasMoreElements()) {
            f = (Fig)iter.nextElement();
            drawingArea.add(f.getBounds());
        }
        drawingArea.grow(4, 4);
        return drawingArea;
    }

    public void damageAll() {
        if (this._editors == null) {
            return;
        }
        int count = this._editors.size();
        for (int editorIndex = 0; editorIndex < count; ++editorIndex) {
            Editor editor = (Editor)this._editors.get(editorIndex);
            editor.damageAll();
        }
    }

    public void deleted(Fig f) {
        if (this._editors == null) {
            return;
        }
        int editorCount = this._editors.size();
        for (int editorIndex = 0; editorIndex < editorCount; ++editorIndex) {
            Editor editor = (Editor)this._editors.get(editorIndex);
            editor.removed(f);
        }
    }

    public void refreshEditors() {
        if (this._editors == null) {
            return;
        }
        int editorCount = this._editors.size();
        for (int editorIndex = 0; editorIndex < editorCount; ++editorIndex) {
            Editor editor = (Editor)this._editors.get(editorIndex);
            editor.damageAll();
        }
    }

    public void addEditor(Editor ed) {
        if (this._editors == null) {
            this._editors = new ArrayList();
        }
        this._editors.add(ed);
    }

    public void removeEditor(Editor ed) {
        if (this._editors == null) {
            return;
        }
        this._editors.remove(ed);
    }

    public void preSave() {
    }

    public void postSave() {
    }

    public void postLoad() {
    }

    public void adjust() {
    }

    public void adjust(HashMap map) {
    }
}

